/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.itemphysic.EventHandler;
import com.creativemd.itemphysic.EventHandlerLite;
import com.creativemd.itemphysic.ItemTransformer;
import com.creativemd.itemphysic.config.ItemConfigSystem;
import com.creativemd.itemphysic.packet.DropPacket;
import com.creativemd.itemphysic.packet.PickupPacket;
import com.creativemd.itemphysic.physics.ClientPhysic;
import com.creativemd.itemphysic.physics.ServerPhysic;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemDummyContainer
extends DummyModContainer {
    public static final String modid = "itemphysic";
    public static final String version = "1.4.0";
    public static final Logger logger = LogManager.getLogger((String)"itemphysic");
    public static Configuration config;
    public static float rotateSpeed;
    public static int despawnItem;
    public static boolean customPickup;
    public static boolean customThrow;
    public static boolean oldRotation;
    public static boolean fallSounds;
    public static boolean showTooltip;
    public static boolean enableIgniting;

    public ItemDummyContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = modid;
        meta.name = "ItemPhysic";
        meta.version = version;
        meta.credits = "CreativeMD";
        meta.authorList = Arrays.asList("CreativeMD");
        meta.description = "";
        meta.url = "";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
    }

    @Subscribe
    public void init(FMLInitializationEvent evt) {
        if (!ItemTransformer.isLite) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
            ItemDummyContainer.initFull();
        } else {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerLite());
        }
    }

    @Optional.Method(modid="creativecore")
    public static void initFull() {
        CreativeCorePacket.registerPacket(DropPacket.class, (String)"IPDrop");
        CreativeCorePacket.registerPacket(PickupPacket.class, (String)"IPPick");
        ServerPhysic.loadItemList();
        try {
            if (!ItemTransformer.isLite && Loader.isModLoaded((String)"igcm")) {
                ItemConfigSystem.loadConfig();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
        config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        if (!ItemTransformer.isLite) {
            despawnItem = config.get("Item", "despawn", 6000).getInt();
            customPickup = config.get("Item", "customPickup", false).getBoolean();
            customThrow = config.get("Item", "customThrow", true).getBoolean();
            fallSounds = config.getBoolean("fallSounds", "Item", true, "If a sound should be played if an entityitem falls on the ground");
            showTooltip = config.getBoolean("showTooltip", "Item", true, "Show the tooltip of an item, if custom pickup is enabled");
            enableIgniting = config.getBoolean("enableIgniting", "Item", true, "If igniting items will be enabled or not.");
        }
        oldRotation = config.get("Item", "oldRotation", false).getBoolean(false);
        rotateSpeed = config.getFloat("rotateSpeed", "Item", 1.0f, 0.0f, 100.0f, "");
        config.save();
    }

    @Subscribe
    @SideOnly(value=Side.CLIENT)
    public void onRender(TickEvent.RenderTickEvent evt) {
        ClientPhysic.tick = System.nanoTime();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent evt) {
    }

    static {
        rotateSpeed = 1.0f;
    }
}

