/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import the_fireplace.mechsoldiers.blocks.BlockCPUMelter;
import the_fireplace.mechsoldiers.blocks.BlockFullMiniTank;
import the_fireplace.mechsoldiers.blocks.BlockHalfMiniTank;
import the_fireplace.mechsoldiers.blocks.BlockMetalPartConstructor;
import the_fireplace.mechsoldiers.blocks.BlockMiniTank;
import the_fireplace.mechsoldiers.blocks.BlockPartStainer;
import the_fireplace.mechsoldiers.blocks.BlockRobotBox;
import the_fireplace.mechsoldiers.blocks.BlockRobotConstructor;
import the_fireplace.mechsoldiers.blocks.DispenseBehaviorPlaceCrate;
import the_fireplace.mechsoldiers.compat.IModCompat;
import the_fireplace.mechsoldiers.compat.ie.IECompat;
import the_fireplace.mechsoldiers.compat.ticon.TiconCompat;
import the_fireplace.mechsoldiers.compat.top.TOPCompatibility;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.mechsoldiers.entity.ai.AlienCPU;
import the_fireplace.mechsoldiers.entity.ai.GreenCPU;
import the_fireplace.mechsoldiers.entity.ai.TerminatorCPU;
import the_fireplace.mechsoldiers.entity.ai.WoodCPU;
import the_fireplace.mechsoldiers.items.ItemBlockMiniTank;
import the_fireplace.mechsoldiers.items.ItemCPU;
import the_fireplace.mechsoldiers.items.ItemJoints;
import the_fireplace.mechsoldiers.items.ItemSkeleton;
import the_fireplace.mechsoldiers.network.CommonProxy;
import the_fireplace.mechsoldiers.network.MSGuiHandler;
import the_fireplace.mechsoldiers.network.PacketDispatcher;
import the_fireplace.mechsoldiers.registry.MechCraftingRecipes;
import the_fireplace.mechsoldiers.registry.PartRegistry;
import the_fireplace.mechsoldiers.tileentity.TileEntityCPUMelter;
import the_fireplace.mechsoldiers.tileentity.TileEntityMiniTank;
import the_fireplace.mechsoldiers.tileentity.TileEntityPartConstructor;
import the_fireplace.mechsoldiers.tileentity.TileEntityPartStainer;
import the_fireplace.mechsoldiers.tileentity.TileEntityRobotBox;
import the_fireplace.mechsoldiers.tileentity.TileEntityRobotConstructor;
import the_fireplace.mechsoldiers.util.ComponentDamageGeneric;
import the_fireplace.mechsoldiers.util.ComponentDamagePotato;
import the_fireplace.mechsoldiers.util.ICPU;
import the_fireplace.mechsoldiers.util.LootHandler;
import the_fireplace.overlord.Overlord;

@Mod.EventBusSubscriber
@Mod(modid="mechsoldiers", name="Mechanical Soldiers", dependencies="required-after:overlord@[2.3.*,);after:theoneprobe;after:tconstruct", version="1.1.2", updateJSON="https://bitbucket.org/The_Fireplace/minecraft-mod-updates/raw/master/mechsoldiers.json", acceptedMinecraftVersions="[1.12,1.13)")
public class MechSoldiers {
    public static final String MODID = "mechsoldiers";
    public static final String MODNAME = "Mechanical Soldiers";
    @Mod.Instance(value="mechsoldiers")
    public static MechSoldiers instance;
    @SidedProxy(clientSide="the_fireplace.mechsoldiers.client.ClientProxy", serverSide="the_fireplace.mechsoldiers.network.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs TAB_ROBOT_PARTS;
    public static final Item skeleton_iron;
    public static final Item skeleton_steel;
    public static final Item skeleton_invar;
    public static final Item skeleton_bronze;
    public static final Item skeleton_term;
    public static final Item skeleton_gold;
    public static final Item skeleton_wood;
    public static final Item joints_iron;
    public static final Item joints_steel;
    public static final Item joints_invar;
    public static final Item joints_bronze;
    public static final Item joints_gold;
    public static final Item cpu_copper_redstone;
    public static final Item cpu_gold_redstone;
    public static final Item cpu_electrum_redstone;
    public static final Item cpu_terminator;
    public static final Item cpu_green;
    public static final Item cpu_alien;
    public static final Item cpu_wood;
    public static final Item blueprint;
    public static final Block robot_constructor;
    public static final Block robot_box;
    public static final Block metal_part_constructor;
    public static final Block metal_part_constructor_active;
    public static final Block cpu_melter;
    public static final Block part_stainer;
    public static final BlockHalfMiniTank mini_tank;
    public static final BlockFullMiniTank full_mini_tank;
    private static IForgeRegistry<Block> blockRegistry;
    private static IForgeRegistry<Item> itemRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IModCompat compat;
        PacketDispatcher.registerPackets();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new MSGuiHandler());
        new PartRegistry();
        GameRegistry.registerTileEntity(TileEntityRobotConstructor.class, (String)"robot_constructor");
        GameRegistry.registerTileEntity(TileEntityRobotBox.class, (String)"robot_box");
        GameRegistry.registerTileEntity(TileEntityPartConstructor.class, (String)"metal_part_constructor");
        GameRegistry.registerTileEntity(TileEntityMiniTank.class, (String)"mini_tank");
        GameRegistry.registerTileEntity(TileEntityCPUMelter.class, (String)"cpu_melter");
        GameRegistry.registerTileEntity(TileEntityPartStainer.class, (String)"part_stainer");
        int eid = -1;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mechsoldiers:mechanical_skeleton"), EntityMechSkeleton.class, (String)"mechanical_skeleton", (int)(++eid), (Object)instance, (int)128, (int)2, (boolean)false);
        proxy.registerClient();
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TOPCompatibility.register();
        }
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            compat = new IECompat();
            compat.preInit(event.getSide().isClient());
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            compat = new TiconCompat();
            compat.preInit(event.getSide().isClient());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        new LootHandler();
        PartRegistry.registerSkeleton(skeleton_iron, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation("overlord", "textures/entity/iron_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_term, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/terminator_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_invar, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/invar_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_steel, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/steel_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_bronze, ComponentDamageGeneric.getInstance(), "bronze", new ResourceLocation(MODID, "textures/entity/bronze_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_gold, ComponentDamageGeneric.getInstance(), "gold", new ResourceLocation(MODID, "textures/entity/gold_skeleton.png"));
        PartRegistry.registerSkeleton(skeleton_wood, ComponentDamageGeneric.getInstance(), "wood", new ResourceLocation(MODID, "textures/entity/wood_skeleton.png"));
        PartRegistry.registerJoints(joints_iron, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/iron_joints.png"));
        PartRegistry.registerJoints(joints_invar, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/invar_joints.png"));
        PartRegistry.registerJoints(joints_steel, ComponentDamageGeneric.getInstance(), "iron", new ResourceLocation(MODID, "textures/entity/steel_joints.png"));
        PartRegistry.registerJoints(joints_bronze, ComponentDamageGeneric.getInstance(), "bronze", new ResourceLocation(MODID, "textures/entity/bronze_joints.png"));
        PartRegistry.registerJoints(joints_gold, ComponentDamageGeneric.getInstance(), "gold", new ResourceLocation(MODID, "textures/entity/gold_joints.png"));
        PartRegistry.registerCPU(cpu_copper_redstone, (ICPU)cpu_copper_redstone, ComponentDamageGeneric.getInstance(), "copper_redstone");
        PartRegistry.registerCPU(cpu_gold_redstone, (ICPU)cpu_gold_redstone, ComponentDamageGeneric.getInstance(), "gold_redstone");
        PartRegistry.registerCPU(cpu_electrum_redstone, (ICPU)cpu_electrum_redstone, ComponentDamageGeneric.getInstance(), "gold_redstone");
        PartRegistry.registerCPU(cpu_terminator, new TerminatorCPU(), ComponentDamageGeneric.getInstance(), "iron");
        PartRegistry.registerCPU(cpu_green, new GreenCPU(), ComponentDamageGeneric.getInstance(), "copper");
        PartRegistry.registerCPU(cpu_wood, new WoodCPU(), ComponentDamageGeneric.getInstance(), "wood_cpu");
        PartRegistry.registerCPU(cpu_alien, new AlienCPU(), ComponentDamageGeneric.getInstance(), "gold");
        PartRegistry.registerPotatoCPU(Items.field_151174_bG, 0, ComponentDamagePotato.getInstance(), "potato");
        PartRegistry.registerPotatoCPU(Items.field_151168_bH, 0, ComponentDamagePotato.getInstance(), "baked_potato");
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)robot_box), (Object)new DispenseBehaviorPlaceCrate());
        if (Loader.isModLoaded((String)"tconstruct")) {
            TiconCompat compat = new TiconCompat();
            compat.init();
        }
    }

    public static void registerBlock(Block block) {
        if (blockRegistry == null) {
            Overlord.logError((String)("Block registry was null, could not register: " + block.func_149739_a()), (Object[])new Object[0]);
            return;
        }
        blockRegistry.register((IForgeRegistryEntry)block);
    }

    public static void registerItem(Item item) {
        if (itemRegistry == null) {
            Overlord.logError((String)("Item registry was null, could not register: " + item.func_77658_a()), (Object[])new Object[0]);
            return;
        }
        itemRegistry.register((IForgeRegistryEntry)item);
    }

    public static void registerItemForBlock(Block block) {
        if (itemRegistry == null) {
            Overlord.logError((String)("Item registry was null, could not register: " + block.func_149739_a()), (Object[])new Object[0]);
            return;
        }
        itemRegistry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    @SubscribeEvent
    public static void itemRegistry(RegistryEvent.Register<Item> event) {
        itemRegistry = event.getRegistry();
        MechSoldiers.registerItem(skeleton_iron);
        MechSoldiers.registerItem(skeleton_steel);
        MechSoldiers.registerItem(skeleton_bronze);
        MechSoldiers.registerItem(skeleton_invar);
        MechSoldiers.registerItem(skeleton_term);
        MechSoldiers.registerItem(skeleton_gold);
        MechSoldiers.registerItem(skeleton_wood);
        MechSoldiers.registerItem(joints_iron);
        MechSoldiers.registerItem(joints_steel);
        MechSoldiers.registerItem(joints_bronze);
        MechSoldiers.registerItem(joints_invar);
        MechSoldiers.registerItem(joints_gold);
        MechSoldiers.registerItem(cpu_copper_redstone);
        MechSoldiers.registerItem(cpu_gold_redstone);
        MechSoldiers.registerItem(cpu_electrum_redstone);
        MechSoldiers.registerItem(cpu_terminator);
        MechSoldiers.registerItem(cpu_green);
        MechSoldiers.registerItem(cpu_wood);
        MechSoldiers.registerItem(cpu_alien);
        MechSoldiers.registerItem(blueprint);
        MechSoldiers.registerItem((Item)new ItemBlock(robot_box).func_77625_d(1).setRegistryName(robot_box.getRegistryName()));
        MechSoldiers.registerItemForBlock(robot_constructor);
        MechSoldiers.registerItemForBlock(metal_part_constructor);
        MechSoldiers.registerItemForBlock(cpu_melter);
        MechSoldiers.registerItemForBlock(part_stainer);
        MechSoldiers.registerItem((Item)new ItemBlockMiniTank((Block)mini_tank, mini_tank, full_mini_tank).setRegistryName("mini_tank"));
        MechCraftingRecipes.register();
    }

    @SubscribeEvent
    public static void blockRegistry(RegistryEvent.Register<Block> event) {
        blockRegistry = event.getRegistry();
        MechSoldiers.registerBlock(robot_box);
        MechSoldiers.registerBlock(robot_constructor);
        MechSoldiers.registerBlock(metal_part_constructor);
        MechSoldiers.registerBlock(cpu_melter);
        MechSoldiers.registerBlock(metal_part_constructor_active);
        MechSoldiers.registerBlock(part_stainer);
        MechSoldiers.registerBlock((Block)mini_tank);
        MechSoldiers.registerBlock((Block)full_mini_tank);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        MechSoldiers.rmm(skeleton_gold);
        MechSoldiers.rmm(skeleton_iron);
        MechSoldiers.rmm(skeleton_steel);
        MechSoldiers.rmm(skeleton_invar);
        MechSoldiers.rmm(skeleton_bronze);
        MechSoldiers.rmm(skeleton_term);
        MechSoldiers.rmm(skeleton_wood);
        MechSoldiers.rmm(joints_gold);
        MechSoldiers.rmm(joints_iron);
        MechSoldiers.rmm(joints_steel);
        MechSoldiers.rmm(joints_invar);
        MechSoldiers.rmm(joints_bronze);
        MechSoldiers.rmm(cpu_copper_redstone);
        MechSoldiers.rmm(cpu_gold_redstone);
        MechSoldiers.rmm(cpu_electrum_redstone);
        MechSoldiers.rmm(cpu_terminator);
        MechSoldiers.rmm(cpu_green);
        MechSoldiers.rmm(cpu_wood);
        MechSoldiers.rmm(cpu_alien);
        MechSoldiers.rmm(blueprint);
        MechSoldiers.rmm(robot_constructor);
        MechSoldiers.rmm(robot_box);
        MechSoldiers.rmm(metal_part_constructor);
        MechSoldiers.rmm((Block)mini_tank);
        MechSoldiers.rmm(cpu_melter);
        MechSoldiers.rmm(part_stainer);
        StateMap robot_constructor_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockRobotConstructor.TRIGGERED}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)robot_constructor, (IStateMapper)robot_constructor_mapper);
        StateMap mini_tank_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockMiniTank.VARIANT_PROPERTY}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)mini_tank, (IStateMapper)mini_tank_mapper);
        StateMap full_mini_tank_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockMiniTank.VARIANT_PROPERTY, BlockSlab.field_176554_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)full_mini_tank, (IStateMapper)full_mini_tank_mapper);
    }

    @SideOnly(value=Side.CLIENT)
    private static void rmm(Block b) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)0, (ModelResourceLocation)new ModelResourceLocation("mechsoldiers:" + b.func_149739_a().substring(5), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void rmm(Item i) {
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation("mechsoldiers:" + i.func_77658_a().substring(5), "inventory"));
    }

    static {
        TAB_ROBOT_PARTS = new CreativeTabs("robot_parts"){

            public ItemStack func_78016_d() {
                return new ItemStack(joints_steel);
            }
        };
        skeleton_iron = new ItemSkeleton("iron", 55);
        skeleton_steel = new ItemSkeleton("steel", 66);
        skeleton_invar = new ItemSkeleton("invar", 33);
        skeleton_bronze = new ItemSkeleton("bronze", 44);
        skeleton_term = new ItemSkeleton("term", 70);
        skeleton_gold = new ItemSkeleton("gold", 13);
        skeleton_wood = new ItemSkeleton("wood", 20);
        joints_iron = new ItemJoints("iron", 116);
        joints_steel = new ItemJoints("steel", 140);
        joints_invar = new ItemJoints("invar", 75);
        joints_bronze = new ItemJoints("bronze", 96);
        joints_gold = new ItemJoints("gold", 18);
        cpu_copper_redstone = new ItemCPU("copper_redstone", 24);
        cpu_gold_redstone = new ItemCPU("gold_redstone", 64);
        cpu_electrum_redstone = new ItemCPU("electrum_redstone", 50);
        cpu_terminator = new ItemCPU("terminator", 32);
        cpu_green = new ItemCPU("green", 40);
        cpu_alien = new ItemCPU("alien", 60);
        cpu_wood = new ItemCPU("wood", 20);
        blueprint = ((Item)new Item().func_77655_b("blueprint").setRegistryName("blueprint")).func_77637_a(CreativeTabs.field_78026_f);
        robot_constructor = new BlockRobotConstructor("robot_constructor");
        robot_box = new BlockRobotBox("robot_box");
        metal_part_constructor = new BlockMetalPartConstructor(false, "metal_part_constructor").func_149647_a(Overlord.tabOverlord);
        metal_part_constructor_active = new BlockMetalPartConstructor(true, "metal_part_constructor_active");
        cpu_melter = new BlockCPUMelter("cpu_melter").func_149647_a(Overlord.tabOverlord);
        part_stainer = new BlockPartStainer("part_stainer");
        mini_tank = new BlockHalfMiniTank();
        full_mini_tank = new BlockFullMiniTank();
        blockRegistry = null;
        itemRegistry = null;
    }
}

