/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.blocks;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.tileentity.TileEntityMiniTank;
import the_fireplace.overlord.Overlord;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BlockMiniTank
extends BlockSlab
implements ITileEntityProvider {
    public static final PropertyBool VARIANT_PROPERTY = PropertyBool.func_177716_a((String)"variant");

    public BlockMiniTank() {
        super(Material.field_151592_s);
        if (!this.func_176552_j()) {
            this.func_149647_a(Overlord.tabOverlord);
        }
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.field_149783_u = true;
        this.func_149663_c("mini_tank");
        this.setRegistryName(this.func_176552_j() ? "full_mini_tank" : "mini_tank");
        IBlockState blockState = this.field_176227_L.func_177621_b();
        blockState = blockState.func_177226_a((IProperty)VARIANT_PROPERTY, (Comparable)Boolean.valueOf(false));
        if (!this.func_176552_j()) {
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(blockState);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMiniTank();
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return false;
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT_PROPERTY;
    }

    public final IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)VARIANT_PROPERTY, (Comparable)Boolean.valueOf(false));
        if (!this.func_176552_j()) {
            BlockSlab.EnumBlockHalf value = BlockSlab.EnumBlockHalf.BOTTOM;
            if ((meta & 8) != 0) {
                value = BlockSlab.EnumBlockHalf.TOP;
            }
            state = state.func_177226_a((IProperty)field_176554_a, (Comparable)value);
        }
        return state;
    }

    public final int func_176201_c(IBlockState state) {
        if (this.func_176552_j()) {
            return 0;
        }
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return 8;
        }
        return 0;
    }

    public final int func_180651_a(IBlockState state) {
        return 0;
    }

    public final Item func_180660_a(IBlockState state, Random rand, int unused) {
        return Item.func_150898_a((Block)MechSoldiers.mini_tank);
    }

    @SideOnly(value=Side.CLIENT)
    public final ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)MechSoldiers.mini_tank);
    }

    protected final BlockStateContainer func_180661_e() {
        if (this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROPERTY});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROPERTY, field_176554_a});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMiniTank) {
            return ((TileEntityMiniTank)tile).getFluidAmount() * 15 / ((TileEntityMiniTank)tile).getCapacity();
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMiniTank && !player.func_70093_af()) {
            boolean interact = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
            if (interact) {
                tile.func_70296_d();
            }
            return interact;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

