/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.blocks;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.tileentity.TileEntityRobotBox;
import the_fireplace.overlord.Overlord;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRobotBox
extends Block
implements ITileEntityProvider {
    NBTTagCompound skellyData = null;

    public BlockRobotBox(String name) {
        super(Material.field_151575_d);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("axe");
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        this.skellyData = placer.func_184586_b(hand).func_77978_p();
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRobotBox(this.skellyData, worldIn.field_73012_v.nextInt(24000) + 12000);
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRobotBox) {
            EntityItem cpu = new EntityItem(worldIn);
            ItemStack cpuStack = ((TileEntityRobotBox)tileentity).getCPU();
            if (cpuStack.func_77984_f()) {
                cpuStack.func_77964_b(Math.round((float)cpuStack.func_77958_k() * ((TileEntityRobotBox)tileentity).getCompletion()));
            }
            cpu.func_92058_a(cpuStack);
            cpu.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)cpu);
            cpu.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            EntityItem joints = new EntityItem(worldIn);
            ItemStack jointStack = ((TileEntityRobotBox)tileentity).getJoints();
            if (jointStack.func_77984_f()) {
                jointStack.func_77964_b(Math.round((float)jointStack.func_77958_k() * ((TileEntityRobotBox)tileentity).getCompletion()));
            }
            joints.func_92058_a(jointStack);
            joints.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)joints);
            joints.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            EntityItem skeleton = new EntityItem(worldIn);
            ItemStack skeletonStack = ((TileEntityRobotBox)tileentity).getSkeleton();
            if (skeletonStack.func_77984_f()) {
                skeletonStack.func_77964_b(Math.round((float)skeletonStack.func_77958_k() * ((TileEntityRobotBox)tileentity).getCompletion()));
            }
            skeleton.func_92058_a(skeletonStack);
            skeleton.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)skeleton);
            skeleton.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pick = new ItemStack(MechSoldiers.robot_box);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRobotBox) {
            NBTTagCompound skellyData = new NBTTagCompound();
            skellyData.func_74782_a("RobotCPU", (NBTBase)((TileEntityRobotBox)te).getCPU().func_77955_b(new NBTTagCompound()));
            skellyData.func_74782_a("RobotSkeleton", (NBTBase)((TileEntityRobotBox)te).getSkeleton().func_77955_b(new NBTTagCompound()));
            skellyData.func_74782_a("RobotJoints", (NBTBase)((TileEntityRobotBox)te).getJoints().func_77955_b(new NBTTagCompound()));
            skellyData.func_74778_a("OwnerUUID", player.func_70093_af() ? player.func_110124_au().toString() : ((TileEntityRobotBox)te).getOwnerId());
            pick.func_77982_d(skellyData);
        }
        return pick;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74764_b("OwnerUUID") && !nbt.func_74779_i("OwnerUUID").isEmpty() && world.func_152378_a(UUID.fromString(nbt.func_74779_i("OwnerUUID"))) != null) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.owner", new Object[0]) + ' ' + world.func_152378_a(UUID.fromString(nbt.func_74779_i("OwnerUUID"))).getDisplayNameString());
            }
            if (nbt.func_74764_b("RobotCPU")) {
                tooltip.add(Overlord.proxy.translateToLocal("color.turq", new Object[0]) + Overlord.proxy.translateToLocal("tooltip.robot_cpu", new Object[0]) + ' ' + new ItemStack(nbt.func_74775_l("RobotCPU")).func_82833_r());
            }
            if (nbt.func_74764_b("RobotSkeleton")) {
                tooltip.add(Overlord.proxy.translateToLocal("color.turq", new Object[0]) + Overlord.proxy.translateToLocal("tooltip.robot_skeleton", new Object[0]) + ' ' + new ItemStack(nbt.func_74775_l("RobotSkeleton")).func_82833_r());
            }
            if (nbt.func_74764_b("RobotJoints")) {
                tooltip.add(Overlord.proxy.translateToLocal("color.turq", new Object[0]) + Overlord.proxy.translateToLocal("tooltip.robot_joints", new Object[0]) + ' ' + new ItemStack(nbt.func_74775_l("RobotJoints")).func_82833_r());
            }
        }
    }
}

