/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.client;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.mechsoldiers.network.PacketDispatcher;
import the_fireplace.mechsoldiers.network.packets.RequestPartsMessage;
import the_fireplace.mechsoldiers.util.StainedItemUtil;
import the_fireplace.overlord.Overlord;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public final class ClientEvents {
    private static Random rand = new Random();
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    public static int splashOffsetCount = 0;
    public static final int finalSplashOffsetCount;
    private static final List<String> mySplashes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void screenload(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            IResource iresource;
            block6: {
                iresource = null;
                try {
                    String s;
                    ArrayList defaultSplashes = Lists.newArrayList();
                    iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));
                    while ((s = bufferedreader.readLine()) != null) {
                        if ((s = s.trim()).isEmpty()) continue;
                        defaultSplashes.add(s);
                    }
                    int splashNum = rand.nextInt(defaultSplashes.size() + finalSplashOffsetCount);
                    if (splashNum < defaultSplashes.size() + finalSplashOffsetCount - mySplashes.size()) break block6;
                    ReflectionHelper.setPrivateValue(GuiMainMenu.class, (Object)((GuiMainMenu)event.getGui()), (Object)mySplashes.get(splashNum - (defaultSplashes.size() + finalSplashOffsetCount - mySplashes.size())), (String[])new String[]{"splashText", "field_73975_c"});
                }
                catch (IOException e) {
                    try {
                        Overlord.logWarn((String)e.getLocalizedMessage(), (Object[])new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(iresource);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)iresource);
                }
            }
            IOUtils.closeQuietly((Closeable)iresource);
        }
    }

    @SubscribeEvent
    public static void modelRegister(ModelRegistryEvent event) {
        MechSoldiers.registerItemRenders();
    }

    @SubscribeEvent
    public static void renderTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("StainColor")) {
            event.getToolTip().add(Overlord.proxy.translateToLocal("stained", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.Pre event) {
        if (event.getStack().func_77942_o() && event.getStack().func_77978_p().func_74764_b("StainColor")) {
            int mouseX = event.getX();
            int mouseY = event.getY();
            int screenWidth = event.getScreenWidth();
            int screenHeight = event.getScreenHeight();
            int maxTextWidth = event.getMaxWidth();
            FontRenderer font = event.getFontRenderer();
            ArrayList<String> textLines = event.getLines();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            int color = -1;
            for (String line : event.getLines()) {
                int textLineWidth = font.func_78256_a(line);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < event.getLines().size(); ++i) {
                    String textLine = (String)event.getLines().get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF, (int)0x505000FF);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847, (int)1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                if (line == null) continue;
                if (TextFormatting.func_110646_a((String)line).equals(Overlord.proxy.translateToLocal("stained", new Object[0]))) {
                    color = StainedItemUtil.getColor(event.getStack()).getRGB();
                    line = TextFormatting.func_110646_a((String)line);
                } else {
                    color = -1;
                }
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, color);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entityDamage(LivingHurtEvent e) {
        if (e.getEntityLiving() instanceof EntityMechSkeleton) {
            PacketDispatcher.sendToServer(new RequestPartsMessage((EntityMechSkeleton)e.getEntityLiving()));
        }
    }

    static {
        mySplashes = Lists.newArrayList((Object[])new String[]{"I'm sorry, Dave. I'm afraid I can't do that.", "...Painted?"});
        splashOffsetCount += mySplashes.size();
        try {
            File file = new File(".splashes");
            if (file.exists()) {
                byte[] encoded = Files.readAllBytes(file.toPath());
                try {
                    splashOffsetCount += Integer.parseInt(new String(encoded, "UTF-8"));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                if (!file.delete()) {
                    Overlord.logWarn((String)"Splashes file could not be deleted", (Object[])new Object[0]);
                }
            }
            file.createNewFile();
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            fw.write(String.valueOf(splashOffsetCount));
            fw.close();
        }
        catch (IOException e) {
            Overlord.logWarn((String)e.getLocalizedMessage(), (Object[])new Object[0]);
        }
        finalSplashOffsetCount = splashOffsetCount;
    }
}

