/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.client.gui;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import the_fireplace.mechsoldiers.container.ContainerRobot;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.AttackModeMessage;
import the_fireplace.overlord.network.packets.MovementModeMessage;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.network.packets.SetSquadMessage;
import the_fireplace.overlord.tools.ArmyUtils;

public class GuiRobot
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("mechsoldiers", "textures/gui/mech_skeleton.png");
    private EntityMechSkeleton entity;
    private GuiButton attackMode;
    private byte attackModeTimer;
    private GuiButton movementMode;
    private byte movementModeTimer;
    private ArrayList<String> squads;
    private int squadIndex;

    public GuiRobot(InventoryPlayer inventorySlotsIn, EntityMechSkeleton warrior, ArrayList<String> squads) {
        super((Container)new ContainerRobot(inventorySlotsIn, warrior));
        this.entity = warrior;
        this.field_146999_f = 175;
        this.field_147000_g = 165;
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = res.func_78326_a();
        this.field_146295_m = res.func_78328_b();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.squads = squads;
        this.squadIndex = squads.indexOf(warrior.getSquad());
    }

    public void func_73866_w_() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = res.func_78326_a();
        this.field_146295_m = res.func_78328_b();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.attackMode = new GuiButton(0, this.field_147003_i + 102, this.field_147009_r + 34, 66, 20, "You should not see this");
        this.field_146292_n.add(this.attackMode);
        this.movementMode = new GuiButton(1, this.field_147003_i + 102, this.field_147009_r + 58, 66, 20, "You should not see this");
        this.field_146292_n.add(this.movementMode);
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 5, this.field_147009_r + 49, 20, 20, "<-"));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 74, this.field_147009_r + 49, 20, 20, "->"));
        this.setAttackModeText();
        this.setMovementModeText();
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                PacketDispatcher.sendToServer((IMessage)new AttackModeMessage((EntityArmyMember)this.entity));
                this.setAttackModeText();
                this.scheduleAttackModeTextUpdate();
            } else if (button.field_146127_k == 1) {
                PacketDispatcher.sendToServer((IMessage)new MovementModeMessage((EntityArmyMember)this.entity));
                this.setMovementModeText();
                this.scheduleMovementModeTextUpdate();
            } else if (button.field_146127_k == 2) {
                this.squadIndex = this.squadIndex < 0 ? this.squads.size() - 1 : --this.squadIndex;
            } else if (button.field_146127_k == 3) {
                this.squadIndex = this.squadIndex >= this.squads.size() - 1 ? -1 : ++this.squadIndex;
            }
            if (this.squadIndex > -1) {
                PacketDispatcher.sendToServer((IMessage)new SetSquadMessage((EntityArmyMember)this.entity, this.squads.get(this.squadIndex)));
            } else {
                PacketDispatcher.sendToServer((IMessage)new SetSquadMessage((EntityArmyMember)this.entity, ""));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiRobot.func_73734_a((int)26, (int)49, (int)73, (int)69, (int)new Color(0, 0, 0, 100).getRGB());
        this.func_73732_a(this.field_146289_q, this.squadIndex != -1 ? this.squads.get(this.squadIndex) : I18n.func_135052_a((String)"overlord.no_squad", (Object[])new Object[0]), 50, 55, -1);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        if (this.attackModeTimer > 0) {
            this.attackModeTimer = (byte)(this.attackModeTimer - 1);
        }
        if (this.attackModeTimer == 1) {
            this.setAttackModeText();
        }
        if (this.movementModeTimer > 0) {
            this.movementModeTimer = (byte)(this.movementModeTimer - 1);
        }
        if (this.movementModeTimer == 1) {
            this.setMovementModeText();
        }
        super.func_73876_c();
        if (!this.entity.func_70089_S() || this.entity.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void setAttackModeText() {
        this.attackMode.field_146126_j = ArmyUtils.getAttackModeString((byte)this.entity.getAttackMode());
    }

    public void setMovementModeText() {
        this.movementMode.field_146126_j = ArmyUtils.getMovementModeString((byte)this.entity.getMovementMode());
    }

    public void scheduleAttackModeTextUpdate() {
        this.attackModeTimer = (byte)5;
    }

    public void scheduleMovementModeTextUpdate() {
        this.movementModeTimer = (byte)5;
    }

    public void func_146281_b() {
        if (this.entity.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer((IMessage)new RequestAugmentMessage((EntityArmyMember)this.entity));
        }
        super.func_146281_b();
    }
}

