/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.client.render;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class FluidRenderer {
    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        float xt = (float)((double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b);
        float yt = (float)((double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c);
        float zt = (float)((double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.func_179109_b((float)xt, (float)yt, (float)zt);
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        int brightness = mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        buff.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        FluidRenderer.addQuad(buff, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness);
        FluidRenderer.addQuad(buff, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness);
        FluidRenderer.addQuad(buff, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness);
        FluidRenderer.addQuad(buff, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness);
        FluidRenderer.addQuad(buff, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness);
        FluidRenderer.addQuad(buff, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness);
        tess.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    private static void addQuad(BufferBuilder buff, TextureAtlasSprite sprite, double x, double y, double z, double width, double height, double length, EnumFacing face, int color, int brightness) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double vz1;
        double vy1;
        double u1;
        if (sprite == null) {
            return;
        }
        int flv = brightness >> 16 & 0xFFFF;
        int slv = brightness & 0xFFFF;
        Color colorval = new Color(color);
        int alpha = colorval.getAlpha();
        int red = colorval.getRed();
        int green = colorval.getGreen();
        int blue = colorval.getBlue();
        double size = 16.0;
        double x2 = x + width;
        double y2 = y + height;
        double z2 = z + length;
        double u = x % 1.0;
        for (u1 = u + width; u1 > 1.0; u1 -= 1.0) {
        }
        double vy = y % 1.0;
        for (vy1 = vy + height; vy1 > 1.0; vy1 -= 1.0) {
        }
        double vz = z % 1.0;
        for (vz1 = vz + length; vz1 > 1.0; vz1 -= 1.0) {
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(u * 16.0);
                maxU = sprite.func_94214_a(u1 * 16.0);
                minV = sprite.func_94207_b(vz * 16.0);
                maxV = sprite.func_94207_b(vz1 * 16.0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(u1 * 16.0);
                maxU = sprite.func_94214_a(u * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(vz1 * 16.0);
                maxU = sprite.func_94214_a(vz * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                buff.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                break;
            }
            case UP: {
                buff.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                break;
            }
            case NORTH: {
                buff.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
                break;
            }
            case SOUTH: {
                buff.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                break;
            }
            case WEST: {
                buff.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                break;
            }
            case EAST: {
                buff.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(flv, slv).func_181675_d();
                buff.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(flv, slv).func_181675_d();
            }
        }
    }
}

