/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.client.render;

import java.awt.Color;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.mechsoldiers.util.StainedItemUtil;
import the_fireplace.overlord.entity.EntityArmyMember;

@SideOnly(value=Side.CLIENT)
public class ModelMechSkeleton
extends ModelBiped {
    public ModelRenderer neck;
    public ModelRenderer rightShoulder;
    public ModelRenderer leftShoulder;
    public ModelRenderer rightElbow;
    public ModelRenderer leftElbow;
    public ModelRenderer rightKnee;
    public ModelRenderer leftKnee;
    public boolean isJointLayer;

    public ModelMechSkeleton() {
        this(0.0f, false);
    }

    public ModelMechSkeleton(float modelSize, boolean isJointLayer) {
        super(modelSize, 0.0f, isJointLayer ? 24 : 64, isJointLayer ? 12 : 32);
        this.isJointLayer = isJointLayer;
        this.field_78116_c = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_78116_c.func_78790_a(-4.0f, -9.0f, -4.0f, 8, 8, 8, modelSize);
        this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178720_f = new ModelRenderer((ModelBase)this, 32, 0);
        this.field_178720_f.func_78790_a(-4.0f, -9.0f, -4.0f, 8, 8, 8, modelSize + 0.5f);
        this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178723_h = new ModelRenderer((ModelBase)this, 40, 16);
        this.field_178723_h.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, modelSize);
        this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.field_178724_i = new ModelRenderer((ModelBase)this, 40, 16);
        this.field_178724_i.field_78809_i = true;
        this.field_178724_i.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, modelSize);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.field_178721_j = new ModelRenderer((ModelBase)this, 0, 16);
        this.field_178721_j.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, modelSize);
        this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
        this.field_178722_k = new ModelRenderer((ModelBase)this, 0, 16);
        this.field_178722_k.field_78809_i = true;
        this.field_178722_k.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, modelSize);
        this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        if (isJointLayer) {
            this.neck = new ModelRenderer((ModelBase)this, 0, 0);
            this.neck.func_78790_a(-3.0f, -1.0f, -3.0f, 6, 1, 6, modelSize);
            this.leftElbow = new ModelRenderer((ModelBase)this, 8, 8);
            this.leftElbow.func_78790_a(-1.1f, 3.0f, -1.0f, 2, 2, 2, modelSize * 1.1f);
            this.leftElbow.func_78793_a(5.0f, 2.0f, 0.0f);
            this.rightElbow = new ModelRenderer((ModelBase)this, 8, 8);
            this.rightElbow.func_78790_a(-1.1f, 3.0f, -1.0f, 2, 2, 2, modelSize * 1.1f);
            this.rightElbow.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.rightElbow.field_78809_i = true;
            this.leftKnee = new ModelRenderer((ModelBase)this, 0, 8);
            this.leftKnee.func_78790_a(-1.0f, 5.0f, -1.0f, 2, 2, 2, modelSize * 1.1f);
            this.leftKnee.func_78793_a(2.0f, 12.0f, 0.0f);
            this.rightKnee = new ModelRenderer((ModelBase)this, 0, 8);
            this.rightKnee.func_78790_a(-1.0f, 5.0f, -1.0f, 2, 2, 2, modelSize * 1.1f);
            this.rightKnee.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.rightKnee.field_78809_i = true;
            this.leftShoulder = new ModelRenderer((ModelBase)this, 16, 7);
            this.leftShoulder.func_78790_a(3.5f, -0.1f, -1.5f, 1, 2, 3, modelSize);
            this.rightShoulder = new ModelRenderer((ModelBase)this, 16, 7);
            this.rightShoulder.func_78790_a(-4.5f, -0.1f, -1.5f, 1, 2, 3, modelSize);
            this.rightShoulder.field_78809_i = true;
        }
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.field_187076_m = ModelBiped.ArmPose.EMPTY;
        this.field_187075_l = ModelBiped.ArmPose.EMPTY;
        ItemStack itemstack = entitylivingbaseIn.func_184586_b(EnumHand.MAIN_HAND);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151031_f && ((EntityArmyMember)entitylivingbaseIn).isSwingingArms()) {
            if (entitylivingbaseIn.func_184591_cq() == EnumHandSide.RIGHT) {
                this.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            } else {
                this.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
        super.func_78086_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!this.isJointLayer) {
            EntityMechSkeleton entityskeleton = (EntityMechSkeleton)entityIn;
            Color color = StainedItemUtil.getColor(entityskeleton.getSkeleton());
            if (color != null) {
                GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f / 2.0f), (float)((float)color.getGreen() / 255.0f / 2.0f), (float)((float)color.getBlue() / 255.0f / 2.0f));
            }
            super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (color != null) {
                GlStateManager.func_179117_G();
            }
        } else {
            EntityMechSkeleton entityskeleton = (EntityMechSkeleton)entityIn;
            Color color = StainedItemUtil.getColor(entityskeleton.getJoints());
            if (color != null) {
                GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f / 2.0f), (float)((float)color.getGreen() / 255.0f / 2.0f), (float)((float)color.getBlue() / 255.0f / 2.0f));
            }
            this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
            GlStateManager.func_179094_E();
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.neck.func_78785_a(scale);
            this.rightShoulder.func_78785_a(scale);
            this.leftShoulder.func_78785_a(scale);
            this.rightElbow.func_78785_a(scale);
            this.leftElbow.func_78785_a(scale);
            this.rightKnee.func_78785_a(scale);
            this.leftKnee.func_78785_a(scale);
            GlStateManager.func_179121_F();
            if (color != null) {
                GlStateManager.func_179117_G();
            }
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        ItemStack itemstack = ((EntityLivingBase)entityIn).func_184614_ca();
        EntityMechSkeleton entityskeleton = (EntityMechSkeleton)entityIn;
        if (entityskeleton.isSwingingArms() && (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151031_f)) {
            float f = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_78095_p) * (1.0f - this.field_78095_p)) * (float)Math.PI));
            this.field_178723_h.field_78808_h = 0.0f;
            this.field_178724_i.field_78808_h = 0.0f;
            this.field_178723_h.field_78796_g = -(0.1f - f * 0.6f);
            this.field_178724_i.field_78796_g = 0.1f - f * 0.6f;
            this.field_178723_h.field_78795_f = -1.5707964f;
            this.field_178724_i.field_78795_f = -1.5707964f;
            this.field_178723_h.field_78795_f -= f * 1.2f - f1 * 0.4f;
            this.field_178724_i.field_78795_f -= f * 1.2f - f1 * 0.4f;
            this.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
            this.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        if (this.isJointLayer) {
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.leftKnee);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.rightKnee);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.leftElbow);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.rightElbow);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.rightShoulder);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.leftShoulder);
            ModelMechSkeleton.func_178685_a((ModelRenderer)this.field_78116_c, (ModelRenderer)this.neck);
        }
    }

    public void func_187073_a(float scale, EnumHandSide side) {
        float f = side == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        ModelRenderer modelrenderer = this.func_187074_a(side);
        modelrenderer.field_78800_c += f;
        modelrenderer.func_78794_c(scale);
        modelrenderer.field_78800_c -= f;
        if (this.isJointLayer) {
            ModelRenderer elbow = side == EnumHandSide.RIGHT ? this.rightElbow : this.leftElbow;
            elbow.field_78800_c += f;
            elbow.func_78794_c(scale);
            elbow.field_78800_c -= f;
        }
    }
}

