/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.compat.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import the_fireplace.mechsoldiers.compat.jei.CPUMeltRecipe;
import the_fireplace.mechsoldiers.compat.jei.MetalMeltRecipe;
import the_fireplace.mechsoldiers.registry.CPUMeltRecipes;
import the_fireplace.mechsoldiers.registry.MetalMeltRecipes;

public class RecipeMaker {
    public static IStackHelper stackHelper;

    @Nonnull
    public static List<MetalMeltRecipe> getMetalMeltRecipes(IJeiHelpers helpers) {
        stackHelper = helpers.getStackHelper();
        MetalMeltRecipes furnaceRecipes = MetalMeltRecipes.instance();
        Map<ItemStack, Object> smeltingRight = furnaceRecipes.getSmeltingListRight();
        Map<ItemStack, Object> smeltingLeft = furnaceRecipes.getSmeltingListLeft();
        ArrayList<MetalMeltRecipe> recipes = new ArrayList<MetalMeltRecipe>();
        for (Map.Entry<ItemStack, Object> itemStackItemStackEntry : smeltingRight.entrySet()) {
            ItemStack output = itemStackItemStackEntry.getKey();
            Object input1 = smeltingLeft.get(output);
            Object input2 = itemStackItemStackEntry.getValue();
            LinkedList inputs = Lists.newLinkedList();
            inputs.add(input2);
            inputs.add(input1);
            MetalMeltRecipe recipe = new MetalMeltRecipe(inputs, output);
            if (!RecipeMaker.isRecipeValid(recipe)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Nonnull
    public static List<CPUMeltRecipe> getCPUMeltRecipes(IJeiHelpers helpers) {
        stackHelper = helpers.getStackHelper();
        CPUMeltRecipes furnaceRecipes = CPUMeltRecipes.instance();
        Map<ItemStack, Object> smeltingRight = furnaceRecipes.getSmeltingListRight();
        Map<ItemStack, Object> smeltingLeft = furnaceRecipes.getSmeltingListLeft();
        ArrayList<CPUMeltRecipe> recipes = new ArrayList<CPUMeltRecipe>();
        for (Map.Entry<ItemStack, Object> itemStackItemStackEntry : smeltingRight.entrySet()) {
            ItemStack output = itemStackItemStackEntry.getKey();
            Object input1 = smeltingLeft.get(output);
            Object input2 = itemStackItemStackEntry.getValue();
            LinkedList inputs = Lists.newLinkedList();
            inputs.add(input1);
            inputs.add(input2);
            CPUMeltRecipe recipe = new CPUMeltRecipe(inputs, output);
            if (!RecipeMaker.isRecipeValid(recipe)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public static boolean isRecipeValid(MetalMeltRecipe recipe) {
        String recipeInfo;
        if (recipe.outputs.isEmpty()) {
            String recipeInfo2 = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe has no outputs. {}", (Object)recipeInfo2);
            return false;
        }
        int inputCount = 0;
        for (List<ItemStack> input : recipe.input) {
            if (input instanceof List && input.isEmpty()) {
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount == 0) {
            recipeInfo = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe has no inputs. {}", (Object)recipeInfo);
            return false;
        }
        if (inputCount < 2) {
            recipeInfo = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe does not have enough inputs. {}", (Object)recipeInfo);
            return false;
        }
        return true;
    }

    public static boolean isRecipeValid(CPUMeltRecipe recipe) {
        String recipeInfo;
        if (recipe.outputs.isEmpty()) {
            String recipeInfo2 = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe has no outputs. {}", (Object)recipeInfo2);
            return false;
        }
        int inputCount = 0;
        for (List<ItemStack> input : recipe.input) {
            if (input instanceof List && input.isEmpty()) {
                return false;
            }
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount == 0) {
            recipeInfo = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe has no inputs. {}", (Object)recipeInfo);
            return false;
        }
        if (inputCount < 2) {
            recipeInfo = ErrorUtil.getInfoFromRecipe((Object)recipe, (IRecipeWrapper)recipe);
            Log.get().error("Recipe does not have enough inputs. {}", (Object)recipeInfo);
            return false;
        }
        return true;
    }
}

