/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.entity;

import com.google.common.collect.Lists;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.registry.PartRegistry;
import the_fireplace.mechsoldiers.util.EnumPartType;
import the_fireplace.mechsoldiers.util.ICPU;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.registry.AugmentRegistry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EntityMechSkeleton
extends EntityArmyMember {
    public boolean cachedClientParts = false;
    public final InventoryBasic equipInventory;
    public final InventoryBasic partInventory;
    private DamageSource actualDamageSource = DamageSource.field_76377_j;

    public EntityMechSkeleton(World world) {
        this(world, null);
    }

    public EntityMechSkeleton(World world, @Nullable UUID owner) {
        super(world, owner);
        this.equipInventory = new InventoryBasic("Equipment", false, 3){

            public boolean func_94041_b(int index, ItemStack stack) {
                return index >= 0 && index < 2 || index == 2 && AugmentRegistry.getAugment((ItemStack)stack) != null;
            }

            public void func_70299_a(int index, ItemStack stack) {
                super.func_70299_a(index, stack);
                if (EntityMechSkeleton.this.field_70170_p.field_72995_K && index == 2) {
                    PacketDispatcher.sendToServer((IMessage)new RequestAugmentMessage((EntityArmyMember)EntityMechSkeleton.this));
                }
            }

            public ItemStack func_70304_b(int index) {
                ItemStack stack = super.func_70304_b(index);
                if (EntityMechSkeleton.this.field_70170_p.field_72995_K && index == 2) {
                    PacketDispatcher.sendToServer((IMessage)new RequestAugmentMessage((EntityArmyMember)EntityMechSkeleton.this));
                }
                return stack;
            }

            public ItemStack func_70298_a(int index, int count) {
                ItemStack stack = super.func_70298_a(index, count);
                if (EntityMechSkeleton.this.field_70170_p.field_72995_K && index == 2) {
                    PacketDispatcher.sendToServer((IMessage)new RequestAugmentMessage((EntityArmyMember)EntityMechSkeleton.this));
                }
                return stack;
            }
        };
        this.partInventory = new InventoryBasic("Parts", false, 3){

            public boolean func_94041_b(int index, ItemStack stack) {
                return index == 0 && PartRegistry.isPartOfType(stack, EnumPartType.SKELETON) || index == 1 && PartRegistry.isPartOfType(stack, EnumPartType.JOINTS) || index == 2 && PartRegistry.isPartOfType(stack, EnumPartType.CPU);
            }
        };
    }

    public void addMovementTasks() {
        ICPU cpu;
        if (!this.getCPU().func_190926_b() && (cpu = PartRegistry.getCPU(this.getCPU())) != null) {
            cpu.addMovementAi(this, this.getMovementMode());
        }
    }

    public void addAttackTasks() {
        ICPU cpu;
        if (!this.getCPU().func_190926_b() && (cpu = PartRegistry.getCPU(this.getCPU())) != null) {
            cpu.addAttackAi(this, this.getAttackMode());
        }
    }

    public void addTargetTasks() {
        ICPU cpu;
        if (!this.getCPU().func_190926_b() && (cpu = PartRegistry.getCPU(this.getCPU())) != null) {
            cpu.addTargetAi(this, this.getAttackMode());
        }
    }

    public void func_70636_d() {
        if (this.getJoints().func_190926_b() || this.getSkeleton().func_190926_b()) {
            this.func_174812_G();
        }
        super.func_70636_d();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (this.field_70173_aa <= 3) {
            this.func_184651_r();
        }
        if (!this.func_180431_b(damageSrc)) {
            if (damageSrc != DamageSource.field_76380_i) {
                this.actualDamageSource = damageSrc;
            } else {
                this.func_70606_j(0.0f);
            }
            damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount);
            if (damageAmount <= 0.0f) {
                return;
            }
            damageAmount = this.func_70655_b(damageSrc, damageAmount);
            float f = damageAmount = this.func_70672_c(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - damageAmount));
            if (damageAmount != 0.0f) {
                float f1 = this.func_110143_aJ();
                this.damageComponents(damageSrc, damageAmount);
                this.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
                this.func_110149_m(this.func_110139_bj() - damageAmount);
            }
        }
    }

    protected void damageComponents(DamageSource damageSrc, float damageAmount) {
        if (damageSrc == DamageSource.field_82728_o) {
            this.setCPU(PartRegistry.damagePart(this.getCPU(), damageSrc, damageAmount, (EntityLivingBase)this));
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, damageAmount / 4.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, damageAmount / 4.0f, (EntityLivingBase)this));
        } else if (damageSrc == DamageSource.field_188407_q) {
            this.setCPU(PartRegistry.damagePart(this.getCPU(), damageSrc, damageAmount / 4.0f, (EntityLivingBase)this));
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, damageAmount / 3.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, damageAmount / 3.0f, (EntityLivingBase)this));
        } else if (damageSrc == DamageSource.field_76379_h) {
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, damageAmount / 5.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, damageAmount, (EntityLivingBase)this));
        } else if (damageSrc == DamageSource.field_180137_b) {
            this.setCPU(PartRegistry.damagePart(this.getCPU(), damageSrc, damageAmount, (EntityLivingBase)this));
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, damageAmount / 2.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, damageAmount / 2.0f, (EntityLivingBase)this));
        } else if (damageSrc.func_76347_k() || damageSrc.func_94541_c()) {
            this.setCPU(PartRegistry.damagePart(this.getCPU(), damageSrc, damageAmount / 3.0f, (EntityLivingBase)this));
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, damageAmount / 3.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, damageAmount / 3.0f, (EntityLivingBase)this));
        } else {
            this.setCPU(PartRegistry.damagePart(this.getCPU(), damageSrc, damageAmount / 12.0f, (EntityLivingBase)this));
            this.setSkeleton(PartRegistry.damagePart(this.getSkeleton(), damageSrc, 3.0f * damageAmount / 4.0f, (EntityLivingBase)this));
            this.setJoints(PartRegistry.damagePart(this.getJoints(), damageSrc, 3.0f * damageAmount / 7.0f, (EntityLivingBase)this));
        }
    }

    public ItemStack getCPU() {
        if (this.partInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.partInventory.func_70301_a(2);
    }

    public EntityMechSkeleton setCPU(ItemStack cpu) {
        if (this.partInventory == null) {
            return this;
        }
        this.partInventory.func_70299_a(2, cpu);
        this.func_184651_r();
        return this;
    }

    public ItemStack getJoints() {
        if (this.partInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.partInventory.func_70301_a(1);
    }

    public EntityMechSkeleton setJoints(ItemStack joints) {
        if (this.partInventory == null) {
            return this;
        }
        this.partInventory.func_70299_a(1, joints);
        return this;
    }

    public ItemStack getSkeleton() {
        if (this.partInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.partInventory.func_70301_a(0);
    }

    public EntityMechSkeleton setSkeleton(ItemStack skeleton) {
        if (this.partInventory == null) {
            return this;
        }
        this.partInventory.func_70299_a(0, skeleton);
        return this;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(this.actualDamageSource);
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entityitem;
            int i;
            for (i = 0; i < this.partInventory.func_70302_i_(); ++i) {
                if (this.partInventory.func_70301_a(i).func_190926_b()) continue;
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.partInventory.func_70301_a(i));
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
                if (this.equipInventory.func_70301_a(i).func_190926_b()) continue;
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.equipInventory.func_70301_a(i));
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagList mainInv = (NBTTagList)compound.func_74781_a("SkeletonParts");
        if (mainInv != null) {
            for (int i = 0; i < mainInv.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)mainInv.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonParts");
                if (slot < 0 || slot >= this.partInventory.func_70302_i_()) continue;
                this.partInventory.func_70299_a((int)slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn((String)"List was null when reading Mechanical Skeleton's Inventory", (Object[])new Object[0]);
        }
        NBTTagList armorInv = (NBTTagList)compound.func_74781_a("SkeletonEquipment");
        if (armorInv != null) {
            for (int i = 0; i < armorInv.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)armorInv.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonEquipment");
                if (slot < 0 || slot >= this.equipInventory.func_70302_i_()) continue;
                this.equipInventory.func_70299_a((int)slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn((String)"List was null when reading Mechanical Skeleton's Equipment", (Object[])new Object[0]);
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList mainInv = new NBTTagList();
        for (int i = 0; i < this.partInventory.func_70302_i_(); ++i) {
            ItemStack is = this.partInventory.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonParts", (byte)i);
            is.func_77955_b(item);
            mainInv.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("SkeletonParts", (NBTBase)mainInv);
        NBTTagList armorInv = new NBTTagList();
        for (int i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
            ItemStack is = this.equipInventory.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonEquipment", (byte)i);
            is.func_77955_b(item);
            armorInv.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("SkeletonEquipment", (NBTBase)armorInv);
    }

    public float func_70047_e() {
        return 1.84f;
    }

    public double func_70033_W() {
        return -0.35;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(999.0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getOwner() != null && this.getOwner().equals((Object)player) && !player.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MechSoldiers.instance, (int)this.hashCode(), (World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v));
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.MAINHAND ? this.equipInventory.func_70301_a(0) : (slotIn == EntityEquipmentSlot.OFFHAND ? this.equipInventory.func_70301_a(1) : ItemStack.field_190927_a);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(0, stack);
            this.func_184651_r();
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(1, stack);
        }
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()});
    }

    public ItemStack func_184614_ca() {
        if (this.equipInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.equipInventory.func_70301_a(0);
    }

    public ItemStack func_184592_cb() {
        if (this.equipInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.equipInventory.func_70301_a(1);
    }

    public ItemStack func_184586_b(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184614_ca();
        }
        if (hand == EnumHand.OFF_HAND) {
            return this.func_184592_cb();
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void func_184611_a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != EnumHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
        }
    }
}

