/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.mechsoldiers.entity.ai.EntityAITeleport;
import the_fireplace.mechsoldiers.util.ICPU;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.entity.ai.EntityAIFollowMaster;
import the_fireplace.overlord.entity.ai.EntityAIHurtByNonAllied;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtByTarget;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtTarget;
import the_fireplace.overlord.entity.ai.EntityAINearestNonTeamTarget;
import the_fireplace.overlord.entity.ai.EntityAIWanderBase;

public class AlienCPU
implements ICPU {
    protected int raiseArmTicks;
    protected EntityAIAttackMelee aiAttackOnCollide = null;

    @Override
    public void addAttackAi(final EntityMechSkeleton skeleton, byte mode) {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)skeleton, 2.0, false){

                public void func_75251_c() {
                    super.func_75251_c();
                    skeleton.setSwingingArms(false);
                    if (skeleton.func_70681_au().nextInt(5) == 3) {
                        double d0 = skeleton.field_70165_t + (skeleton.field_70170_p.field_73012_v.nextDouble() - 0.5) * 64.0;
                        double d1 = skeleton.field_70163_u + (double)(skeleton.field_70170_p.field_73012_v.nextInt(64) - 32);
                        double d2 = skeleton.field_70161_v + (skeleton.field_70170_p.field_73012_v.nextDouble() - 0.5) * 64.0;
                        EntityAITeleport.teleportTo(skeleton, d0, d1, d2);
                    }
                }

                public void func_75249_e() {
                    super.func_75249_e();
                    AlienCPU.this.raiseArmTicks = 0;
                }

                public void func_75246_d() {
                    if (this.func_75253_b()) {
                        ++AlienCPU.this.raiseArmTicks;
                        if (AlienCPU.this.raiseArmTicks >= 5 && this.field_75439_d < 10) {
                            skeleton.setSwingingArms(true);
                        } else {
                            skeleton.setSwingingArms(false);
                        }
                        super.func_75246_d();
                    }
                }
            };
        }
        if (skeleton.getMovementMode() > 0) {
            skeleton.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    @Override
    public void addTargetAi(EntityMechSkeleton skeleton, byte mode) {
        switch (mode) {
            case 2: {
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMasterHurtTarget((EntityArmyMember)skeleton));
            }
            case 1: {
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, EntityPlayer.class, false));
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, EntityArmyMember.class, true));
                skeleton.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, IMob.class, true));
            }
        }
        skeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIMasterHurtByTarget((EntityArmyMember)skeleton));
        skeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByNonAllied((EntityArmyMember)skeleton, true, new Class[0]));
        skeleton.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, IAnimals.class, false));
    }

    @Override
    public void addMovementAi(EntityMechSkeleton skeleton, byte mode) {
        switch (mode) {
            case 1: {
                skeleton.func_175449_a(new BlockPos(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v), -1);
                skeleton.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITeleport(skeleton));
                skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)skeleton, false));
                skeleton.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowMaster((EntityArmyMember)skeleton, 1.0, 20.0f, 1.0f));
                skeleton.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderBase((EntityArmyMember)skeleton, 1.0));
                break;
            }
            case 0: {
                skeleton.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITeleport(skeleton));
                break;
            }
            default: {
                skeleton.func_175449_a(new BlockPos(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v), 20);
                skeleton.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITeleport(skeleton));
                skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)skeleton, false));
                skeleton.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderBase((EntityArmyMember)skeleton, 1.0));
            }
        }
    }
}

