/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.items;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.mechsoldiers.util.ICPU;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.entity.ai.EntityAIFollowMaster;
import the_fireplace.overlord.entity.ai.EntityAIHurtByNonAllied;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtByTarget;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtTarget;
import the_fireplace.overlord.entity.ai.EntityAINearestNonTeamTarget;
import the_fireplace.overlord.entity.ai.EntityAIWanderBase;

public class ItemCPU
extends Item
implements ICPU {
    private String material;
    protected int raiseArmTicks;
    protected EntityAIAttackMelee aiAttackOnCollide = null;

    public ItemCPU(String material, int durability) {
        this.func_77655_b("cpu_" + material);
        this.setRegistryName("cpu_" + material);
        this.func_77656_e(durability);
        this.material = material;
        this.func_77637_a(MechSoldiers.TAB_ROBOT_PARTS);
    }

    @Override
    public void addAttackAi(final EntityMechSkeleton skeleton, byte mode) {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)skeleton, 0.75, false){

                public void func_75251_c() {
                    super.func_75251_c();
                    skeleton.setSwingingArms(false);
                }

                public void func_75249_e() {
                    super.func_75249_e();
                    ItemCPU.this.raiseArmTicks = 0;
                }

                public void func_75246_d() {
                    if (this.func_75253_b()) {
                        ++ItemCPU.this.raiseArmTicks;
                        if (ItemCPU.this.raiseArmTicks >= 5 && this.field_75439_d < 10) {
                            skeleton.setSwingingArms(true);
                        } else {
                            skeleton.setSwingingArms(false);
                        }
                        super.func_75246_d();
                    }
                }
            };
        }
        if (skeleton.getMovementMode() > 0) {
            skeleton.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    @Override
    public void addTargetAi(EntityMechSkeleton skeleton, byte mode) {
        switch (mode) {
            default: {
                skeleton.func_70624_b(null);
                skeleton.func_70604_c(null);
                break;
            }
            case 2: {
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMasterHurtTarget((EntityArmyMember)skeleton));
            }
            case 1: {
                skeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIMasterHurtByTarget((EntityArmyMember)skeleton));
                skeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByNonAllied((EntityArmyMember)skeleton, !this.material.equals("copper_redstone"), new Class[0]));
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, EntityPlayer.class, true));
                skeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, EntityArmyMember.class, true));
                skeleton.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestNonTeamTarget((EntityCreature)skeleton, IMob.class, true));
            }
        }
    }

    @Override
    public void addMovementAi(EntityMechSkeleton skeleton, byte mode) {
        switch (mode) {
            case 1: {
                if (!ConfigValues.HUNTCREEPERS) {
                    skeleton.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)skeleton, EntityCreeper.class, 10.0f, 1.2, 1.6));
                }
                skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)skeleton, this.material.contains("redstone")));
                skeleton.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowMaster((EntityArmyMember)skeleton, 0.75, 8.0f, 3.0f));
            }
            case 0: {
                skeleton.func_175449_a(new BlockPos(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v), -1);
                break;
            }
            default: {
                skeleton.func_175449_a(new BlockPos(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v), 20);
                if (!ConfigValues.HUNTCREEPERS) {
                    skeleton.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)skeleton, EntityCreeper.class, 8.0f, 0.8, 1.2));
                }
                skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)skeleton, this.material.contains("redstone")));
                skeleton.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderBase((EntityArmyMember)skeleton, 0.5));
            }
        }
    }
}

