/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import the_fireplace.overlord.Overlord;

@MethodsReturnNonnullByDefault
public class CPUMeltRecipes {
    private static final CPUMeltRecipes CPU_MELT_RECIPES = new CPUMeltRecipes();
    private final Map<ItemStack, Object> smeltingListRight = Maps.newHashMap();
    private final Map<ItemStack, Object> smeltingListLeft = Maps.newHashMap();

    public static CPUMeltRecipes instance() {
        return CPU_MELT_RECIPES;
    }

    private CPUMeltRecipes() {
    }

    public void addCPURecipe(ItemStack output, Object leftInput, Object rightInput) {
        if (rightInput instanceof Item) {
            rightInput = new ItemStack((Item)rightInput);
        }
        if (rightInput instanceof Block) {
            rightInput = new ItemStack((Block)rightInput);
        }
        if (leftInput instanceof Item) {
            leftInput = new ItemStack((Item)leftInput);
        }
        if (leftInput instanceof Block) {
            leftInput = new ItemStack((Block)leftInput);
        }
        if (!this.getMeltingResult(leftInput, rightInput).func_190926_b()) {
            Overlord.logInfo((String)("Ignored melting recipe with conflicting input: " + output + " = " + leftInput + " + " + rightInput), (Object[])new Object[0]);
            return;
        }
        this.smeltingListRight.put(output, rightInput);
        this.smeltingListLeft.put(output, leftInput);
    }

    public ItemStack getMeltingResult(Object leftObj, Object rightObj) {
        ItemStack compStackLeft = ItemStack.field_190927_a;
        boolean useCompDictLeft = true;
        ItemStack compStackRight = ItemStack.field_190927_a;
        boolean useCompDictRight = true;
        if (leftObj instanceof ItemStack) {
            compStackLeft = (ItemStack)leftObj;
            useCompDictLeft = false;
        }
        if (useCompDictLeft && !(leftObj instanceof String)) {
            throw new IllegalArgumentException("input must be ItemStack or String: " + leftObj.toString());
        }
        if (rightObj instanceof ItemStack) {
            compStackRight = (ItemStack)rightObj;
            useCompDictRight = false;
        }
        if (useCompDictRight && !(rightObj instanceof String)) {
            throw new IllegalArgumentException("input must be ItemStack or String: " + rightObj.toString());
        }
        for (int i = 0; i < (useCompDictLeft ? OreDictionary.getOres((String)((String)leftObj)).size() : 1); ++i) {
            if (useCompDictLeft) {
                compStackLeft = (ItemStack)OreDictionary.getOres((String)((String)leftObj)).get(i);
            }
            for (int j = 0; j < (useCompDictRight ? OreDictionary.getOres((String)((String)rightObj)).size() : 1); ++j) {
                if (useCompDictRight) {
                    compStackRight = (ItemStack)OreDictionary.getOres((String)((String)rightObj)).get(j);
                }
                for (Map.Entry<ItemStack, Object> rightListEntry : this.smeltingListRight.entrySet()) {
                    for (Map.Entry<ItemStack, Object> leftListEntry : this.smeltingListLeft.entrySet()) {
                        Object inputObjRight = rightListEntry.getValue();
                        ItemStack inputStackRight = ItemStack.field_190927_a;
                        boolean useDictRight = true;
                        Object inputObjLeft = leftListEntry.getValue();
                        ItemStack inputStackLeft = ItemStack.field_190927_a;
                        boolean useDictLeft = true;
                        if (inputObjRight instanceof ItemStack) {
                            inputStackRight = (ItemStack)inputObjRight;
                            useDictRight = false;
                        }
                        if (useDictRight && !(inputObjRight instanceof String)) {
                            throw new IllegalArgumentException("input must be ItemStack or String: " + inputObjRight.toString());
                        }
                        if (inputObjLeft instanceof ItemStack) {
                            inputStackLeft = (ItemStack)inputObjLeft;
                            useDictLeft = false;
                        }
                        if (useDictLeft && !(inputObjLeft instanceof String)) {
                            throw new IllegalArgumentException("input must be ItemStack or String: " + inputObjLeft.toString());
                        }
                        for (int k = 0; k < (useDictRight ? OreDictionary.getOres((String)((String)inputObjRight)).size() : 1); ++k) {
                            if (useDictRight) {
                                inputStackRight = (ItemStack)OreDictionary.getOres((String)((String)inputObjRight)).get(k);
                            }
                            for (int l = 0; l < (useDictLeft ? OreDictionary.getOres((String)((String)inputObjLeft)).size() : 1); ++l) {
                                if (useDictLeft) {
                                    inputStackLeft = (ItemStack)OreDictionary.getOres((String)((String)inputObjLeft)).get(l);
                                }
                                if (!this.compareItemStacks(compStackLeft, inputStackLeft) || !this.compareItemStacks(compStackRight, inputStackRight) || !rightListEntry.getKey().equals(leftListEntry.getKey())) continue;
                                return rightListEntry.getKey();
                            }
                        }
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, Object> getSmeltingListRight() {
        return this.smeltingListRight;
    }

    public Map<ItemStack, Object> getSmeltingListLeft() {
        return this.smeltingListLeft;
    }
}

