/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import the_fireplace.mechsoldiers.util.EnumPartType;
import the_fireplace.mechsoldiers.util.ICPU;
import the_fireplace.mechsoldiers.util.IComponentDamageBehavior;

@ParametersAreNonnullByDefault
public final class PartRegistry {
    private static PartRegistry instance;
    private HashMap<ItemStack, EnumPartType> partTypes = Maps.newHashMap();
    private HashMap<ItemStack, IComponentDamageBehavior> partBehaviors = Maps.newHashMap();
    private HashMap<ItemStack, String> partMaterials = Maps.newHashMap();
    private HashMap<ItemStack, ResourceLocation> partTextures = Maps.newHashMap();
    private HashMap<ItemStack, ICPU> itemAIHandlers = Maps.newHashMap();

    public PartRegistry() {
        if (instance == null) {
            instance = this;
        }
    }

    public static void registerSkeleton(Item item, IComponentDamageBehavior behavior, String material, ResourceLocation texture) {
        PartRegistry.registerPart(item, Short.MAX_VALUE, EnumPartType.SKELETON, behavior, material, texture);
    }

    public static void registerJoints(Item item, IComponentDamageBehavior behavior, String material, ResourceLocation texture) {
        PartRegistry.registerPart(item, Short.MAX_VALUE, EnumPartType.JOINTS, behavior, material, texture);
    }

    public static void registerCPU(Item item, ICPU logicHandler, IComponentDamageBehavior behavior, String material) {
        PartRegistry.registerPart(item, Short.MAX_VALUE, EnumPartType.CPU, behavior, material, null);
        PartRegistry.instance.itemAIHandlers.put(new ItemStack(item, 1, Short.MAX_VALUE), logicHandler);
    }

    public static void registerPotatoCPU(Item item, int meta, IComponentDamageBehavior behavior, String material) {
        PartRegistry.registerPart(item, meta, EnumPartType.CPU, behavior, material, null);
    }

    private static void registerPart(Item item, int meta, EnumPartType type, IComponentDamageBehavior behavior, String material, @Nullable ResourceLocation texture) {
        PartRegistry.instance.partTypes.put(new ItemStack(item, 1, meta), type);
        PartRegistry.instance.partBehaviors.put(new ItemStack(item, 1, meta), behavior);
        PartRegistry.instance.partMaterials.put(new ItemStack(item, 1, meta), material);
        if (texture != null) {
            PartRegistry.instance.partTextures.put(new ItemStack(item, 1, meta), texture);
        }
    }

    public static boolean isPart(@Nullable ItemStack part) {
        if (part == null) {
            return false;
        }
        for (ItemStack stack : PartRegistry.instance.partTypes.keySet()) {
            if (stack.func_77973_b() != part.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != part.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfType(@Nullable ItemStack part, EnumPartType slotType) {
        if (part == null || slotType == null || !PartRegistry.isPart(part)) {
            return false;
        }
        for (ItemStack stack : PartRegistry.instance.partTypes.keySet()) {
            if (stack.func_77973_b() != part.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != part.func_77960_j()) continue;
            return PartRegistry.instance.partTypes.get(stack) == slotType;
        }
        return false;
    }

    public static ArrayList<ItemStack> getPartsOfType(EnumPartType type) {
        ArrayList out = Lists.newArrayList();
        for (ItemStack stack : PartRegistry.instance.partTypes.keySet()) {
            if (PartRegistry.instance.partTypes.get(stack) != type) continue;
            out.add(stack);
        }
        return out;
    }

    public static ItemStack damagePart(ItemStack part, DamageSource source, float amount, EntityLivingBase entity) {
        if (!PartRegistry.isPart(part) || !part.func_77984_f()) {
            return part;
        }
        for (ItemStack stack : PartRegistry.instance.partBehaviors.keySet()) {
            if (stack.func_77973_b() != part.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != part.func_77960_j()) continue;
            for (ItemStack mat : PartRegistry.instance.partMaterials.keySet()) {
                if (mat.func_77973_b() != part.func_77973_b() || mat.func_77960_j() != Short.MAX_VALUE && mat.func_77960_j() != part.func_77960_j()) continue;
                return PartRegistry.instance.partBehaviors.get(stack).getDamagedItemStack(part, source, amount, PartRegistry.instance.partMaterials.get(mat), entity);
            }
        }
        return part;
    }

    @Nullable
    public static ResourceLocation getTexLocation(ItemStack part) {
        if (!PartRegistry.isPart(part)) {
            return null;
        }
        for (ItemStack stack : PartRegistry.instance.partTextures.keySet()) {
            if (stack.func_77973_b() != part.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != part.func_77960_j()) continue;
            return PartRegistry.instance.partTextures.get(stack);
        }
        return null;
    }

    @Nullable
    public static ICPU getCPU(ItemStack part) {
        if (!PartRegistry.isPart(part)) {
            return null;
        }
        for (ItemStack stack : PartRegistry.instance.itemAIHandlers.keySet()) {
            if (stack.func_77973_b() != part.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != part.func_77960_j()) continue;
            return PartRegistry.instance.itemAIHandlers.get(stack);
        }
        return null;
    }
}

