/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import the_fireplace.mechsoldiers.container.ContainerCPUMelter;
import the_fireplace.mechsoldiers.container.SlotCPUMelter;
import the_fireplace.mechsoldiers.container.SlotLava;
import the_fireplace.mechsoldiers.registry.CPUMeltRecipes;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityCPUMelter
extends TileEntityLockable
implements ITickable,
ISidedInventory,
IFluidHandler,
IFluidTank {
    private static final int[] SLOTS_TOP = new int[]{1, 2};
    private static final int[] SLOTS_BOTTOM = new int[]{0, 3, 4};
    private static final int[] SLOTS_SIDES = new int[]{0};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int heldLavaAmount;
    public static final int heldLavaAmountMax = 10000;
    private String furnaceCustomName;
    public boolean isLoaded;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return "container.cpu_melter";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)j, (Object)new ItemStack(nbttagcompound));
        }
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.heldLavaAmount = compound.func_74762_e("HeldLava");
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("HeldLava", this.heldLavaAmount);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isActive() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isActive(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean isInitiallyActive = this.isActive();
        boolean tileChanged = false;
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLoaded) {
                this.isLoaded = true;
            }
            if (!this.func_70301_a(0).func_190926_b() && FluidUtil.getFluidHandler((ItemStack)this.func_70301_a(0)) != null && this.heldLavaAmount < 10000) {
                InvWrapper thisInv = new InvWrapper((IInventory)this);
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)this.func_70301_a(0), (IFluidHandler)this, (int)1000, null, (boolean)true);
                if (result.isSuccess()) {
                    ItemStack inserted2;
                    ItemStack inserted1;
                    this.func_70301_a(0).func_190918_g(1);
                    if (this.func_70301_a(0).func_190926_b()) {
                        this.func_70299_a(0, ItemStack.field_190927_a);
                    }
                    if (FluidUtil.getFluidContained((ItemStack)result.getResult()) == null && !(inserted1 = thisInv.insertItem(4, result.getResult(), false)).func_190926_b() && !(inserted2 = thisInv.insertItem(0, inserted1, false)).func_190926_b()) {
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)inserted2);
                    }
                }
            }
            if (this.isActive() || !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                if (!this.isActive() && this.canSmelt()) {
                    this.furnaceBurnTime = 5000;
                    if (this.isActive()) {
                        tileChanged = true;
                    }
                }
                if (this.isActive() && this.canSmelt()) {
                    if (this.furnaceBurnTime % 5 == 0) {
                        --this.heldLavaAmount;
                    }
                    --this.furnaceBurnTime;
                    if (this.furnaceBurnTime == 0) {
                        this.smeltItem();
                        tileChanged = true;
                    }
                } else {
                    this.furnaceBurnTime = 0;
                }
            } else if (!this.isActive() && this.furnaceBurnTime > 0) {
                this.furnaceBurnTime = 0;
            }
            if (isInitiallyActive != this.isActive()) {
                tileChanged = true;
            }
        }
        if (tileChanged) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b() || this.heldLavaAmount <= 0) {
            return false;
        }
        ItemStack result = CPUMeltRecipes.instance().getMeltingResult(this.furnaceItemStacks.get(1), this.furnaceItemStacks.get(2));
        if (result.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(3)).func_77969_a(result)) {
            return false;
        }
        int resultCount = ((ItemStack)this.furnaceItemStacks.get(3)).func_190916_E() + result.func_190916_E();
        return resultCount <= this.func_70297_j_() && resultCount <= ((ItemStack)this.furnaceItemStacks.get(3)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = CPUMeltRecipes.instance().getMeltingResult(this.furnaceItemStacks.get(1), this.furnaceItemStacks.get(2));
            if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
                this.furnaceItemStacks.set(3, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.furnaceItemStacks.get(3)).func_77973_b() == itemstack.func_77973_b()) {
                ((ItemStack)this.furnaceItemStacks.get(3)).func_190917_f(itemstack.func_190916_E());
            }
            ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
            ((ItemStack)this.furnaceItemStacks.get(2)).func_190918_g(1);
            if (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                this.furnaceItemStacks.set(1, (Object)ItemStack.field_190927_a);
            }
            if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return SlotLava.isLava(stack);
            }
            case 1: {
                return SlotCPUMelter.isStackValid("left", stack);
            }
            case 2: {
                return SlotCPUMelter.isStackValid("right", stack);
            }
            case 4: {
                return FluidUtil.getFluidHandler((ItemStack)stack) != null;
            }
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 0 || FluidUtil.getFluidContained((ItemStack)stack) == null || FluidUtil.getFluidContained((ItemStack)stack).getFluid() != FluidRegistry.LAVA;
    }

    public String func_174875_k() {
        return "mechsoldiers:cpu_melter";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCPUMelter(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.heldLavaAmount;
            }
            case 2: {
                return 10000;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.heldLavaAmount = value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.getFluid(), this.getFluidAmount()), this.getCapacity())};
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.getFluidAmount() > 0) {
            return new FluidStack(FluidRegistry.LAVA, this.getFluidAmount());
        }
        return null;
    }

    public int getFluidAmount() {
        return this.heldLavaAmount;
    }

    public int getCapacity() {
        return 10000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int maxFillAmount = this.getCapacity() - this.getFluidAmount();
        if (resource.getFluid().equals(FluidRegistry.LAVA) && maxFillAmount > 0) {
            if (maxFillAmount < resource.amount) {
                if (doFill) {
                    this.heldLavaAmount += maxFillAmount;
                }
                return maxFillAmount;
            }
            if (doFill) {
                this.heldLavaAmount += resource.amount;
            }
            return resource.amount;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.amount > 0 && resource.getFluid().equals(FluidRegistry.LAVA)) {
            if (resource.amount < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldLavaAmount -= resource.amount;
                }
                return new FluidStack(FluidRegistry.LAVA, resource.amount);
            }
            int prevHeldLava = this.getFluidAmount();
            if (doDrain) {
                this.heldLavaAmount = 0;
            }
            return new FluidStack(FluidRegistry.LAVA, prevHeldLava);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            if (maxDrain < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldLavaAmount -= maxDrain;
                }
                return new FluidStack(FluidRegistry.LAVA, maxDrain);
            }
            int prevHeldLava = this.getFluidAmount();
            if (doDrain) {
                this.heldLavaAmount = 0;
            }
            return new FluidStack(FluidRegistry.LAVA, prevHeldLava);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

