/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityMiniTank
extends TileEntity
implements IFluidHandler,
IFluidTank {
    private int heldFluidAmount;
    public static final int maxCapacity = 12000;
    private Fluid heldFluid;

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.mini_tank.name", new Object[0]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.heldFluidAmount = compound.func_74762_e("HeldFluid");
        this.heldFluid = FluidRegistry.getFluid((String)compound.func_74779_i("FluidId"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("HeldFluid", this.heldFluidAmount);
        if (this.heldFluid != null) {
            compound.func_74778_a("FluidId", FluidRegistry.getFluidName((Fluid)this.heldFluid));
        }
        return compound;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.getFluidAmount() > 0) {
            return new FluidStack(this.heldFluid, this.heldFluidAmount);
        }
        return null;
    }

    public int getFluidAmount() {
        return this.heldFluidAmount;
    }

    public int getCapacity() {
        return this.func_145838_q().getRegistryName().toString().contains("full") ? 12000 : 6000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.getFluid(), this.getFluidAmount()), this.getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        int maxFillAmount = this.getCapacity() - this.getFluidAmount();
        if (maxFillAmount > 0 && (this.heldFluid == null || resource.getFluid().equals(this.heldFluid))) {
            if (doFill && this.heldFluid == null) {
                this.heldFluid = resource.getFluid();
            }
            if (maxFillAmount < resource.amount) {
                if (doFill) {
                    this.heldFluidAmount += maxFillAmount;
                }
                return maxFillAmount;
            }
            if (doFill) {
                this.heldFluidAmount += resource.amount;
            }
            return resource.amount;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.amount > 0 && resource.getFluid().equals(this.heldFluid)) {
            if (resource.amount < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldFluidAmount -= resource.amount;
                }
                return new FluidStack(this.heldFluid, resource.amount);
            }
            int prevHeldAmount = this.getFluidAmount();
            if (this.heldFluid == null || prevHeldAmount <= 0) {
                return null;
            }
            FluidStack out = new FluidStack(this.heldFluid, prevHeldAmount);
            if (doDrain) {
                this.heldFluidAmount = 0;
                this.heldFluid = null;
            }
            return out;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            if (maxDrain < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldFluidAmount -= maxDrain;
                }
                return new FluidStack(this.heldFluid, maxDrain);
            }
            int prevHeldAmount = this.getFluidAmount();
            if (this.heldFluid == null || prevHeldAmount <= 0) {
                return null;
            }
            FluidStack out = new FluidStack(this.heldFluid, prevHeldAmount);
            if (doDrain) {
                this.heldFluidAmount = 0;
                this.heldFluid = null;
            }
            return out;
        }
        return null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

