/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import the_fireplace.mechsoldiers.blocks.BlockMetalPartConstructor;
import the_fireplace.mechsoldiers.container.ContainerMetalPartConstructor;
import the_fireplace.mechsoldiers.container.SlotMPC;
import the_fireplace.mechsoldiers.container.SlotWater;
import the_fireplace.mechsoldiers.registry.MetalMeltRecipes;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityPartConstructor
extends TileEntityLockable
implements ITickable,
ISidedInventory,
IFluidHandler,
IFluidTank {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 3, 4, 5};
    private static final int[] SLOTS_SIDES = new int[]{2, 4};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private int heldWaterAmount;
    public static final int heldWaterAmountMax = 6000;
    private String furnaceCustomName;
    public boolean isLoaded;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.furnaceItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.furnaceItemStacks.get(index)));
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return "container.metal_part_maker";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)j, (Object)new ItemStack(nbttagcompound));
        }
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityPartConstructor.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(2));
        this.heldWaterAmount = compound.func_74762_e("HeldWater");
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        compound.func_74768_a("HeldWater", this.heldWaterAmount);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isActive() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isActive(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isActive();
        boolean flag1 = false;
        if (this.isActive()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLoaded) {
                this.isLoaded = true;
            }
            if (!((ItemStack)this.furnaceItemStacks.get(4)).func_190926_b() && FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.furnaceItemStacks.get(4))) != null && this.heldWaterAmount < 6000) {
                InvWrapper thisInv = new InvWrapper((IInventory)this);
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)((ItemStack)this.furnaceItemStacks.get(4)), (IFluidHandler)this, (int)1000, null, (boolean)true);
                if (result.isSuccess()) {
                    ItemStack inserted2;
                    ItemStack inserted1;
                    this.func_70301_a(4).func_190918_g(1);
                    if (this.func_70301_a(4).func_190926_b()) {
                        this.func_70299_a(4, ItemStack.field_190927_a);
                    }
                    if (FluidUtil.getFluidContained((ItemStack)result.getResult()) == null && !(inserted1 = thisInv.insertItem(5, result.getResult(), false)).func_190926_b() && !(inserted2 = thisInv.insertItem(4, inserted1, false)).func_190926_b()) {
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)inserted2);
                    }
                }
            }
            if (this.isActive() || !((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                if (!this.isActive() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityPartConstructor.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(2));
                    if (this.isActive()) {
                        flag1 = true;
                        if (!((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                            ((ItemStack)this.furnaceItemStacks.get(2)).func_190918_g(1);
                            if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                                this.furnaceItemStacks.set(2, (Object)((ItemStack)this.furnaceItemStacks.get(2)).func_77973_b().getContainerItem((ItemStack)this.furnaceItemStacks.get(2)));
                            }
                        }
                    }
                }
                if (this.isActive() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isActive() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isActive()) {
                flag1 = true;
                BlockMetalPartConstructor.setState(this.isActive(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() || this.heldWaterAmount <= 0) {
            return false;
        }
        ItemStack itemstack = MetalMeltRecipes.instance().getMeltingResult(this.furnaceItemStacks.get(0), this.furnaceItemStacks.get(1));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (MetalMeltRecipes.instance().getWaterCost(itemstack) > this.heldWaterAmount) {
            return false;
        }
        if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(3)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.furnaceItemStacks.get(3)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.furnaceItemStacks.get(3)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = MetalMeltRecipes.instance().getMeltingResult(this.furnaceItemStacks.get(0), this.furnaceItemStacks.get(1));
            if (((ItemStack)this.furnaceItemStacks.get(3)).func_190926_b()) {
                this.furnaceItemStacks.set(3, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.furnaceItemStacks.get(3)).func_77973_b() == itemstack.func_77973_b()) {
                ((ItemStack)this.furnaceItemStacks.get(3)).func_190917_f(itemstack.func_190916_E());
            }
            ((ItemStack)this.furnaceItemStacks.get(0)).func_190918_g(1);
            ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
            if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                this.furnaceItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
            if (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                this.furnaceItemStacks.set(1, (Object)ItemStack.field_190927_a);
            }
            this.drain(MetalMeltRecipes.instance().getWaterCost(itemstack), true);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 0.8f + (float)this.field_145850_b.field_73012_v.nextInt(4) * 0.1f);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityPartConstructor.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return SlotMPC.isStackValid("right", stack);
            }
            case 1: {
                return SlotMPC.isStackValid("left", stack);
            }
            case 2: {
                return TileEntityPartConstructor.isItemFuel(stack);
            }
            case 4: {
                return SlotWater.holdsWater(stack);
            }
            case 5: {
                return FluidUtil.getFluidHandler((ItemStack)stack) != null;
            }
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            if (index == 4 && SlotWater.holdsWater(stack)) {
                return false;
            }
            if (index == 2 && TileEntityPartConstructor.isItemFuel(stack)) {
                return false;
            }
        }
        return true;
    }

    public String func_174875_k() {
        return "mechsoldiers:part_constructor";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMetalPartConstructor(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
            case 4: {
                return this.heldWaterAmount;
            }
            case 5: {
                return 6000;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
                break;
            }
            case 4: {
                this.heldWaterAmount = value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 6;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.getFluid(), this.getFluidAmount()), this.getCapacity())};
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.getFluidAmount() > 0) {
            return new FluidStack(FluidRegistry.WATER, this.getFluidAmount());
        }
        return null;
    }

    public int getFluidAmount() {
        return this.heldWaterAmount;
    }

    public int getCapacity() {
        return 6000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int maxFillAmount = this.getCapacity() - this.getFluidAmount();
        if (resource.getFluid().equals(FluidRegistry.WATER) && maxFillAmount > 0) {
            if (maxFillAmount < resource.amount) {
                if (doFill) {
                    this.heldWaterAmount += maxFillAmount;
                }
                return maxFillAmount;
            }
            if (doFill) {
                this.heldWaterAmount += resource.amount;
            }
            return resource.amount;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.amount > 0 && resource.getFluid().equals(FluidRegistry.WATER)) {
            if (resource.amount < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldWaterAmount -= resource.amount;
                }
                return new FluidStack(FluidRegistry.WATER, resource.amount);
            }
            int prevHeldWater = this.getFluidAmount();
            if (doDrain) {
                this.heldWaterAmount = 0;
            }
            return new FluidStack(FluidRegistry.WATER, prevHeldWater);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            if (maxDrain < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldWaterAmount -= maxDrain;
                }
                return new FluidStack(FluidRegistry.WATER, maxDrain);
            }
            int prevHeldWater = this.getFluidAmount();
            if (doDrain) {
                this.heldWaterAmount = 0;
            }
            return new FluidStack(FluidRegistry.WATER, prevHeldWater);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

