/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import the_fireplace.mechsoldiers.container.ContainerMetalPartConstructor;
import the_fireplace.mechsoldiers.registry.PartRegistry;
import the_fireplace.mechsoldiers.util.EnumPartType;
import the_fireplace.overlord.tileentity.ISkeletonMaker;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityPartStainer
extends TileEntityLockable
implements ISidedInventory,
ISkeletonMaker {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{4};
    private static final int[] SLOTS_SIDES = new int[]{1, 2, 3, 5};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private short redValue = (short)255;
    private short greenValue = (short)255;
    private short blueValue = (short)255;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int getRed() {
        return this.redValue;
    }

    public int getGreen() {
        return this.greenValue;
    }

    public int getBlue() {
        return this.blueValue;
    }

    public boolean hasEnoughRed() {
        return this.func_70301_a(1).func_190916_E() >= this.getFinalRedCost() && (this.redValue >= 255 || !this.func_70301_a(1).func_190926_b());
    }

    public boolean hasEnoughGreen() {
        return this.func_70301_a(2).func_190916_E() >= this.getFinalGreenCost() && (this.greenValue >= 255 || !this.func_70301_a(2).func_190926_b());
    }

    public boolean hasEnoughBlue() {
        return this.func_70301_a(3).func_190916_E() >= this.getFinalBlueCost() && (this.blueValue >= 255 || !this.func_70301_a(3).func_190926_b());
    }

    public int getFinalRedCost() {
        return this.getRedCost() + this.getDarknessCompensationCost();
    }

    public int getFinalGreenCost() {
        return this.getGreenCost() + this.getDarknessCompensationCost();
    }

    public int getFinalBlueCost() {
        return this.getBlueCost() + this.getDarknessCompensationCost();
    }

    public int getRedCost() {
        int initCost = this.greenValue / 85 * (this.blueValue / 85) / -3 + this.redValue / 85;
        if (initCost <= 0) {
            return 0;
        }
        return initCost;
    }

    public int getGreenCost() {
        int initCost = this.redValue / 85 * (this.blueValue / 85) / -3 + this.greenValue / 85;
        if (initCost <= 0) {
            return 0;
        }
        return initCost;
    }

    public int getBlueCost() {
        int initCost = this.redValue / 85 * (this.greenValue / 85) / -3 + this.blueValue / 85;
        if (initCost <= 0) {
            return 0;
        }
        return initCost;
    }

    public int getDarknessCost() {
        int cost = 0;
        if (this.redValue < 85) {
            ++cost;
        }
        if (this.greenValue < 85) {
            ++cost;
        }
        if (this.blueValue < 85) {
            ++cost;
        }
        return cost;
    }

    public int getDarknessCompensationCost() {
        return this.getDarknessCost() - this.getBlackDyeCost();
    }

    public int getBlackDyeCost() {
        if (!this.func_70301_a(5).func_190926_b()) {
            if (this.func_70301_a(5).func_190916_E() >= this.getDarknessCost()) {
                return this.getDarknessCost();
            }
            return this.func_70301_a(5).func_190916_E();
        }
        return 0;
    }

    public boolean canSpawnSkeleton() {
        return !this.func_70301_a(0).func_190926_b() && this.func_70301_a(4).func_190926_b() && this.hasEnoughRed() && this.hasEnoughGreen() && this.hasEnoughBlue();
    }

    public void spawnSkeleton(EntityPlayer playerSpawning) {
        if (!this.canSpawnSkeleton()) {
            return;
        }
        ItemStack output = this.func_70301_a(0).func_77946_l();
        NBTTagCompound outData = new NBTTagCompound();
        outData.func_74768_a("StainColor", new Color(this.redValue, this.greenValue, this.blueValue).getRGB());
        output.func_77982_d(outData);
        output.func_190920_e(1);
        this.func_70299_a(4, output);
        if (this.func_70301_a(0).func_190916_E() > 1) {
            this.func_70301_a(0).func_190918_g(1);
        } else {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (this.func_70301_a(1).func_190916_E() > 1) {
            this.func_70301_a(1).func_190918_g(this.getFinalRedCost());
        }
        if (this.func_70301_a(1).func_190926_b()) {
            this.func_70299_a(1, ItemStack.field_190927_a);
        }
        if (this.func_70301_a(2).func_190916_E() > 1) {
            this.func_70301_a(2).func_190918_g(this.getFinalGreenCost());
        }
        if (this.func_70301_a(2).func_190926_b()) {
            this.func_70299_a(2, ItemStack.field_190927_a);
        }
        if (this.func_70301_a(3).func_190916_E() > 1) {
            this.func_70301_a(3).func_190918_g(this.getFinalBlueCost());
        }
        if (this.func_70301_a(3).func_190926_b()) {
            this.func_70299_a(3, ItemStack.field_190927_a);
        }
        if (this.func_70301_a(5).func_190916_E() > 1) {
            this.func_70301_a(5).func_190918_g(this.getBlackDyeCost());
        }
        if (this.func_70301_a(5).func_190926_b()) {
            this.func_70299_a(5, ItemStack.field_190927_a);
        }
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return "container.part_stainer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)j, (Object)new ItemStack(nbttagcompound));
        }
        this.redValue = compound.func_74765_d("RedValue");
        this.greenValue = compound.func_74765_d("GreenValue");
        this.blueValue = compound.func_74765_d("BlueValue");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("RedValue", this.redValue);
        compound.func_74777_a("GreenValue", this.greenValue);
        compound.func_74777_a("BlueValue", this.blueValue);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return TileEntityPartStainer.isSkeletonOrJoint(stack);
            }
            case 1: {
                return TileEntityPartStainer.isDyeColor(stack, "Red");
            }
            case 2: {
                return TileEntityPartStainer.isDyeColor(stack, "Green");
            }
            case 3: {
                return TileEntityPartStainer.isDyeColor(stack, "Blue");
            }
            case 5: {
                return TileEntityPartStainer.isDyeColor(stack, "Black");
            }
        }
        return false;
    }

    public static boolean isSkeletonOrJoint(ItemStack stack) {
        return PartRegistry.isPartOfType(stack, EnumPartType.SKELETON) || PartRegistry.isPartOfType(stack, EnumPartType.JOINTS);
    }

    public static boolean isDyeColor(ItemStack stack, String color) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals("dye" + color)) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 4;
    }

    public String func_174875_k() {
        return "mechsoldiers:part_constructor";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMetalPartConstructor(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.redValue;
            }
            case 1: {
                return this.greenValue;
            }
            case 2: {
                return this.blueValue;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.redValue = (short)value;
                break;
            }
            case 1: {
                this.greenValue = (short)value;
                break;
            }
            case 2: {
                this.blueValue = (short)value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

