/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import the_fireplace.mechsoldiers.entity.EntityMechSkeleton;
import the_fireplace.overlord.Overlord;

public class TileEntityRobotBox
extends TileEntity
implements ITickable {
    private NBTTagCompound skeletonData;
    private int maxTicks;
    private int ticksRemaining;
    private Random rand;

    public TileEntityRobotBox() {
        this.rand = new Random();
    }

    public TileEntityRobotBox(NBTTagCompound skeletonData, int ticksToWait) {
        this.skeletonData = skeletonData;
        this.maxTicks = this.ticksRemaining = ticksToWait;
        this.rand = new Random();
    }

    public void setSkeletonData(NBTTagCompound nbt) {
        this.skeletonData = nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.robot_constructor.name", new Object[0]);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("ConstructingSkeletonData", (NBTBase)this.skeletonData);
        compound.func_74768_a("TicksRemaining", this.ticksRemaining);
        compound.func_74768_a("MaxTicks", this.maxTicks);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.skeletonData = compound.func_74775_l("ConstructingSkeletonData");
        this.ticksRemaining = compound.func_74762_e("TicksRemaining");
        this.maxTicks = compound.func_74764_b("MaxTicks") ? compound.func_74762_e("MaxTicks") : compound.func_74762_e("TicksRemaining");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            --this.ticksRemaining;
            if (this.ticksRemaining <= 0) {
                this.spawnRobot();
            }
        }
    }

    public ItemStack getCPU() {
        return new ItemStack(this.skeletonData.func_74775_l("RobotCPU"));
    }

    public ItemStack getSkeleton() {
        return new ItemStack(this.skeletonData.func_74775_l("RobotSkeleton"));
    }

    public ItemStack getJoints() {
        return new ItemStack(this.skeletonData.func_74775_l("RobotJoints"));
    }

    public String getOwnerId() {
        return this.skeletonData.func_74779_i("OwnerUUID");
    }

    public float getCompletion() {
        return 1.0f - (float)this.ticksRemaining / (float)this.maxTicks;
    }

    private void spawnRobot() {
        EntityMechSkeleton robot = new EntityMechSkeleton(this.field_145850_b, UUID.fromString(this.getOwnerId())).setCPU(this.getCPU()).setSkeleton(this.getSkeleton()).setJoints(this.getJoints());
        robot.func_70012_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rand.nextFloat(), this.rand.nextFloat());
        this.field_145850_b.func_72838_d((Entity)robot);
        robot.func_70012_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rand.nextFloat(), this.rand.nextFloat());
        this.field_145850_b.func_184133_a(null, this.field_174879_c, Overlord.CREATE_SKELETON_2_SOUND, SoundCategory.BLOCKS, 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat());
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175655_b(this.field_174879_c, false);
    }
}

