/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mechsoldiers.tileentity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import the_fireplace.mechsoldiers.MechSoldiers;
import the_fireplace.mechsoldiers.registry.PartRegistry;
import the_fireplace.mechsoldiers.util.EnumPartType;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.items.ItemOverlordsSeal;
import the_fireplace.overlord.tileentity.ISkeletonMaker;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityRobotConstructor
extends TileEntity
implements ISidedInventory,
ISkeletonMaker {
    private NonNullList<ItemStack> inventory;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityRobotConstructor() {
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    }

    public boolean canSpawnSkeleton() {
        return !this.func_70301_a(1).func_190926_b() && !this.func_70301_a(2).func_190926_b() && !this.func_70301_a(3).func_190926_b() && !this.func_70301_a(4).func_190926_b() && this.func_70301_a(5).func_190926_b();
    }

    public void spawnSkeleton(@Nullable EntityPlayer playerSpawning) {
        if (!this.canSpawnSkeleton() || this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack robotBox = new ItemStack(MechSoldiers.robot_box);
        NBTTagCompound robotData = new NBTTagCompound();
        if (!this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77978_p() != null && !this.func_70301_a(0).func_77978_p().func_74779_i("Owner").isEmpty()) {
            robotData.func_74778_a("OwnerUUID", this.func_70301_a(0).func_77978_p().func_74779_i("Owner"));
        } else {
            robotData.func_74778_a("OwnerUUID", "0b1ec5ad-cb2a-43b7-995d-889320eb2e5b");
        }
        ItemStack oneCPU = this.func_70301_a(1).func_77946_l();
        oneCPU.func_190920_e(1);
        ItemStack oneSkeleton = this.func_70301_a(2).func_77946_l();
        oneSkeleton.func_190920_e(1);
        ItemStack oneJoints = this.func_70301_a(3).func_77946_l();
        oneJoints.func_190920_e(1);
        robotData.func_74782_a("RobotCPU", (NBTBase)oneCPU.func_77955_b(new NBTTagCompound()));
        robotData.func_74782_a("RobotSkeleton", (NBTBase)oneSkeleton.func_77955_b(new NBTTagCompound()));
        robotData.func_74782_a("RobotJoints", (NBTBase)oneJoints.func_77955_b(new NBTTagCompound()));
        robotBox.func_77982_d(robotData);
        this.func_70299_a(5, robotBox);
        for (int i = 1; i < 5; ++i) {
            if (this.func_70301_a(i).func_190916_E() > 1) {
                this.func_70301_a(i).func_190918_g(1);
                continue;
            }
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        if (!this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77973_b() instanceof ItemOverlordsSeal && ((ItemOverlordsSeal)this.func_70301_a(0).func_77973_b()).isConsumable()) {
            if (this.func_70301_a(0).func_190916_E() > 1) {
                this.func_70301_a(0).func_190918_g(1);
            } else {
                this.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String func_70005_c_() {
        return Overlord.proxy.translateToLocal("tile.robot_constructor.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.robot_constructor.name", new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack is = this.func_70301_a(index);
        if (!is.func_190926_b()) {
            if (is.func_190916_E() <= count) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                is = is.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return is;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack is = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return is;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 1 && PartRegistry.isPartOfType(stack, EnumPartType.CPU) || index == 2 && PartRegistry.isPartOfType(stack, EnumPartType.SKELETON) || index == 3 && PartRegistry.isPartOfType(stack, EnumPartType.JOINTS) || index == 0 && stack.func_77973_b() instanceof ItemOverlordsSeal || index == 4 && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)OreDictionary.getOreID((String)"logWood"));
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotRobotConstructor", (byte)i);
            is.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("ItemsRobotConstructor", (NBTBase)list);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = (NBTTagList)compound.func_74781_a("ItemsRobotConstructor");
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)list.func_179238_g(i);
                byte slot = item.func_74771_c("SlotRobotConstructor");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn((String)"List was null when reading TileEntityRobotConstructor NBTTagCompound", (Object[])new Object[0]);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.EAST || side == EnumFacing.WEST || side == EnumFacing.NORTH || side == EnumFacing.SOUTH || side == EnumFacing.UP) {
            return new int[]{0, 1, 2, 3, 4, 5};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{6};
        }
        throw new IllegalArgumentException("Invalid EnumFacing: " + side);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return !stack.func_190926_b() && index >= 0 && index < 5 && this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return !stack.func_190926_b() && index == 5;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

