/*
 * Decompiled with CFR 0.152.
 */
package elucent.blockcraftery.block;

import elucent.blockcraftery.block.IEditableBlock;
import elucent.blockcraftery.model.BakedModelEditableCube;
import elucent.blockcraftery.tile.TileEditableBlock;
import elucent.elulib.block.BlockTEBase;
import elucent.elulib.model.CustomModelBlock;
import elucent.elulib.model.CustomModelLoader;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEditableCube
extends BlockTEBase
implements IEditableBlock {
    public static final PropertyBool FULLCUBE = PropertyBool.func_177716_a((String)"fullcube");
    public static final PropertyBool OPAQUECUBE = PropertyBool.func_177716_a((String)"opaquecube");
    public static final UnlistedPropertyState STATEPROP = new UnlistedPropertyState();

    public BlockEditableCube(Material mat, SoundType type, float hardness, String name, Class<? extends TileEntity> teClass) {
        super(mat, type, hardness, name, teClass);
        this.hasCustomModel = true;
        this.func_149713_g(0);
        this.setOpacity(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FULLCUBE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)OPAQUECUBE, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUECUBE);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FULLCUBE) == false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState s = world.func_180495_p(pos.func_177972_a(side));
        if (s.func_177230_c() == this) {
            TileEntity t = world.func_175625_s(pos);
            TileEntity t2 = world.func_175625_s(pos.func_177972_a(side));
            if (t instanceof TileEditableBlock && t2 instanceof TileEditableBlock && ((TileEditableBlock)t).state.func_177230_c() == ((TileEditableBlock)t2).state.func_177230_c() && ((TileEditableBlock)t).state.func_177230_c() != Blocks.field_150350_a) {
                return false;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEditableBlock) {
            return ((TileEditableBlock)t).state.func_177230_c().doesSideBlockRendering(((TileEditableBlock)t).state, world, pos, side);
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FULLCUBE, OPAQUECUBE};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{STATEPROP};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FULLCUBE, (Comparable)Boolean.valueOf(meta % 2 == 1)).func_177226_a((IProperty)OPAQUECUBE, (Comparable)Boolean.valueOf(meta > 1));
    }

    public int func_176201_c(IBlockState state) {
        return 2 * ((Boolean)state.func_177229_b((IProperty)OPAQUECUBE) != false ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)FULLCUBE) != false ? 1 : 0);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        IBlockState actual = this.func_176221_a(state, world, pos);
        if (t instanceof TileEditableBlock && actual instanceof IExtendedBlockState) {
            IBlockState tileState = ((TileEditableBlock)t).state;
            IBlockState placeState = tileState.func_177230_c().func_176221_a(tileState, world, pos);
            return ((IExtendedBlockState)actual).withProperty((IUnlistedProperty)STATEPROP, (Object)placeState);
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.getRegistryName().func_110624_b() + ":blocks/" + this.getRegistryName().func_110623_a());
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(BakedModelEditableCube.class, defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#inventory"), new CustomModelBlock(BakedModelEditableCube.class, defaultTex, defaultTex));
        }
    }

    @Override
    public IUnlistedProperty<IBlockState> getStateProperty() {
        return STATEPROP;
    }

    public static class UnlistedPropertyState
    implements IUnlistedProperty<IBlockState> {
        public String getName() {
            return "stateprop";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    }
}

