/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.model.BakedSimple;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.shared.client.BakedTableModel;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

@SideOnly(value=Side.CLIENT)
public class ToolClientEvents {
    public static Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };
    private static final ResourceLocation MODEL_CraftingStation = Util.getResource("block/craftingstation");
    private static final ResourceLocation MODEL_StencilTable = Util.getResource("block/stenciltable");
    private static final ResourceLocation MODEL_PartBuilder = Util.getResource("block/partbuilder");
    private static final ResourceLocation MODEL_ToolStation = Util.getResource("block/toolstation");
    private static final ResourceLocation MODEL_ToolForge = Util.getResource("block/toolforge");
    private static final String LOCATION_ToolTable = Util.resource("tooltables");
    private static final String LOCATION_ToolForge = Util.resource("toolforge");
    public static final ModelResourceLocation locCraftingStation = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.CraftingStation);
    public static final ModelResourceLocation locStencilTable = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.StencilTable);
    public static final ModelResourceLocation locPartBuilder = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.PartBuilder);
    public static final ModelResourceLocation locToolStation = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.ToolStation);
    public static final ModelResourceLocation locToolForge = new ModelResourceLocation(LOCATION_ToolForge, "normal");
    public static final ModelResourceLocation locPatternChest = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.PatternChest);
    public static final ModelResourceLocation locPartChest = ToolClientEvents.getTableLoc(BlockToolTable.TableTypes.PartChest);
    private static final ResourceLocation MODEL_BlankPattern = Util.getResource("item/pattern");
    public static final ResourceLocation locBlankPattern = Util.getResource("pattern");

    private static ModelResourceLocation getTableLoc(BlockToolTable.TableTypes type) {
        return new ModelResourceLocation(LOCATION_ToolTable, String.format("%s=%s", BlockToolTable.TABLES.func_177701_a(), BlockToolTable.TABLES.func_177702_a((Enum)type)));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ToolClientEvents.replacePatternModel(locBlankPattern, MODEL_BlankPattern, event, CustomTextureCreator.patternLocString, TinkerRegistry.getPatternItems());
        ToolClientEvents.replaceTableModel(locCraftingStation, MODEL_CraftingStation, event);
        ToolClientEvents.replaceTableModel(locStencilTable, MODEL_StencilTable, event);
        ToolClientEvents.replaceTableModel(locPartBuilder, MODEL_PartBuilder, event);
        ToolClientEvents.replaceTableModel(locToolStation, MODEL_ToolStation, event);
        ToolClientEvents.replaceTableModel(locToolForge, MODEL_ToolForge, event);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(LOCATION_ToolTable, "inventory"), event.getModelRegistry().func_82594_a((Object)locToolStation));
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(LOCATION_ToolForge, "inventory"), event.getModelRegistry().func_82594_a((Object)locToolForge));
    }

    public static void replaceTableModel(ModelResourceLocation modelVariantLocation, ResourceLocation modelLocation, ModelBakeEvent event) {
        try {
            IBakedModel standard;
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            if (model instanceof IModel && (standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelVariantLocation)) instanceof IBakedModel) {
                BakedTableModel finalModel = new BakedTableModel(standard, model, DefaultVertexFormats.field_176600_a);
                event.getModelRegistry().func_82595_a((Object)modelVariantLocation, (Object)finalModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void replacePatternModel(ResourceLocation locPattern, ResourceLocation modelLocation, ModelBakeEvent event, String baseString, Iterable<Item> items) {
        ToolClientEvents.replacePatternModel(locPattern, modelLocation, event, baseString, items, -1);
    }

    public static void replacePatternModel(ResourceLocation locPattern, ResourceLocation modelLocation, ModelBakeEvent event, String baseString, Iterable<Item> items, int color) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            if (model instanceof IModel) {
                for (Item item : items) {
                    String suffix = Pattern.getTextureIdentifier(item);
                    String partPatternLocation = locPattern.toString() + suffix;
                    String partPatternTexture = baseString + suffix;
                    IModel partPatternModel = model.retexture(ImmutableMap.of((Object)"layer0", (Object)partPatternTexture));
                    IBakedModel baked = partPatternModel.bake(partPatternModel.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                    if (color > -1) {
                        ImmutableList.Builder quads = ImmutableList.builder();
                        for (BakedQuad quad : baked.func_188616_a(null, null, 0L)) {
                            quads.add((Object)ModelHelper.colorQuad((int)color, (BakedQuad)quad));
                        }
                        baked = new BakedSimple.Wrapper(quads.build(), baked);
                    }
                    event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(partPatternLocation, "inventory"), (Object)baked);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void materialTooltip(ItemTooltipEvent event) {
        for (Material material : TinkerRegistry.getAllMaterials()) {
            if (!material.matches(new ItemStack[]{event.getItemStack()}).isPresent()) continue;
            event.getToolTip().add(TextFormatting.DARK_GRAY + material.getLocalizedName());
        }
    }
}

