/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.core.block.BlockCoreTile;
import cofh.core.block.TileCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BlockTDBase
extends BlockCoreTile {
    protected BlockTDBase(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ThermalDynamics.tabCommon);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult traceResult = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        if (traceResult == null || traceResult.func_178782_a() != pos) {
            return false;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, traceResult.field_72307_f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (player.func_70093_af() && WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world)) {
                this.dismantleBlock(world, pos, state, player, false);
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        TileGrid tile = (TileGrid)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tile.onWrench(player, side);
            }
            WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            return true;
        }
        return tile.openGui(player);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.field_149781_w / 5.0f;
    }

    public ArrayList<ItemStack> dropDelegate(NBTTagCompound nbt, IBlockAccess world, BlockPos pos, int fortune) {
        return this.dismantleDelegate(nbt, (World)world, pos, null, false, true);
    }

    public ArrayList<ItemStack> dismantleDelegate(NBTTagCompound nbt, World world, BlockPos pos, EntityPlayer player, boolean returnDrops, boolean simulate) {
        ItemStack dropBlock;
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        ItemStack itemStack = dropBlock = tile instanceof TileGrid ? ((TileGrid)tile).getDrop() : new ItemStack((Block)this, 1, meta);
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(dropBlock);
        if (tile instanceof TileGrid) {
            TileGrid ductBase = (TileGrid)tile;
            TileGrid.AttachmentData attachmentData = ductBase.attachmentData;
            if (attachmentData != null) {
                for (Attachment attachment : attachmentData.attachments) {
                    if (attachment == null) continue;
                    ret.addAll(attachment.getDrops());
                }
                for (Attachment attachment : attachmentData.covers) {
                    if (attachment == null) continue;
                    ret.addAll(((Cover)attachment).getDrops());
                }
            }
            ductBase.dropAdditional(ret);
        }
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        if (!simulate) {
            if (tile instanceof TileCore) {
                ((TileCore)tile).blockDismantled();
            }
            world.func_175698_g(pos);
            if (!returnDrops) {
                for (ItemStack stack : ret) {
                    float f = 0.3f;
                    double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem dropEntity = new EntityItem(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + d, (double)pos.func_177952_p() + z2, stack);
                    dropEntity.func_174867_a(10);
                    world.func_72838_d((Entity)dropEntity);
                }
                if (player != null) {
                    CoreUtils.dismantleLog((String)player.func_70005_c_(), (Block)this, (int)meta, (BlockPos)pos);
                }
            }
        }
        return ret;
    }
}

