/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.proxy;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.vec.Cuboid6;
import cofh.core.render.IModelRegister;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.CoverRenderer;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.RenderTransport;
import cofh.thermaldynamics.duct.tiles.TileDuctFluid;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.item.ItemAttachment;
import cofh.thermaldynamics.proxy.Proxy;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.render.RenderDuctFluids;
import cofh.thermaldynamics.render.RenderDuctItems;
import cofh.thermaldynamics.render.item.RenderItemCover;
import cofh.thermaldynamics.util.TickHandlerClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProxyClient
extends Proxy {
    public static EnumBlockRenderType renderType;
    private static List<IModelRegister> modelRegisters;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerClient.INSTANCE);
        ModelRegistryHelper.registerItemRenderer((Item)TDItems.itemCover, (IItemRenderer)RenderItemCover.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityTransport.class, RenderTransport::new);
        for (IModelRegister register : modelRegisters) {
            register.registerModels();
        }
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Fast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.EnergyFast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Super.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Hardened.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.INSTANCE);
        CoverRenderer.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        renderType = BlockRenderingRegistry.createRenderType((String)"thermaldynamics");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)renderType, (ICCBlockRenderer)RenderDuct.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleTextureStitchEventPre(TextureStitchEvent.Pre event) {
        TDTextures.registerTextures(event.getMap());
        for (int i = 0; i < TDDucts.ductList.size(); ++i) {
            if (!TDDucts.isValid(i)) continue;
            TDDucts.ductList.get(i).registerIcons(event.getMap());
        }
        TDDucts.structureInvis.registerIcons(event.getMap());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        RenderDuct.initialize();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        float partialTicks;
        EntityPlayer player;
        RayTraceResult target = event.getTarget();
        if (this.doAttachmentHighlight(target, player = event.getPlayer(), partialTicks = event.getPartialTicks())) {
            event.setCanceled(true);
        } else if (this.doDuctHighlight(target, player, partialTicks)) {
            event.setCanceled(true);
        }
    }

    private boolean doAttachmentHighlight(RayTraceResult target, EntityPlayer player, float partialTicks) {
        if (!(ItemHelper.getHeldStack((EntityPlayer)player).func_77973_b() instanceof ItemAttachment) || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        RayTracer.retraceBlock((World)player.field_70170_p, (EntityPlayer)player, (BlockPos)target.func_178782_a());
        ItemStack stack = ItemHelper.getHeldStack((EntityPlayer)player);
        Attachment attachment = ItemAttachment.getAttachment(stack, player, player.field_70170_p, target.func_178782_a(), target.field_178784_b);
        if (attachment == null || !attachment.canAddToTile(attachment.baseTile)) {
            return false;
        }
        Cuboid6 c = attachment.getCuboid();
        c.max.subtract(c.min);
        RenderHitbox.drawSelectionBox((EntityPlayer)player, (RayTraceResult)target, (float)partialTicks, (CustomHitBox)new CustomHitBox(c.max.y, c.max.z, c.max.x, (double)attachment.baseTile.x() + c.min.x, (double)attachment.baseTile.y() + c.min.y, (double)attachment.baseTile.z() + c.min.z));
        attachment.drawSelectionExtra(player, target, partialTicks);
        return true;
    }

    private boolean doDuctHighlight(RayTraceResult target, EntityPlayer player, float partialTicks) {
        ICustomHitBox hitbox;
        if (target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        RayTracer.retraceBlock((World)player.field_70170_p, (EntityPlayer)player, (BlockPos)target.func_178782_a());
        TileEntity tile = player.field_70170_p.func_175625_s(target.func_178782_a());
        if (tile instanceof ICustomHitBox && (hitbox = (ICustomHitBox)tile).shouldRenderCustomHitBox(target.subHit, player)) {
            RenderHitbox.drawSelectionBox((EntityPlayer)player, (RayTraceResult)target, (float)partialTicks, (CustomHitBox)hitbox.getCustomHitBox(target.subHit, player));
            return true;
        }
        return false;
    }

    @Override
    public boolean addIModelRegister(IModelRegister register) {
        return modelRegisters.add(register);
    }

    static {
        modelRegisters = new ArrayList<IModelRegister>();
    }
}

