/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.lib.vec.uv.UVTransformation;
import cofh.core.render.TextureHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.init.TDProps;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.render.ModelHelper;
import cofh.thermalfoundation.init.TFFluids;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RenderDuct
implements ICCBlockRenderer {
    public static final RenderDuct INSTANCE = new RenderDuct();
    static final int[] INV_CONNECTIONS = new int[]{BlockDuct.ConnectionType.DUCT.ordinal(), BlockDuct.ConnectionType.DUCT.ordinal(), 0, 0, 0, 0};
    public static CCModel[][] modelConnection = new CCModel[3][6];
    public static CCModel[] modelOpaqueTubes;
    public static CCModel[] modelTransTubes;
    static TextureAtlasSprite textureCenterLine;
    static CCModel[][] modelFluid;
    static CCModel modelCenter;
    static CCModel[] modelLine;
    static CCModel modelLineCenter;
    static CCModel[] modelFrameConnection;
    static CCModel[] modelFrame;
    static CCModel[] modelTransportConnection;
    static CCModel[] modelTransport;
    private static CCModel[] modelFluidTubes;
    private static CCModel[] modelLargeTubes;

    public static void initialize() {
        textureCenterLine = TextureHelper.getTexture((ResourceLocation)TFFluids.fluidSteam.getStill());
    }

    private static void generateFluidModels() {
        for (int i = 1; i < 7; ++i) {
            double d1 = 0.47 - 0.025 * (double)i;
            double d2 = 0.53 + 0.025 * (double)i;
            double d3 = 0.32 + 0.06 * (double)i;
            double c1 = 0.32;
            double c2 = 0.68;
            double[][] boxes = new double[][]{{d1, 0.0, d1, d2, c1, d2}, {d1, d3, d1, d2, 1.0, d2}, {c1, c1, 0.0, c2, d3, c1}, {c1, c1, c2, c2, d3, 1.0}, {0.0, c1, c1, c1, d3, c2}, {c2, c1, c1, 1.0, d3, c2}, {c1, c1, c1, c2, d3, c2}};
            for (int s = 0; s < 7; ++s) {
                RenderDuct.modelFluid[i - 1][s] = CCModel.quadModel((int)24).generateBlock(0, boxes[s][0], boxes[s][1], boxes[s][2], boxes[s][3], boxes[s][4], boxes[s][5]).computeNormals();
            }
        }
    }

    private static void generateModels() {
        modelCenter = CCModel.quadModel((int)48).generateBox(0, -3.0, -3.0, -3.0, 6.0, 6.0, 6.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        RenderDuct.modelConnection[0][1] = CCModel.quadModel((int)48).generateBlock(0, new Cuboid6(0.3125, 0.6875, 0.3125, 0.6875, 1.0, 0.6875).expand(-9.765625E-4));
        RenderDuct.modelConnection[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals();
        RenderDuct.modelConnection[2][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 3.9990234375, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals();
        double h = 0.4;
        modelLineCenter = CCModel.quadModel((int)24).generateBlock(0, h, h, h, 1.0 - h, 1.0 - h, 1.0 - h).computeNormals();
        RenderDuct.modelLine[1] = CCModel.quadModel((int)16).generateBlock(0, h, 1.0 - h, h, 1.0 - h, 1.0, 1.0 - h, 3).computeNormals();
        CCModel.generateSidedModels((CCModel[])modelLine, (int)1, (Vector3)Vector3.center);
        modelOpaqueTubes = ModelHelper.StandardTubes.genModels(0.1875f, true);
        modelTransTubes = ModelHelper.StandardTubes.genModels(0.1875f, false);
        modelFluidTubes = ModelHelper.StandardTubes.genModels(0.1875f * TDProps.smallInnerModelScaling, false, false);
        modelLargeTubes = ModelHelper.StandardTubes.genModels(0.21875f, true);
        modelFrameConnection = new ModelHelper.OctagonalTubeGen(0.375, 0.1812, true).generateModels();
        modelFrame = new ModelHelper.OctagonalTubeGen(0.375 * (double)TDProps.largeInnerModelScaling, 0.1812, false).generateModels();
        modelTransportConnection = new ModelHelper.OctagonalTubeGen(0.5 * (double)TDProps.largeInnerModelScaling, 0.1812, true).generateModels();
        modelTransport = new ModelHelper.OctagonalTubeGen(0.5 * (double)TDProps.largeInnerModelScaling * (double)TDProps.largeInnerModelScaling, 0.1812, false).generateModels();
        CCModel.generateBackface((CCModel)modelCenter, (int)0, (CCModel)modelCenter, (int)24, (int)24);
        CCModel.generateBackface((CCModel)modelConnection[0][1], (int)0, (CCModel)modelConnection[0][1], (int)24, (int)24);
        modelConnection[0][1].apply((Transformation)new Translation(-0.5, -0.5, -0.5));
        for (CCModel[] aModelConnection1 : modelConnection) {
            CCModel.generateSidedModels((CCModel[])aModelConnection1, (int)1, (Vector3)Vector3.zero);
        }
        Scale[] mirrors = new Scale[]{new Scale(1.0, -1.0, 1.0), new Scale(1.0, 1.0, -1.0), new Scale(-1.0, 1.0, 1.0)};
        for (CCModel[] sideModels : modelConnection) {
            int s;
            for (s = 2; s < 6; s += 2) {
                sideModels[s] = sideModels[0].sidedCopy(0, s, Vector3.zero);
            }
            for (s = 1; s < 6; s += 2) {
                sideModels[s] = sideModels[s - 1].backfacedCopy().apply((Transformation)mirrors[s / 2]);
            }
        }
        modelCenter.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
        CCModel[][] cCModelArray = modelConnection;
        int n = cCModelArray.length;
        for (int i = 0; i < n; ++i) {
            CCModel[] aModelConnection;
            for (CCModel anAModelConnection : aModelConnection = cCModelArray[i]) {
                anAModelConnection.computeNormals().computeLighting(LightModel.standardLightModel).shrinkUVs(9.765625E-4);
            }
        }
    }

    public boolean renderBase(CCRenderState ccrs, boolean invRender, Duct ductType, int[] connection, Translation trans, TextureAtlasSprite iconBaseTexture) {
        int s;
        int c = 0;
        for (s = 0; s < 6; ++s) {
            IconTransformation icon;
            if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct()) continue;
            if (connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal()) {
                icon = RenderUtils.getIconTransformation((TextureAtlasSprite)TDDucts.structure.iconBaseTexture);
                modelConnection[0][s].render(ccrs, 8, 24, new IVertexOperation[]{trans, icon});
                modelConnection[0][s].render(ccrs, 32, 48, new IVertexOperation[]{trans, icon});
                if (ductType.iconConnectionTexture == null) continue;
                modelConnection[1][s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconConnectionTexture)});
                continue;
            }
            if (connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) {
                icon = RenderUtils.getIconTransformation((TextureAtlasSprite)TDDucts.structure.iconBaseTexture);
                modelConnection[0][s].render(ccrs, 8, 24, new IVertexOperation[]{trans, icon});
                modelConnection[0][s].render(ccrs, 32, 48, new IVertexOperation[]{trans, icon});
                continue;
            }
            c |= 1 << s;
            if (invRender && iconBaseTexture != null) {
                icon = RenderUtils.getIconTransformation((TextureAtlasSprite)TDDucts.structureInvis.iconBaseTexture);
                modelConnection[0][s].render(ccrs, 4, 8, new IVertexOperation[]{trans, icon});
            }
            if (connection[s] != BlockDuct.ConnectionType.TILE_CONNECTION.ordinal() || ductType.iconConnectionTexture == null) continue;
            modelConnection[1][s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconConnectionTexture)});
        }
        if (iconBaseTexture != null) {
            IconTransformation icon = RenderUtils.getIconTransformation((TextureAtlasSprite)iconBaseTexture);
            (ductType.opaque ? modelOpaqueTubes[c] : modelTransTubes[c]).render(ccrs, new IVertexOperation[]{trans, icon});
        }
        if (ductType.iconFluidTexture != null && ductType.fluidTransparency == -1) {
            modelFluidTubes[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFluidTexture)});
        }
        if (ductType.frameType == 1) {
            this.renderSideTubes(ccrs, 0, connection, trans, TDTextures.SIDE_DUCTS);
        } else if (ductType.frameType == 2 && ductType.iconFrameTexture != null) {
            c = 0;
            for (s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
                if (!invRender && connection[s] == BlockDuct.ConnectionType.DUCT.ordinal()) continue;
                modelFrameConnection[64 + s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameBandTexture)});
                modelFrame[70 + s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameTexture)});
            }
            if (RenderDuct.modelFrameConnection[c].verts.length != 0) {
                modelFrameConnection[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameTexture)});
            }
        } else if (ductType.frameType == 3 && ductType.iconFrameTexture != null) {
            c = 0;
            if (!invRender) {
                for (s = 0; s < 6; ++s) {
                    if (BlockDuct.ConnectionType.values()[connection[s]] != BlockDuct.ConnectionType.CLEAN_DUCT) continue;
                    c |= 1 << s;
                }
            }
            modelLargeTubes[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameTexture)});
        } else if (ductType.frameType == 4 && ductType.iconFrameTexture != null) {
            c = 0;
            for (s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
                if (!invRender && connection[s] == BlockDuct.ConnectionType.DUCT.ordinal()) continue;
                modelTransportConnection[64 + s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameBandTexture)});
            }
            if (RenderDuct.modelTransportConnection[c].verts.length != 0) {
                modelTransportConnection[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameTexture)});
            }
        }
        return true;
    }

    public boolean renderSideTubes(CCRenderState ccrs, int pass, int[] connections, Translation trans, TextureAtlasSprite icon) {
        CCModel[] models = pass == 0 ? ModelHelper.SideTubeGen.standardTubes : ModelHelper.SideTubeGen.standardTubesInner;
        int c = 0;
        for (int i = 0; i < 6; ++i) {
            if (!BlockDuct.ConnectionType.values()[connections[i]].renderDuct() || connections[i] == BlockDuct.ConnectionType.CLEAN_DUCT.ordinal()) continue;
            c |= 1 << i;
            if (connections[i] == BlockDuct.ConnectionType.DUCT.ordinal()) continue;
            models[64 + i].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)icon)});
        }
        if (models[c].verts.length == 0) {
            return false;
        }
        models[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)icon)});
        return true;
    }

    public boolean renderWorldExtra(CCRenderState ccrs, boolean invRender, Duct ductType, int[] connection, Translation trans) {
        int s;
        int c;
        TextureAtlasSprite texture = ductType.iconFluidTexture;
        boolean flag = false;
        if (texture != null && ductType.fluidTransparency != -1) {
            c = 0;
            for (s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
            }
            modelFluidTubes[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)texture)});
            flag = true;
        }
        if (ductType.frameType == 1 && ductType.iconFrameFluidTexture != null) {
            boolean bl = flag = this.renderSideTubes(ccrs, 1, connection, trans, ductType.iconFrameFluidTexture) || flag;
        }
        if (ductType.frameType == 2 && ductType.iconFrameFluidTexture != null) {
            c = 0;
            for (s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
                if (!invRender && connection[s] == BlockDuct.ConnectionType.DUCT.ordinal()) continue;
                modelFrame[70 + s].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameFluidTexture)});
            }
            if (RenderDuct.modelFrame[c].verts.length != 0) {
                modelFrame[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameFluidTexture)});
                flag = true;
            }
        }
        if (ductType.frameType == 4 && ductType.iconFrameFluidTexture != null) {
            c = 0;
            for (s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
            }
            if (RenderDuct.modelTransport[c].verts.length != 0) {
                modelTransport[c].render(ccrs, new IVertexOperation[]{trans, RenderUtils.getIconTransformation((TextureAtlasSprite)ductType.iconFrameFluidTexture)});
                flag = true;
            }
        }
        return flag;
    }

    public void renderFluid(CCRenderState ccrs, FluidStack stack, int[] connection, int level, double x, double y, double z) {
        if (stack == null || stack.amount <= 0 || level <= 0) {
            return;
        }
        ccrs.startDrawing(7, DefaultVertexFormats.field_181709_i);
        Fluid fluid = stack.getFluid();
        ccrs.setFluidColour(stack);
        RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
        TextureAtlasSprite fluidTex = RenderHelper.getFluidTexture((FluidStack)stack);
        if (fluid.isGaseous(stack)) {
            ccrs.alphaOverride = 32 + 32 * level;
            level = 6;
        }
        if (level < 6) {
            CCModel[] models = modelFluid[level - 1];
            for (int s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                models[s].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)fluidTex));
            }
            models[6].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)fluidTex));
        } else {
            int c = 0;
            for (int s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connection[s]].renderDuct() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal() || connection[s] == BlockDuct.ConnectionType.STRUCTURE_CLEAN.ordinal()) continue;
                c |= 1 << s;
            }
            modelFluidTubes[c].render(ccrs, x + 0.5, y + 0.5, z + 0.5, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)fluidTex));
        }
        ccrs.draw();
    }

    public int[] getDuctConnections(TileGrid tile) {
        int[] connections = new int[6];
        for (int i = 0; i < 6; ++i) {
            connections[i] = tile.getVisualConnectionType(i).ordinal();
        }
        return connections;
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        Translation trans = new Translation((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.bind(buffer);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileGrid)) {
            return false;
        }
        TileGrid theTile = (TileGrid)tile;
        ccrs.preRenderWorld(world, pos);
        int[] connections = this.getDuctConnections(theTile);
        boolean flag = false;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (theTile.attachmentData != null) {
            for (Attachment attachment : theTile.attachmentData.attachments) {
                if (attachment == null) continue;
                flag = attachment.render(world, layer, ccrs) || flag;
            }
            for (Attachment attachment : theTile.attachmentData.covers) {
                if (attachment == null) continue;
                flag = ((Cover)attachment).render(world, layer, ccrs) || flag;
            }
        }
        if (layer == BlockRenderLayer.CUTOUT) {
            this.renderBase(ccrs, false, theTile.getDuctType(), connections, trans, theTile.getBaseIcon());
            flag = true;
        } else if (layer == BlockRenderLayer.TRANSLUCENT) {
            flag = this.renderWorldExtra(ccrs, false, theTile.getDuctType(), connections, trans) || flag;
        }
        return flag;
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void registerTextures(TextureMap map) {
    }

    static {
        modelFluid = new CCModel[6][7];
        modelLine = new CCModel[6];
        modelFrameConnection = new CCModel[64];
        modelFrame = new CCModel[64];
        modelTransportConnection = new CCModel[64];
        modelTransport = new CCModel[64];
        RenderDuct.generateModels();
        RenderDuct.generateFluidModels();
    }
}

