/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.util.Copyable;
import codechicken.lib.util.TransformUtils;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.common.model.IModelState;

public class ModelProperties
implements Copyable<ModelProperties> {
    public static final ModelProperties DEFAULT_ITEM = new ModelProperties(true, false);
    public static final ModelProperties DEFAULT_BLOCK = new ModelProperties(true, true);
    private final boolean isAO;
    private final boolean isGui3D;
    private final boolean isBuiltInRenderer;
    private final TextureAtlasSprite particle;

    public ModelProperties(boolean isAO, boolean isGui3D) {
        this(isAO, isGui3D, false, null);
    }

    public ModelProperties(ModelProperties properties, TextureAtlasSprite sprite) {
        this(properties.isAmbientOcclusion(), properties.isGui3d(), properties.isBuiltInRenderer(), sprite);
    }

    public ModelProperties(boolean isAO, boolean isGui3D, TextureAtlasSprite sprite) {
        this(isAO, isGui3D, false, sprite);
    }

    public ModelProperties(ModelProperties properties) {
        this(properties.isAO, properties.isGui3D, properties.isBuiltInRenderer, properties.particle);
    }

    public ModelProperties(boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
        this.isAO = isAO;
        this.isGui3D = isGui3D;
        this.isBuiltInRenderer = isBuiltInRenderer;
        this.particle = particle;
    }

    public static ModelProperties createFromModel(IBakedModel model) {
        return new ModelProperties(model.func_177555_b(), model.func_177556_c(), model.func_188618_c(), model.func_177554_e());
    }

    public boolean isAmbientOcclusion() {
        return this.isAO;
    }

    public boolean isGui3d() {
        return this.isGui3D;
    }

    public boolean isBuiltInRenderer() {
        return this.isBuiltInRenderer;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.particle;
    }

    @Override
    public ModelProperties copy() {
        return new ModelProperties(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isAO;
        private boolean isGui3D;
        private boolean isBuiltInRenderer;
        private TextureAtlasSprite particle;

        protected Builder() {
        }

        protected Builder(boolean ao, boolean gui3D, boolean builtInRenderer, TextureAtlasSprite sprite) {
            this.isAO = ao;
            this.isGui3D = gui3D;
            this.isBuiltInRenderer = builtInRenderer;
            this.particle = sprite;
        }

        public Builder copyFrom(IBakedModel model) {
            this.isAO = model.func_177555_b();
            this.isGui3D = model.func_177556_c();
            this.isBuiltInRenderer = model.func_188618_c();
            this.particle = model.func_177554_e();
            return this;
        }

        public Builder copyFrom(ModelProperties properties) {
            this.isAO = properties.isAO;
            this.isGui3D = properties.isGui3D;
            this.isBuiltInRenderer = properties.isBuiltInRenderer;
            this.particle = properties.particle;
            return this;
        }

        public Builder withAO(boolean ao) {
            this.isAO = ao;
            return this;
        }

        public Builder withGui3D(boolean gui3D) {
            this.isGui3D = gui3D;
            return this;
        }

        public Builder withBuiltInRenderer(boolean builtInRenderer) {
            this.isBuiltInRenderer = builtInRenderer;
            return this;
        }

        public Builder withParticle(TextureAtlasSprite sprite) {
            this.particle = sprite;
            return this;
        }

        public PerspectiveProperties.PerspectiveBuilder withState(IModelState state) {
            PerspectiveProperties.PerspectiveBuilder builder = new PerspectiveProperties.PerspectiveBuilder(this);
            builder.withState(state);
            return builder;
        }

        public ModelProperties build() {
            return new ModelProperties(this.isAO, this.isGui3D, this.isBuiltInRenderer, this.particle);
        }
    }

    public static class PerspectiveProperties
    extends ModelProperties {
        public static final PerspectiveProperties DEFAULT_ITEM = new PerspectiveProperties(TransformUtils.DEFAULT_ITEM, true, false);
        public static final PerspectiveProperties DEFAULT_BLOCK = new PerspectiveProperties(TransformUtils.DEFAULT_BLOCK, true, true);
        private final IModelState modelState;

        public PerspectiveProperties(IModelState state, boolean isAO, boolean isGui3D) {
            this(state, isAO, isGui3D, false, null);
        }

        public PerspectiveProperties(IModelState state, boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this(state, new ModelProperties(isAO, isGui3D, isBuiltInRenderer, particle));
        }

        public PerspectiveProperties(PerspectiveProperties properties) {
            this(properties.getModelState(), properties);
        }

        public PerspectiveProperties(IModelState state, ModelProperties properties) {
            super(properties);
            this.modelState = state;
        }

        public IModelState getModelState() {
            return this.modelState;
        }

        @Override
        public PerspectiveProperties copy() {
            return new PerspectiveProperties(this);
        }

        public static class PerspectiveBuilder
        extends Builder {
            private IModelState state;

            protected PerspectiveBuilder(Builder builder) {
                super(builder.isAO, builder.isAO, builder.isBuiltInRenderer, builder.particle);
            }

            @Override
            public PerspectiveBuilder withState(IModelState state) {
                this.state = state;
                return this;
            }

            @Override
            public PerspectiveProperties build() {
                return new PerspectiveProperties(this.state, super.build());
            }
        }
    }
}

