/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.internal.CCLLog;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.texture.TextureUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import org.apache.logging.log4j.Level;

public class CCBlockRendererDispatcher
extends BlockRendererDispatcher
implements TextureUtils.IIconRegister {
    public final BlockRendererDispatcher parentDispatcher;

    public CCBlockRendererDispatcher(BlockRendererDispatcher dispatcher, BlockColors blockColours) {
        super(dispatcher.func_175023_a(), blockColours);
        this.parentDispatcher = dispatcher;
    }

    public void func_175020_a(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        if (BlockRenderingRegistry.canHandle(state.func_185901_i())) {
            BlockRenderingRegistry.renderBlockDamage(blockAccess, pos, state, texture);
        } else {
            this.parentDispatcher.func_175020_a(state, pos, texture, blockAccess);
        }
    }

    public boolean func_175018_a(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        IBlockState inState;
        block8: {
            inState = state;
            try {
                if (!BlockRenderingRegistry.canHandle(state.func_185901_i())) break block8;
                if (blockAccess.func_175624_G() != WorldType.field_180272_g) {
                    try {
                        state = state.func_185899_b(blockAccess, pos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return BlockRenderingRegistry.renderBlock(blockAccess, pos, state, worldRendererIn);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tessellating CCL block in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tessellated");
                CrashReportCategory.func_180523_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.func_177230_c(), (int)state.func_177230_c().func_176201_c(state));
                throw new ReportedException(crashreport);
            }
        }
        try {
            return this.parentDispatcher.func_175018_a(state, pos, blockAccess, worldRendererIn);
        }
        catch (Exception e) {
            if (!(e instanceof ReportedException)) {
                String clazzName = inState != null ? inState.func_177230_c().getClass().toString() : "UNKNOWN";
                CCLLog.log(Level.ERROR, e, "CCL has caught an exception whilst another mod's block is being rendered. Original crash may have been discarded, possible null client side tile. Pos: '%s', State: '%s', block class: '%s'", pos, inState, clazzName);
                return false;
            }
            throw e;
        }
    }

    public void func_175016_a(IBlockState state, float brightness) {
        if (BlockRenderingRegistry.canHandle(state.func_185901_i())) {
            BlockRenderingRegistry.renderBlockBrightness(state, brightness);
        }
        super.func_175016_a(state, brightness);
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        BlockRenderingRegistry.registerTextures(textureMap);
    }

    public BlockModelRenderer func_175019_b() {
        return this.parentDispatcher.func_175019_b();
    }

    public IBakedModel func_184389_a(IBlockState state) {
        return this.parentDispatcher.func_184389_a(state);
    }

    public BlockModelShapes func_175023_a() {
        return this.parentDispatcher.func_175023_a();
    }
}

