/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.OpenGLUtils;
import codechicken.lib.render.shader.ShaderProgram;
import java.util.function.IntConsumer;
import org.lwjgl.opengl.GL20;

public class ShaderObject {
    private ShaderType shaderType;
    protected String shaderSource;
    int shaderID;
    private IntConsumer onLink = i -> {};
    private ShaderProgram.IUniformCallback useCallback = cache -> {};
    private boolean isCompiled;
    private boolean recompileRequested;

    public ShaderObject(ShaderType shaderType, String shaderSource) {
        this(shaderType);
        this.shaderSource = shaderSource;
    }

    protected ShaderObject(ShaderType shaderType) {
        this.shaderType = shaderType;
        if (!shaderType.isSupported()) {
            throw new RuntimeException(String.format("Unable to create ShaderObject with type %s, Type not supported in current OpenGL context!", new Object[]{shaderType}));
        }
        this.shaderID = GL20.glCreateShader((int)shaderType.glCode);
        if (this.shaderID == 0) {
            throw new RuntimeException("Unable to create new ShaderObject! GL Allocation has failed.");
        }
    }

    public ShaderObject compileShader() {
        if (!this.isCompiled || this.recompileRequested) {
            this.isCompiled = false;
            GL20.glShaderSource((int)this.shaderID, (CharSequence)this.getShaderSource());
            GL20.glCompileShader((int)this.shaderID);
            if (GL20.glGetShaderi((int)this.shaderID, (int)35713) == 0) {
                throw new IllegalStateException(String.format("Unable to compile %s shader object:\n%s", this.shaderType.name(), OpenGLUtils.glGetShaderInfoLog(this.shaderID)));
            }
            this.isCompiled = true;
        }
        return this;
    }

    public ShaderObject addLinkCallback(IntConsumer callback) {
        this.onLink = this.onLink.andThen(callback);
        return this;
    }

    public ShaderObject addUseCallback(ShaderProgram.IUniformCallback callback) {
        this.useCallback = this.useCallback.with(callback);
        return this;
    }

    public ShaderObject disposeObject() {
        GL20.glDeleteShader((int)this.shaderID);
        return this;
    }

    public ShaderObject requestRecompile() {
        this.recompileRequested = true;
        return this;
    }

    public boolean isRecompileRequested() {
        return this.recompileRequested;
    }

    protected String getShaderSource() {
        return this.shaderSource;
    }

    void onShaderLink(int program) {
        if (this.onLink != null) {
            this.onLink.accept(program);
        }
    }

    void onShaderUse(ShaderProgram.UniformCache cache) {
        if (this.useCallback != null) {
            this.useCallback.apply(cache);
        }
    }

    public static enum ShaderType {
        VERTEX(35633, OpenGLUtils.openGL20),
        FRAGMENT(35632, OpenGLUtils.openGL20),
        GEOMETRY(36313, OpenGLUtils.openGL32),
        TESS_CONTROL(36488, OpenGLUtils.openGL40),
        TESS_EVAL(36487, OpenGLUtils.openGL40);

        private int glCode;
        private boolean isSupported;

        private ShaderType(int glCode, boolean isSupported) {
            this.glCode = glCode;
            this.isSupported = isSupported;
        }

        public boolean isSupported() {
            return this.isSupported;
        }
    }
}

