/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.item;

import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockMultipart
extends ItemBlock {
    protected final IMultipart multipartBlock;

    public ItemBlockMultipart(Block block, IMultipart multipartBlock) {
        super(block);
        this.multipartBlock = multipartBlock;
    }

    public <T extends Block> ItemBlockMultipart(T block) {
        this(block, (IMultipart)block);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemBlockMultipart.place(player, world, pos, hand, facing, hitX, hitY, hitZ, (Item)this, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((Block)this.field_150939_a).getStateForPlacement(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8), this.multipartBlock, this::placeBlockAtTested, ItemBlockMultipart::placePartAt);
    }

    public static EnumActionResult place(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, Item item, IBlockPlacementInfo stateProvider, IMultipart multipartBlock, IBlockPlacementLogic blockLogic, IPartPlacementLogic partLogic) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            int meta = item.func_77647_b(stack.func_77960_j());
            float d = Math.abs(hitX * (float)facing.func_82601_c() + hitY * (float)facing.func_96559_d() + hitZ * (float)facing.func_82599_e());
            if (!(d != 0.0f && d != 1.0f && ItemBlockMultipart.placeAt(stack, player, hand, world, pos, facing, hitX, hitY, hitZ, stateProvider, meta, multipartBlock, blockLogic, partLogic) || ItemBlockMultipart.placeAt(stack, player, hand, world, pos = pos.func_177972_a(facing), facing, hitX, hitY, hitZ, stateProvider, meta, multipartBlock, blockLogic, partLogic))) {
                return EnumActionResult.FAIL;
            }
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static boolean placeAt(ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockPlacementInfo stateProvider, int meta, IMultipart multipartBlock, IBlockPlacementLogic blockLogic, IPartPlacementLogic partLogic) {
        IBlockState state = stateProvider.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand);
        AxisAlignedBB bb = state.func_185890_d((IBlockAccess)world, pos);
        if ((bb == null || world.func_72855_b(bb.func_186670_a(pos))) && blockLogic.place(stack, player, world, pos, facing, hitX, hitY, hitZ, state)) {
            return true;
        }
        bb = multipartBlock.getCollisionBoundingBox(world, pos, state);
        return (bb == null || world.func_72855_b(bb.func_186670_a(pos))) && partLogic.placePart(stack, player, hand, world, pos, facing, hitX, hitY, hitZ, multipartBlock, state);
    }

    public boolean placeBlockAtTested(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState newState) {
        return player.func_175151_a(pos, facing, stack) && world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.field_150939_a.func_176196_c(world, pos) && super.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, newState);
    }

    public static boolean placePartAt(ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IMultipart multipartBlock, IBlockState state) {
        IPartSlot slot = multipartBlock.getSlotForPlacement(world, pos, state, facing, hitX, hitY, hitZ, (EntityLivingBase)player);
        if (MultipartHelper.addPart(world, pos, slot, state, false)) {
            IPartInfo info;
            if (!world.field_72995_K && (info = (IPartInfo)MultipartHelper.getContainer((IBlockAccess)world, pos).flatMap(c -> c.get(slot)).orElse(null)) != null) {
                ItemBlockMultipart.setMultipartTileNBT(player, stack, info);
                multipartBlock.onPartPlacedBy(info, (EntityLivingBase)player, stack);
            }
            return true;
        }
        return false;
    }

    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public static boolean setMultipartTileNBT(EntityPlayer player, ItemStack stack, IPartInfo info) {
        IMultipartTile tile;
        World world = info.getActualWorld();
        BlockPos pos = info.getPartPos();
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return false;
        }
        NBTTagCompound tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null && (tile = info.getTile()) != null) {
            if (!(world.field_72995_K || !tile.onlyOpsCanSetPartNbt() || player != null && player.func_189808_dh())) {
                return false;
            }
            NBTTagCompound tag1 = tile.writePartToNBT(new NBTTagCompound());
            NBTTagCompound tag2 = tag1.func_74737_b();
            tag1.func_179237_a(tag);
            tag1.func_74768_a("x", pos.func_177958_n());
            tag1.func_74768_a("y", pos.func_177956_o());
            tag1.func_74768_a("z", pos.func_177952_p());
            if (!tag1.equals((Object)tag2)) {
                tile.readPartFromNBT(tag1);
                tile.markPartDirty();
                return true;
            }
        }
        return false;
    }

    public static interface IExtendedBlockPlacementInfo {
        public IBlockState getStateForPlacement(World var1, BlockPos var2, EnumFacing var3, float var4, float var5, float var6, int var7, EntityLivingBase var8, EnumHand var9, IBlockState var10);
    }

    public static interface IBlockPlacementInfo {
        public IBlockState getStateForPlacement(World var1, BlockPos var2, EnumFacing var3, float var4, float var5, float var6, int var7, EntityLivingBase var8, EnumHand var9);
    }

    public static interface IBlockPlacementLogic {
        public boolean place(ItemStack var1, EntityPlayer var2, World var3, BlockPos var4, EnumFacing var5, float var6, float var7, float var8, IBlockState var9);
    }

    public static interface IPartPlacementLogic {
        public boolean placePart(ItemStack var1, EntityPlayer var2, EnumHand var3, World var4, BlockPos var5, EnumFacing var6, float var7, float var8, float var9, IMultipart var10, IBlockState var11);
    }
}

