/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import mcmultipart.MCMultiPart;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.slot.SlotUtil;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.capability.CapabilityJoiner;
import mcmultipart.client.TESRMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.PartInfo;
import mcmultipart.network.MultipartNetworkHandler;
import mcmultipart.network.PacketMultipartAdd;
import mcmultipart.network.PacketMultipartRemove;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TileMultipartContainer
extends TileEntity
implements IMultipartContainer {
    private boolean isInWorld = true;
    private final Map<IPartSlot, PartInfo> parts = new ConcurrentHashMap<IPartSlot, PartInfo>();
    private final Map<IPartSlot, PartInfo> partView = Collections.unmodifiableMap(this.parts);
    private Map<IPartSlot, NBTTagCompound> missingParts;
    private World loadingWorld;

    private TileMultipartContainer(World world, BlockPos pos) {
        this.func_145834_a(world);
        this.func_174878_a(pos);
        this.isInWorld = false;
    }

    public TileMultipartContainer() {
    }

    public void func_145834_a(World world) {
        World prevWorld = this.func_145831_w();
        super.func_145834_a(world);
        this.isInWorld = true;
        if (world != prevWorld) {
            this.parts.values().forEach(PartInfo::refreshWorld);
        }
    }

    protected void func_190201_b(World world) {
        this.loadingWorld = world;
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.forEachTile(te -> te.setPartPos(pos));
    }

    @Override
    public World getPartWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPartPos() {
        return this.func_174877_v();
    }

    @Override
    public Optional<IPartInfo> get(IPartSlot slot) {
        if (slot == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.parts.get(slot));
    }

    @Override
    public boolean canAddPart(IPartSlot slot, IBlockState state, IMultipartTile tile) {
        Set partSlots;
        PartInfo info;
        block3: {
            block2: {
                Preconditions.checkNotNull((Object)slot);
                Preconditions.checkNotNull((Object)state);
                IMultipart part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
                Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
                info = new PartInfo(this, slot, part, state, tile);
                partSlots = Sets.newIdentityHashSet();
                partSlots.addAll(part.getGhostSlots(info));
                partSlots.add(slot);
                if (partSlots.stream().anyMatch(this.parts::containsKey)) break block2;
                if (!this.parts.values().stream().map(i -> i.getPart().getGhostSlots((IPartInfo)i)).flatMap(Collection::stream).anyMatch(partSlots::contains)) break block3;
            }
            partSlots.clear();
            return false;
        }
        partSlots.clear();
        return !MultipartOcclusionHelper.testContainerPartIntersection(this, info);
    }

    @Override
    public void addPart(IPartSlot slot, IBlockState state, IMultipartTile tile) {
        IMultipart part;
        int currentTicking = this.countTickingParts();
        int newTicking = currentTicking + (tile != null && tile.isTickable() ? 1 : 0);
        TileMultipartContainer container = this;
        if (currentTicking == 0 && newTicking > 0) {
            container = new Ticking(this.func_145831_w(), this.func_174877_v());
            this.transferTo(container);
        }
        Preconditions.checkState(((part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c())) != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
        container.addPartDo(slot, state, part, tile);
        IBlockState prevSt = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (container != this) {
            this.isInWorld = false;
            this.func_145831_w().func_180501_a(this.func_174877_v(), MCMultiPart.multipart.func_176223_P().func_177226_a((IProperty)BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(true)), 0);
            this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)container);
        } else if (!this.isInWorld) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), MCMultiPart.multipart.func_176223_P().func_177226_a((IProperty)BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(this instanceof Ticking)), 0);
            this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)this);
        }
        IBlockState st = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().markAndNotifyBlock(this.func_174877_v(), null, prevSt, st, 1);
        this.func_145831_w().func_175664_x(this.func_174877_v());
    }

    private void addPartDo(IPartSlot slot, IBlockState state, IMultipart part, IMultipartTile tile) {
        if (this.missingParts != null) {
            this.missingParts.remove(slot);
        }
        PartInfo info = new PartInfo(this, slot, part, state, tile);
        this.add(slot, info);
        if (tile != null) {
            tile.validatePart();
        }
        if (!this.func_145831_w().field_72995_K) {
            part.onAdded(info);
            this.parts.values().forEach(i -> {
                if (i != info) {
                    i.getPart().onPartAdded((IPartInfo)i, info);
                }
            });
            MultipartNetworkHandler.sendToAllWatching(new PacketMultipartAdd(info), this.func_145831_w(), this.func_174877_v());
        }
    }

    @Override
    public void removePart(IPartSlot slot) {
        PartInfo info = this.parts.get(slot);
        IMultipartTile tile = info.getTile();
        int currentTicking = this.countTickingParts();
        int newTicking = currentTicking - (tile != null && tile.isTickable() ? 1 : 0);
        TileMultipartContainer container = this;
        if (currentTicking > 0 && newTicking == 0) {
            container = new TileMultipartContainer(this.func_145831_w(), this.func_174877_v());
            this.transferTo(container);
        }
        container.removePartDo(slot, info);
        IBlockState prevSt = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (container != this) {
            this.isInWorld = false;
            this.func_145831_w().func_180501_a(this.func_174877_v(), MCMultiPart.multipart.func_176223_P().func_177226_a((IProperty)BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(false)), 0);
            this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)container);
        }
        IBlockState st = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().markAndNotifyBlock(this.func_174877_v(), null, prevSt, st, 1);
        this.func_145831_w().func_175664_x(this.func_174877_v());
    }

    private void removePartDo(IPartSlot slot, PartInfo info) {
        if (this.missingParts != null) {
            this.missingParts.remove(slot);
        }
        this.remove(slot);
        if (!this.func_145831_w().field_72995_K) {
            info.getPart().breakPart(info);
            info.getPart().onRemoved(info);
            this.parts.values().forEach(i -> i.getPart().onPartRemoved((IPartInfo)i, info));
            MultipartNetworkHandler.sendToAllWatching(new PacketMultipartRemove(this.func_174877_v(), slot), this.func_145831_w(), this.func_174877_v());
        }
        if (this.parts.size() == 1) {
            PartInfo part = this.parts.values().iterator().next();
            this.func_145831_w().func_180501_a(this.func_174877_v(), part.getState(), 0);
            if (part.getTile() != null) {
                this.func_145831_w().func_175690_a(this.func_174877_v(), part.getTile().getTileEntity());
            }
        }
    }

    private int countTickingParts() {
        return (int)this.parts.values().stream().map(IPartInfo::getTile).filter(t -> t != null && t.isTickable()).count();
    }

    protected void add(IPartSlot slot, PartInfo partInfo) {
        this.parts.put(slot, partInfo);
        partInfo.setContainer(this);
    }

    protected void remove(IPartSlot slot) {
        this.parts.remove(slot);
    }

    protected void clear() {
        this.parts.clear();
    }

    protected void transferTo(TileMultipartContainer container) {
        container.isInWorld = this.isInWorld;
        this.parts.forEach(container::add);
        if (this.missingParts != null) {
            container.missingParts = this.missingParts;
        }
    }

    public Map<IPartSlot, PartInfo> getParts() {
        return this.partView;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag = this.writeParts(tag, false);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readParts(tag, false, this.loadingWorld);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeParts(tag, true);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readParts(tag, true, this.getPartWorld());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.getPartPos(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    private NBTTagCompound writeParts(NBTTagCompound tag, boolean update) {
        NBTTagCompound parts = new NBTTagCompound();
        this.parts.forEach((s, i) -> {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("state", MCMultiPart.stateMap.func_148747_b((Object)i.getState()));
            IMultipartTile tile = i.getTile();
            if (tile != null) {
                if (update) {
                    t.func_74782_a("tile", (NBTBase)tile.getPartUpdateTag());
                } else {
                    t.func_74782_a("tile", (NBTBase)tile.writePartToNBT(new NBTTagCompound()));
                }
            }
            parts.func_74782_a(Integer.toString(MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)s)), (NBTBase)t);
        });
        if (this.missingParts != null) {
            this.missingParts.forEach((s, t) -> parts.func_74782_a(Integer.toString(MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)s)), (NBTBase)t));
        }
        tag.func_74782_a("parts", (NBTBase)parts);
        return tag;
    }

    private void readParts(NBTTagCompound tag, boolean update, World world) {
        World prevWorld = this.field_145850_b;
        this.field_145850_b = world;
        ObjectIntIdentityMap stateMap = GameData.getBlockStateIDMap();
        NBTTagCompound parts = tag.func_74775_l("parts");
        HashSet<IPartSlot> visitedSlots = new HashSet<IPartSlot>();
        for (String sID : parts.func_150296_c()) {
            IMultipartTile tile;
            IPartSlot slot = (IPartSlot)MCMultiPart.slotRegistry.getValue(Integer.parseInt(sID));
            if (slot == null) continue;
            visitedSlots.add(slot);
            PartInfo prevInfo = this.parts.get(slot);
            NBTTagCompound t = parts.func_74775_l(sID);
            IBlockState state = (IBlockState)stateMap.func_148745_a(t.func_74762_e("state"));
            if (prevInfo != null) {
                prevInfo.setState(state);
                if (!t.func_74764_b("tile")) continue;
                NBTTagCompound tileTag = t.func_74775_l("tile");
                tile = prevInfo.getTile();
                if (update) {
                    if (tile == null) {
                        tile = prevInfo.getPart().createMultipartTile(world, slot, state);
                    }
                    tile.handlePartUpdateTag(tileTag);
                } else {
                    tile = prevInfo.getPart().loadMultipartTile(world, tileTag);
                }
                prevInfo.setTile(tile);
                continue;
            }
            IMultipart part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
            if (part != null) {
                tile = null;
                if (t.func_74764_b("tile")) {
                    NBTTagCompound tileTag = t.func_74775_l("tile");
                    if (update) {
                        tile = part.createMultipartTile(world, slot, state);
                        tile.handlePartUpdateTag(tileTag);
                    } else {
                        tile = part.loadMultipartTile(world, tileTag);
                    }
                }
                this.add(slot, new PartInfo(this, slot, part, state, tile));
                continue;
            }
            if (!update) {
                if (this.missingParts == null) {
                    this.missingParts = new HashMap<IPartSlot, NBTTagCompound>();
                }
                this.missingParts.put(slot, t);
                continue;
            }
            throw new IllegalStateException("Server sent a multipart of type " + state + " which is not registered on the client.");
        }
        HashSet<IPartSlot> removed = new HashSet<IPartSlot>(this.parts.keySet());
        removed.removeAll(visitedSlots);
        removed.forEach(this::remove);
        this.field_145850_b = prevWorld;
    }

    public void onLoad() {
        this.forEachTile(te -> te.setPartPos(this.getPartPos()));
        this.parts.values().forEach(PartInfo::refreshWorld);
        this.forEachTile(IMultipartTile::onPartLoad);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.forEachTile(IMultipartTile::onPartChunkUnload);
    }

    public void func_189668_a(Mirror mirror) {
        super.func_189668_a(mirror);
        this.forEachTile(te -> te.mirrorPart(mirror));
    }

    public void func_189667_a(Rotation rotation) {
        super.func_189667_a(rotation);
        this.forEachTile(te -> te.rotatePart(rotation));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.isInWorld) {
            this.forEachTile(IMultipartTile::invalidatePart);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.forEachTile(IMultipartTile::validatePart);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.forEachTile(IMultipartTile::updatePartContainerInfo);
    }

    public double func_145833_n() {
        return this.parts.values().stream().map(IPartInfo::getTile).filter(t -> t != null).mapToDouble(IMultipartTile::getMaxPartRenderDistanceSquared).max().orElse(super.func_145833_n());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.parts.values().stream().map(IPartInfo::getTile).filter(t -> t != null).reduce(super.getRenderBoundingBox(), (a, b) -> a.func_111270_a(b.getPartRenderBoundingBox()), (a, b) -> b);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean hasFastRenderer() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return this.hasFastRendererC();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean hasFastRendererC() {
        for (IPartInfo iPartInfo : this.parts.values()) {
            TileEntity te = iPartInfo.getTile() != null ? iPartInfo.getTile().getTileEntity() : null;
            if (te == null || TileEntityRendererDispatcher.field_147556_a.func_147547_b(te) == null || te.hasFastRenderer()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.shouldRenderInPassC(pass);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void shouldRenderInPassC(int pass) {
        TESRMultipartContainer.pass = pass;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MCMPCapabilities.MULTIPART_CONTAINER) {
            return true;
        }
        if (SlotUtil.viewContainer(this, i -> i.getTile() != null && i.getTile().hasPartCapability(capability, facing), l -> l.stream().anyMatch(a -> a), false, true, facing).booleanValue()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MCMPCapabilities.MULTIPART_CONTAINER) {
            return (T)this;
        }
        T val = SlotUtil.viewContainer(this, i -> i.getTile() != null && i.getTile().hasPartCapability(capability, facing) ? i.getTile().getPartCapability(capability, facing) : null, l -> CapabilityJoiner.join(capability, l), null, true, facing);
        if (val != null) {
            return val;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void forEachTile(Consumer<IMultipartTile> consumer) {
        for (PartInfo info : this.parts.values()) {
            IMultipartTile tile = info.getTile();
            if (tile == null) continue;
            consumer.accept(tile);
        }
    }

    public static IMultipartContainer createTile(World world, BlockPos pos) {
        return new TileMultipartContainer(world, pos);
    }

    public static IMultipartContainer createTileFromWorldInfo(World world, BlockPos pos) {
        PartInfo info = PartInfo.fromWorld(world, pos);
        boolean tick = info.getTile() != null && info.getTile().isTickable();
        TileMultipartContainer container = tick ? new Ticking(world, pos) : new TileMultipartContainer(world, pos);
        container.isInWorld = false;
        container.add(info.getSlot(), info);
        return container;
    }

    public static class Ticking
    extends TileMultipartContainer
    implements ITickable {
        private final Set<ITickable> tickingParts = Collections.newSetFromMap(new WeakHashMap());

        private Ticking(World world, BlockPos pos) {
            super(world, pos);
        }

        public Ticking() {
        }

        public void func_73660_a() {
            if (this.tickingParts.isEmpty()) {
                IBlockState state = MCMultiPart.multipart.func_176223_P().func_177226_a((IProperty)BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(false));
                this.getPartWorld().func_180501_a(this.getPartPos(), state, 0);
                TileMultipartContainer container = (TileMultipartContainer)MultipartHelper.getContainer((IBlockAccess)this.func_145831_w(), this.func_174877_v()).get();
                this.transferTo(container);
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
                this.func_145831_w().func_175664_x(this.func_174877_v());
                return;
            }
            this.tickingParts.forEach(ITickable::func_73660_a);
        }

        @Override
        protected void add(IPartSlot slot, PartInfo partInfo) {
            super.add(slot, partInfo);
            IMultipartTile te = partInfo.getTile();
            if (te != null && te.isTickable()) {
                this.tickingParts.add(te.getTickable());
            }
        }

        @Override
        protected void remove(IPartSlot slot) {
            this.getPartTile(slot).ifPresent(this.tickingParts::remove);
            super.remove(slot);
        }

        @Override
        protected void clear() {
            this.tickingParts.clear();
            super.clear();
        }
    }
}

