/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mcmultipart.api.addon.IWrappedBlock;
import mcmultipart.api.item.ItemBlockMultipart;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;

public enum MultipartRegistry implements IMultipartRegistry
{
    INSTANCE;

    private final Map<Block, IMultipart> PART_MAP = new HashMap<Block, IMultipart>();
    private final Map<Item, Pair<Predicate<ItemStack>, Pair<WrappedBlock, IMultipart>>> STACK_WRAPPING_MAP = new HashMap<Item, Pair<Predicate<ItemStack>, Pair<WrappedBlock, IMultipart>>>();

    public void computeBlocks() {
        GameRegistry.findRegistry(Block.class).getValues().stream().filter(b -> b instanceof IMultipart).forEach(b -> this.registerPartWrapper((Block)b, (IMultipart)b));
    }

    @Override
    public void registerPartWrapper(Block block, IMultipart part) {
        this.PART_MAP.putIfAbsent(block, part);
    }

    @Override
    public IWrappedBlock registerStackWrapper(Item item, Predicate<ItemStack> predicate, Block block) {
        IMultipart part = this.getPart(block);
        Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)"Attempted to wrap the placement of a block that's not registered as a multipart!");
        WrappedBlock wrappedBlock = new WrappedBlock();
        wrappedBlock.setPlacementInfo((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((Block)block).getStateForPlacement(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8));
        if (item instanceof ItemBlock) {
            wrappedBlock.setBlockPlacementLogic((stack, player, world, pos, facing, hitX, hitY, hitZ, newState) -> player.func_175151_a(pos, facing, stack) && world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && block.func_176196_c(world, pos) && ((ItemBlock)item).placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, newState));
        }
        this.STACK_WRAPPING_MAP.putIfAbsent(item, (Pair<Predicate<ItemStack>, Pair<WrappedBlock, IMultipart>>)Pair.of(predicate, (Object)Pair.of((Object)wrappedBlock, (Object)part)));
        return wrappedBlock;
    }

    public IMultipart getPart(Block block) {
        return this.PART_MAP.get(block);
    }

    public Pair<WrappedBlock, IMultipart> wrapPlacement(ItemStack stack) {
        Pair<Predicate<ItemStack>, Pair<WrappedBlock, IMultipart>> pair = this.STACK_WRAPPING_MAP.get(stack.func_77973_b());
        return pair != null && ((Predicate)pair.getKey()).test(stack) ? (Pair)pair.getValue() : null;
    }

    public final class WrappedBlock
    implements IWrappedBlock {
        private ItemBlockMultipart.IBlockPlacementLogic blockPlacementLogic;
        private ItemBlockMultipart.IPartPlacementLogic partPlacementLogic = ItemBlockMultipart::placePartAt;
        private ItemBlockMultipart.IBlockPlacementInfo placementInfo;

        @Override
        public IWrappedBlock setBlockPlacementLogic(ItemBlockMultipart.IBlockPlacementLogic logic) {
            this.blockPlacementLogic = logic;
            return this;
        }

        @Override
        public IWrappedBlock setPartPlacementLogic(ItemBlockMultipart.IPartPlacementLogic logic) {
            this.partPlacementLogic = logic;
            return this;
        }

        @Override
        public IWrappedBlock setPlacementInfo(ItemBlockMultipart.IBlockPlacementInfo info) {
            this.placementInfo = info;
            return this;
        }

        @Override
        public IWrappedBlock setPlacementInfo(ItemBlockMultipart.IExtendedBlockPlacementInfo info) {
            ItemBlockMultipart.IBlockPlacementInfo prevInfo = this.placementInfo;
            this.placementInfo = (world, pos, facing, hitX, hitY, hitZ, meta, placer, hand) -> info.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand, prevInfo.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand));
            return this;
        }

        public ItemBlockMultipart.IBlockPlacementLogic getBlockPlacementLogic() {
            return this.blockPlacementLogic;
        }

        public ItemBlockMultipart.IPartPlacementLogic getPartPlacementLogic() {
            return this.partPlacementLogic;
        }

        public ItemBlockMultipart.IBlockPlacementInfo getPlacementInfo() {
            return this.placementInfo;
        }
    }
}

