/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import mcmultipart.MCMultiPart;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.world.IWorldView;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.util.MCMPBlockAccessWrapper;
import mcmultipart.util.MCMPWorldWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PartInfo
implements IPartInfo {
    private static final List<BlockRenderLayer> RENDER_LAYERS = FMLCommonHandler.instance().getSide() == Side.CLIENT ? Arrays.asList(BlockRenderLayer.values()) : new ArrayList<BlockRenderLayer>();
    private TileMultipartContainer container;
    private final IPartSlot slot;
    private IMultipart part;
    private IBlockState state;
    private IMultipartTile tile;
    private IWorldView view;
    private MCMPWorldWrapper world;
    private Set<Long> scheduledTicks;

    public PartInfo(TileMultipartContainer container, IPartSlot slot, IMultipart part, IBlockState state, IMultipartTile tile) {
        this.container = container;
        this.slot = slot;
        this.setState(state, false);
        this.setTile(tile);
    }

    @Override
    public World getPartWorld() {
        return this.world == null ? this.getActualWorld() : this.world;
    }

    @Override
    public TileMultipartContainer getContainer() {
        return this.container;
    }

    @Override
    public IPartSlot getSlot() {
        return this.slot;
    }

    @Override
    public IMultipart getPart() {
        return this.part;
    }

    @Override
    public IBlockState getState() {
        return this.state;
    }

    @Override
    public IMultipartTile getTile() {
        return this.tile;
    }

    public void setContainer(TileMultipartContainer container) {
        this.container = container;
        this.refreshWorld();
    }

    public void setState(IBlockState state) {
        this.setState(state, true);
    }

    private void setState(IBlockState state, boolean checkTE) {
        if (state == this.state) {
            return;
        }
        IBlockState oldState = this.state;
        this.state = state;
        if (oldState == null || oldState.func_177230_c() != state.func_177230_c()) {
            this.part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
            this.refreshWorld();
        }
        if (checkTE && (this.tile == null || this.tile.shouldRefreshPart(this.getPartWorld(), this.getPartPos(), oldState, state))) {
            this.setTile(this.part.createMultipartTile(this.getPartWorld(), this.getSlot(), state));
        }
    }

    public void setTile(IMultipartTile tile) {
        this.tile = tile;
        if (this.container != null && this.tile != null) {
            this.tile.setPartWorld(this.getPartWorld());
            this.tile.setPartPos(this.getPartPos());
            this.tile.setPartInfo(this);
        }
    }

    public void refreshWorld() {
        this.view = this.container != null && this.part.shouldWrapWorld() ? this.part.getWorldView(this) : null;
        MCMPWorldWrapper mCMPWorldWrapper = this.world = this.view != null ? new MCMPWorldWrapper(this, this, this.view) : null;
        if (this.tile != null) {
            this.tile.setPartWorld(this.world);
        }
    }

    public IBlockAccess wrapAsNeeded(IBlockAccess world) {
        if (this.view != null) {
            if (world == this.world || world == this.world.getActualWorld()) {
                return this.world;
            }
            return new MCMPBlockAccessWrapper(world, this, this.view);
        }
        return world;
    }

    public void copyMetaFrom(PartInfo info) {
        this.scheduledTicks = info.scheduledTicks;
    }

    public void scheduleTick(int delay) {
        if (this.scheduledTicks == null) {
            this.scheduledTicks = new HashSet<Long>();
        }
        this.scheduledTicks.add((long)delay + this.getContainer().getPartWorld().func_82737_E());
        this.getContainer().getPartWorld().func_175684_a(this.getContainer().getPartPos(), MCMultiPart.multipart, delay);
    }

    public boolean checkAndRemoveTick() {
        return this.scheduledTicks != null && this.scheduledTicks.remove(this.getContainer().getPartWorld().func_82737_E());
    }

    public boolean hasPendingTicks() {
        return this.scheduledTicks != null && !this.scheduledTicks.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public ClientInfo getInfo(IBlockAccess world, BlockPos pos) {
        Set renderLayers;
        IBlockAccess world_ = this.wrapAsNeeded(world);
        IBlockState actualState = this.part.getActualState(world_, pos, this);
        IBlockState extendedState = this.part.getExtendedState(world_, pos, this, actualState);
        if (this.state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            renderLayers = EnumSet.noneOf(BlockRenderLayer.class);
            RENDER_LAYERS.stream().filter(layer -> this.part.canRenderInLayer(world_, pos, this, actualState, (BlockRenderLayer)layer)).forEach(renderLayers::add);
        } else {
            renderLayers = Collections.emptySet();
        }
        return new ClientInfo(actualState, extendedState, renderLayers, index -> Minecraft.func_71410_x().func_184125_al().func_186724_a(extendedState, world_, pos, index));
    }

    public static PartInfo fromWorld(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IMultipart part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
        Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
        TileEntity te = world.func_175625_s(pos);
        IPartSlot slot = part.getSlotFromWorld((IBlockAccess)world, pos, state);
        IMultipartTile tile = Optional.ofNullable(te).map(part::convertToMultipartTile).orElse(null);
        return new PartInfo(null, slot, part, state, tile);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleAdditionPacket(World world, BlockPos pos, IPartSlot slot, IBlockState state, NBTTagCompound tag) {
        MultipartHelper.getInfo((IBlockAccess)world, pos, slot).map(i -> i instanceof PartInfo ? (PartInfo)i : null).ifPresent(IPartInfo::remove);
        TileMultipartContainer tile = MultipartHelper.getOrConvertContainer(world, pos).orElse(null);
        if (tile == null) {
            MCMultiPart.log.error("Failed to handle the addition of the part " + state.func_177230_c().getRegistryName());
            return;
        }
        tile.addPart(slot, state);
        tile = MultipartHelper.getOrConvertContainer(world, pos).orElse(null);
        PartInfo info = tile.get(slot).orElse(null);
        if (info == null) {
            MCMultiPart.log.error("Failed to handle the addition of the part " + state.func_177230_c().getRegistryName());
            return;
        }
        if (tag != null) {
            if (info.getTile() == null) {
                MCMultiPart.log.error("Failed to handle the addition of the part " + state.func_177230_c().getRegistryName());
                return;
            }
            info.getTile().handlePartUpdateTag(tag);
        }
        world.func_175704_b(pos, pos);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void handleUpdatePacket(World world, BlockPos pos, IPartSlot slot, IBlockState state, SPacketUpdateTileEntity pkt) {
        block9: {
            PartInfo info;
            block8: {
                info = MultipartHelper.getInfo((IBlockAccess)world, pos, slot).map(i -> i instanceof PartInfo ? (PartInfo)i : null).orElse(null);
                if (info == null) break block8;
                info.setState(state);
                if (pkt != null) {
                    if (info.getTile() == null) {
                        info.setTile(info.part.createMultipartTile(world, slot, state));
                    }
                    if (info.getTile() != null) {
                        info.getTile().onPartDataPacket(MCMultiPart.proxy.getNetworkManager(), pkt);
                    }
                    break block9;
                } else {
                    info.setTile(info.part.createMultipartTile(world, slot, state));
                }
                break block9;
            }
            TileMultipartContainer tile = MultipartHelper.getOrConvertContainer(world, pos).orElse(null);
            if (tile == null) {
                MCMultiPart.log.error("Failed to handle update packet for part " + state.func_177230_c().getRegistryName());
                return;
            }
            tile.addPart(slot, state);
            tile = MultipartHelper.getOrConvertContainer(world, pos).orElse(null);
            info = tile.get(slot).orElse(null);
            if (info == null) {
                MCMultiPart.log.error("Failed to handle update packet for part " + state.func_177230_c().getRegistryName());
                return;
            }
            if (pkt != null) {
                if (info.getTile() == null) {
                    MCMultiPart.log.error("Failed to handle update packet for part " + state.func_177230_c().getRegistryName());
                    return;
                }
                info.getTile().onPartDataPacket(MCMultiPart.proxy.getNetworkManager(), pkt);
            }
        }
        world.func_175704_b(pos, pos);
    }

    public static void handleRemovalPacket(World world, BlockPos pos, IPartSlot slot) {
        MultipartHelper.getInfo((IBlockAccess)world, pos, slot).map(i -> i instanceof PartInfo ? (PartInfo)i : null).ifPresent(info -> {
            info.remove();
            world.func_175704_b(pos, pos);
        });
    }

    @SideOnly(value=Side.CLIENT)
    public class ClientInfo {
        private final IBlockState actualState;
        private final IBlockState extendedState;
        private final Set<BlockRenderLayer> renderLayers;
        private final IntUnaryOperator tintGetter;

        private ClientInfo(IBlockState actualState, IBlockState extendedState, Set<BlockRenderLayer> renderLayers, IntUnaryOperator tintGetter) {
            this.actualState = actualState;
            this.extendedState = extendedState;
            this.renderLayers = renderLayers;
            this.tintGetter = tintGetter;
        }

        public IBlockState getActualState() {
            return this.actualState;
        }

        public IBlockState getExtendedState() {
            return this.extendedState;
        }

        public boolean canRenderInLayer(BlockRenderLayer layer) {
            return this.renderLayers.contains(layer);
        }

        public int getTint(int index) {
            return this.tintGetter.applyAsInt(index);
        }
    }
}

