JEIEvents.addItems(event => {
  event.add(Item.of('patchouli:guide_book', '{"patchouli:book":"patchouli:tr_guide"}'));

  const candidates = [];
  Ingredient.all.getStacks().forEach(x => {
    if (x.getMod() !== 'architects_palette') return;
    candidates.push(x);
  });

  candidates.sort((a, b) => a.getDisplayName() > b.getDisplayName()).forEach(x => event.add(x));
});

JEIEvents.hideItems(event => {
  const toRemove = JsonIO.read('kubejs/globals/nuked.json').items;
  toRemove.forEach(x => event.hide(x));
  event.hide('techreborn:manual');
});

JEIEvents.information(event => {
  event.addItem(Ingredient.of('sushigocrafting:nori_sheets'), Text.black("Created by throwing a Dried Kelp Block on top of an Iron Block and compacting it with a Piston."));
  event.addItem(Ingredient.of([Item.of('ae2:certus_quartz_crystal', 2), Item.of('ae2:certus_quartz_dust', 5)]), Text.black('Created in Industrial Grinder using Certus Quartz Ores'));
  event.addItem(Ingredient.of([Item.of('ae2:certus_quartz_dust', 5)]), Text.black('Created in Grinder using Certus Quartz Ores'));
  event.addItem(Ingredient.of([Item.of('ae2:certus_quartz_dust')]), Text.black('Created in Grinder using 2x Certus Quartz'));
  event.addItem(Ingredient.of([Item.of('ae2:fluix_dust')]), Text.black('Created in Grinder using 2x Fluix Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:acacia_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Acacia Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:acacia_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Acacia Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:acacia_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Acacia Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:amethyst_shard', 16), Item.of('techreborn:quartz_dust')]), Text.black('Created in Implosion Compressor using 8x Amethyst Dusts, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:amethyst_shard', 16), Item.of('techreborn:quartz_dust')]), Text.black('Created in Implosion Compressor using 8x Amethyst Dusts, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:angler_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Fishing Rod'));
  event.addItem(Ingredient.of([Item.of('minecraft:archer_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Bow'));
  event.addItem(Ingredient.of([Item.of('minecraft:arms_up_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Totem Of Undying'));
  event.addItem(Ingredient.of([Item.of('minecraft:bamboo_mosaic_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Bamboo Mosaic Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:bamboo_planks', 2), Item.of('techreborn:saw_dust')]), Text.black('Created in Industrial Sawmill using Bamboo Blocks'));
  event.addItem(Ingredient.of([Item.of('minecraft:bamboo_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Bamboo Mosaic Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:bamboo_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Bamboo Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:bamboo_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Bamboo Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:birch_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Birch Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:birch_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Birch Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:birch_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Birch Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_bed')]), Text.black('Created in Assembling Machine using 2x Black Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_candle', 2)]), Text.black('Created in Chemical Reactor using Black Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_candle', 2)]), Text.black('Created in Chemical Reactor using Black Dye, 2x Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_carpet', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_carpet', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_concrete_powder')]), Text.black('Created in Grinder using Black Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_dye', 2)]), Text.black('Created in Extractor using Ink Sac'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_dye', 2)]), Text.black('Created in Extractor using Wither Rose'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Black Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Black Dye, 16x Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Black Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Black Dye, 12x Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_terracotta', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_terracotta', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_wool', 4)]), Text.black('Created in Chemical Reactor using Black Dye, 4x Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:black_wool', 4)]), Text.black('Created in Chemical Reactor using Black Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:blackstone')]), Text.black('Created in Blast Furnace using Cobblestone'));
  event.addItem(Ingredient.of([Item.of('minecraft:blade_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Iron Sword'));
  event.addItem(Ingredient.of([Item.of('minecraft:blaze_powder', 4)]), Text.black('Created in Grinder using Blaze Rod'));
  event.addItem(Ingredient.of([Item.of('minecraft:blaze_powder'), Item.of('minecraft:slime_ball')]), Text.black('Created in Centrifuge using 2x Magma Cream'));
  event.addItem(Ingredient.of([Item.of('minecraft:blaze_rod')]), Text.black('Created in Compressor using 5x Blaze Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_bed')]), Text.black('Created in Assembling Machine using 2x Blue Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Cyan Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Light Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_candle', 2)]), Text.black('Created in Chemical Reactor using Cyan Dye, 2x Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x Cyan Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Cyan Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Cyan Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Cyan Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Cyan Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_concrete_powder')]), Text.black('Created in Grinder using Blue Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_dye', 2)]), Text.black('Created in Extractor using Cornflower'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_dye', 2)]), Text.black('Created in Extractor using Lapis Lazuli'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_dye', 5)]), Text.black('Created in Extractor using Tube Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_dye')]), Text.black('Created in Extractor using Tube Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_dye')]), Text.black('Created in Extractor using Tube Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_ice')]), Text.black('Created in Vacuum Freezer using 4x Packed Ice'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Cyan Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Light Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Cyan Dye, 16x Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x Cyan Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Cyan Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Light Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Cyan Dye, 12x Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x Cyan Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Cyan Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Cyan Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Cyan Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Light Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_wool', 4)]), Text.black('Created in Chemical Reactor using Cyan Dye, 4x Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:blue_wool', 4)]), Text.black('Created in Chemical Reactor using Gray Dye, 4x Cyan Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:bone_meal', 6)]), Text.black('Created in Grinder using Bone'));
  event.addItem(Ingredient.of([Item.of('minecraft:bone')]), Text.black('Created in Chemical Reactor using 3x Calcite Dusts, Slime Ball'));
  event.addItem(Ingredient.of([Item.of('minecraft:brewer_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Glass Bottle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_bed')]), Text.black('Created in Assembling Machine using 2x Brown Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Black Dye, 2x Orange Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Brown Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Brown Dye, 2x Orange Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Green Dye, 2x Red Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Orange Dye, 2x Black Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Green Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Orange Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x Orange Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Red Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Black Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Green Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Orange Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x Orange Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Red Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Black Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Green Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_concrete_powder')]), Text.black('Created in Grinder using Brown Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_dye', 2)]), Text.black('Created in Extractor using Cocoa Beans'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Black Dye, 16x Orange Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Brown Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Brown Dye, 16x Orange Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Green Dye, 16x Red Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Orange Dye, 16x Black Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Green Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Black Dye, 12x Orange Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Brown Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Brown Dye, 12x Orange Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Green Dye, 12x Red Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Orange Dye, 12x Black Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Green Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Orange Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x Orange Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Brown Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Red Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Black Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Green Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Black Dye, 4x Orange Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Brown Dye, 4x Orange Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Brown Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Green Dye, 4x Red Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Orange Dye, 4x Black Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:brown_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x Green Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:bucket')]), Text.black('Created in Extractor using Lava Bucket'));
  event.addItem(Ingredient.of([Item.of('minecraft:bucket')]), Text.black('Created in Extractor using Milk Bucket'));
  event.addItem(Ingredient.of([Item.of('minecraft:bucket')]), Text.black('Created in Extractor using Powder Snow Bucket'));
  event.addItem(Ingredient.of([Item.of('minecraft:bucket')]), Text.black('Created in Extractor using Water Bucket'));
  event.addItem(Ingredient.of([Item.of('minecraft:burn_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Campfire'));
  event.addItem(Ingredient.of([Item.of('minecraft:calcite')]), Text.black('Created in Compressor using 5x Calcite Small Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:cherry_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Cherry Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:cherry_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Cherry Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:cherry_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Cherry Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:clay_ball', 4)]), Text.black('Created in Extractor using Clay'));
  event.addItem(Ingredient.of([Item.of('minecraft:coal', 2)]), Text.black('Created in Grinder using Coal Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:coal', 3)]), Text.black('Created in Industrial Grinder using Coal Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:coal', 4)]), Text.black('Created in Industrial Grinder using Coal Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:coast_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Cobblestone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:crimson_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Crimson Stems'));
  event.addItem(Ingredient.of([Item.of('minecraft:crimson_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Crimson Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:crimson_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Crimson Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_bed')]), Text.black('Created in Assembling Machine using 2x Cyan Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Green Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_candle', 2)]), Text.black('Created in Chemical Reactor using Cyan Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_candle', 2)]), Text.black('Created in Chemical Reactor using Cyan Dye, 2x Light Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_candle', 2)]), Text.black('Created in Chemical Reactor using Green Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Green Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_carpet', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_carpet', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_carpet', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Green Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_concrete_powder')]), Text.black('Created in Grinder using Cyan Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_dye', 4)]), Text.black('Created in Extractor using Pitcher Plant'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_dye')]), Text.black('Created in Extractor using Prismarine Shard'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Green Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Cyan Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Cyan Dye, 16x Light Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Green Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Green Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Cyan Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Cyan Dye, 12x Light Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Green Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Green Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_terracotta', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_terracotta', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_terracotta', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Green Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_wool', 4)]), Text.black('Created in Chemical Reactor using Cyan Dye, 4x Light Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_wool', 4)]), Text.black('Created in Chemical Reactor using Cyan Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:cyan_wool', 4)]), Text.black('Created in Chemical Reactor using Green Dye, 4x Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:danger_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Gunpowder'));
  event.addItem(Ingredient.of([Item.of('minecraft:dark_oak_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Dark Oak Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:dark_oak_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Dark Oak Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:dark_oak_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Dark Oak Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:dark_prismarine')]), Text.black('Created in Chemical Reactor using 2x Prismarine, Black Dye'));
  event.addItem(Ingredient.of([Item.of('minecraft:diamond', 2), Item.of('techreborn:diamond_small_dust', 3)]), Text.black('Created in Industrial Grinder using Diamond Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:diamond', 3), Item.of('techreborn:dark_ashes_dust', 16)]), Text.black('Created in Implosion Compressor using 4x Diamond Dusts, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:diamond', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Diamond Dusts, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:diamond'), Item.of('techreborn:diamond_small_dust', 6), Item.of('techreborn:coal_dust')]), Text.black('Created in Industrial Grinder using Diamond Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:diamond')]), Text.black('Created in Grinder using Diamond Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:dirt', 8), Item.of('techreborn:saltpeter_dust', 4), Item.of('techreborn:coal_dust'), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:oil' })]), Text.black('Created in Centrifuge using 16x Soul Soil, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:dune_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Sandstone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:elytra', 1).withNBT({ 'Damage': 0 })]), Text.black('Created in Assembling Machine using 16x Phantom Membrane, 3x End Rod'));
  event.addItem(Ingredient.of([Item.of('minecraft:emerald', 2), Item.of('techreborn:emerald_small_dust', 3)]), Text.black('Created in Industrial Grinder using Emerald Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:emerald', 3), Item.of('techreborn:dark_ashes_dust', 12)]), Text.black('Created in Implosion Compressor using 4x Emerald Dust, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:emerald', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Emerald Dust, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:emerald'), Item.of('techreborn:emerald_small_dust', 6)]), Text.black('Created in Industrial Grinder using Emerald Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:emerald')]), Text.black('Created in Grinder using Emerald Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:enchanted_golden_apple')]), Text.black('Created in Chemical Reactor using 8x Gold Block, Apple'));
  event.addItem(Ingredient.of([Item.of('minecraft:ender_eye', 2)]), Text.black('Created in Chemical Reactor using Blaze Powder, Ender Pearl'));
  event.addItem(Ingredient.of([Item.of('minecraft:explorer_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Map'));
  event.addItem(Ingredient.of([Item.of('minecraft:eye_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x End Stone Bricks, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:flint')]), Text.black('Created in Extractor using Gravel'));
  event.addItem(Ingredient.of([Item.of('minecraft:friend_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Emerald'));
  event.addItem(Ingredient.of([Item.of('minecraft:glass_bottle')]), Text.black('Created in Extractor using Experience Bottle'));
  event.addItem(Ingredient.of([Item.of('minecraft:glass_bottle')]), Text.black('Created in Extractor using Honey Bottle'));
  event.addItem(Ingredient.of([Item.of('minecraft:glass_bottle')]), Text.black('Created in Extractor using Lingering Potion'));
  event.addItem(Ingredient.of([Item.of('minecraft:glass_bottle')]), Text.black('Created in Extractor using Potion'));
  event.addItem(Ingredient.of([Item.of('minecraft:glass_bottle')]), Text.black('Created in Extractor using Splash Potion'));
  event.addItem(Ingredient.of([Item.of('minecraft:glistering_melon_slice')]), Text.black('Created in Chemical Reactor using 8x Gold Nugget, Melon Slice'));
  event.addItem(Ingredient.of([Item.of('minecraft:glow_ink_sac', 3)]), Text.black('Created in Chemical Reactor using 3x Ink Sac, 2x Prismarine Crystals'));
  event.addItem(Ingredient.of([Item.of('minecraft:glowstone_dust', 4)]), Text.black('Created in Grinder using Glowstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:glowstone')]), Text.black('Created in Chemical Reactor using 6x Glowstone Small Dusts, Sea Lantern'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 2), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Boots, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Helmet, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Horse Armor, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Leggings, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Chestplate, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 6), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using Golden Apple, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot', 64), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using Enchanted Golden Apple, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Axe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Pickaxe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Shovel, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Hoe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Golden Sword, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 6), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 8x Glistering Melon Slice, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 6), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using Golden Carrot, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget', 9), Item.of('techreborn:silver_nugget', 9)]), Text.black('Created in Centrifuge using 2x Electrum Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:gold_nugget'), Item.of('techreborn:nickel_nugget')]), Text.black('Created in Centrifuge using Raw Copper'));
  event.addItem(Ingredient.of([Item.of('minecraft:golden_apple')]), Text.black('Created in Chemical Reactor using 6x Gold Ingot, Apple'));
  event.addItem(Ingredient.of([Item.of('minecraft:golden_carrot')]), Text.black('Created in Chemical Reactor using 8x Gold Nugget, Carrot'));
  event.addItem(Ingredient.of([Item.of('minecraft:gravel', 8), Item.of('minecraft:flint'), Item.of('minecraft:sand', 2)]), Text.black('Created in Centrifuge using 16x Coarse Dirt'));
  event.addItem(Ingredient.of([Item.of('minecraft:gravel')]), Text.black('Created in Grinder using Gravel Material'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_bed')]), Text.black('Created in Assembling Machine using 2x Gray Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using Black Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using Black Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x Black Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Black Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_carpet', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_carpet', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_carpet', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Black Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Black Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_concrete_powder')]), Text.black('Created in Grinder using Gray Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye', 5)]), Text.black('Created in Extractor using Dead Brain Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye', 5)]), Text.black('Created in Extractor using Dead Bubble Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye', 5)]), Text.black('Created in Extractor using Dead Fire Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye', 5)]), Text.black('Created in Extractor using Dead Horn Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye', 5)]), Text.black('Created in Extractor using Dead Tube Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Brain Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Brain Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Bubble Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Bubble Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Fire Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Fire Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Horn Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Horn Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Tube Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_dye')]), Text.black('Created in Extractor using Dead Tube Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Black Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Black Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x Black Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Black Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Black Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Black Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x Black Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Black Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Black Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Black Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Black Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_wool', 4)]), Text.black('Created in Chemical Reactor using Black Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_wool', 4)]), Text.black('Created in Chemical Reactor using Gray Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_wool', 4)]), Text.black('Created in Chemical Reactor using Gray Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:gray_wool', 4)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 4x Black Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_bed')]), Text.black('Created in Assembling Machine using 2x Green Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Yellow Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x Lime Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Green Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Green Dye, 2x Lime Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Lime Dye, 2x Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_candle', 2)]), Text.black('Created in Chemical Reactor using Yellow Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Yellow Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Lime Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Lime Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_carpet', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Yellow Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Lime Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Lime Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_concrete_powder')]), Text.black('Created in Grinder using Green Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_dye')]), Text.black('Created in Extractor using 3x Verdant Froglight'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_dye')]), Text.black('Created in Extractor using Plantball'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Yellow Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x Lime Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Green Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Green Dye, 16x Lime Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Lime Dye, 16x Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Yellow Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Yellow Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x Lime Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Green Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Green Dye, 12x Lime Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Lime Dye, 12x Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Yellow Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Yellow Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Lime Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Lime Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_terracotta', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Yellow Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Gray Dye, 4x Lime Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Green Dye, 4x Lime Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Green Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Lime Dye, 4x Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:green_wool', 4)]), Text.black('Created in Chemical Reactor using Yellow Dye, 4x Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:gunpowder', 2)]), Text.black('Created in Extractor using Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:hanging_roots')]), Text.black('Created in Extractor using Mangrove Roots'));
  event.addItem(Ingredient.of([Item.of('minecraft:heart_of_the_sea')]), Text.black('Created in Extractor using Conduit'));
  event.addItem(Ingredient.of([Item.of('minecraft:heart_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Heart Of The Sea'));
  event.addItem(Ingredient.of([Item.of('minecraft:heartbreak_pottery_sherd')]), Text.black('Created in Grinder using Heart Pottery Sherd'));
  event.addItem(Ingredient.of([Item.of('minecraft:host_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Terracotta, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:howl_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Bone'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 2), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Boots, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using 12x Rail, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Helmet, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Horse Armor, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Leggings, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Chestplate, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Axe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Pickaxe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_ingot')]), Text.black('Created in Blast Furnace using 5x Iron Bars'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_nugget', 3), Item.of('minecraft:gold_nugget', 3), Item.of('techreborn:copper_nugget', 3)]), Text.black('Created in Centrifuge using 3x Nickel Dust'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_nugget', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Shovel, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Hoe, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:iron_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Iron Sword, Sand'));
  event.addItem(Ingredient.of([Item.of('minecraft:jungle_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Jungle Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:jungle_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Jungle Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:jungle_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Jungle Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:lantern', 10)]), Text.black('Created in Assembling Machine using 10x Torch, 8x Iron Ingot'));
  event.addItem(Ingredient.of([Item.of('minecraft:lapis_lazuli', 10)]), Text.black('Created in Grinder using Lapis Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:lapis_lazuli', 12), Item.of('techreborn:lazurite_dust', 3)]), Text.black('Created in Industrial Grinder using Lapis Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:leather', 2)]), Text.black('Created in Chemical Reactor using 3x Rotten Flesh, Ashes Dust'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_bed')]), Text.black('Created in Assembling Machine using 2x Light Blue Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Cyan Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x Cyan Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Cyan Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Cyan Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_concrete_powder')]), Text.black('Created in Grinder using Light Blue Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_dye', 2)]), Text.black('Created in Extractor using Blue Orchid'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Cyan Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x Cyan Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Cyan Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x Cyan Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Cyan Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Cyan Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 4x Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_blue_wool', 4)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 4x Cyan Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_bed')]), Text.black('Created in Assembling Machine using 2x Light Gray Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_concrete_powder')]), Text.black('Created in Grinder using Light Gray Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_dye', 2)]), Text.black('Created in Extractor using Azure Bluet'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_dye', 2)]), Text.black('Created in Extractor using Oxeye Daisy'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_dye', 2)]), Text.black('Created in Extractor using White Tulip'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:light_gray_wool', 4)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_bed')]), Text.black('Created in Assembling Machine using 2x Lime Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Cyan Dye, 2x Yellow Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Green Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 2x Yellow Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Lime Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Green Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Yellow Dye, 2x Cyan Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_candle', 2)]), Text.black('Created in Chemical Reactor using Yellow Dye, 2x Light Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_carpet', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Yellow Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Yellow Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_carpet', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_carpet', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Cyan Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_carpet', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Light Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Yellow Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Yellow Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Cyan Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Light Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_concrete_powder')]), Text.black('Created in Grinder using Lime Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Cyan Dye, 16x Yellow Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Green Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 16x Yellow Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Lime Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Green Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Yellow Dye, 16x Cyan Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Yellow Dye, 16x Light Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Cyan Dye, 12x Yellow Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Green Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 12x Yellow Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Lime Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Green Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Yellow Dye, 12x Cyan Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Yellow Dye, 12x Light Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Cyan Dye, 8x Yellow Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Green Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 8x Yellow Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Lime Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Green Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Cyan Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_terracotta', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Light Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_wool', 4)]), Text.black('Created in Chemical Reactor using Cyan Dye, 4x Yellow Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_wool', 4)]), Text.black('Created in Chemical Reactor using Light Blue Dye, 4x Yellow Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_wool', 4)]), Text.black('Created in Chemical Reactor using Lime Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_wool', 4)]), Text.black('Created in Chemical Reactor using Yellow Dye, 4x Cyan Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:lime_wool', 4)]), Text.black('Created in Chemical Reactor using Yellow Dye, 4x Light Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_bed')]), Text.black('Created in Assembling Machine using 2x Magenta Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_candle', 2)]), Text.black('Created in Chemical Reactor using Gray Dye, 2x Pink Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_candle', 2)]), Text.black('Created in Chemical Reactor using Magenta Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_candle', 2)]), Text.black('Created in Chemical Reactor using Pink Dye, 2x Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_candle', 2)]), Text.black('Created in Chemical Reactor using Pink Dye, 2x Purple Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_candle', 2)]), Text.black('Created in Chemical Reactor using Purple Dye, 2x Pink Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_carpet', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Pink Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_carpet', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_carpet', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_carpet', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Purple Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_carpet', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Pink Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Pink Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Purple Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Pink Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_concrete_powder')]), Text.black('Created in Grinder using Magenta Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_dye', 2)]), Text.black('Created in Extractor using Allium'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_dye', 4)]), Text.black('Created in Extractor using Lilac'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Gray Dye, 16x Pink Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Magenta Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Pink Dye, 16x Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Pink Dye, 16x Purple Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Purple Dye, 16x Pink Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Gray Dye, 12x Pink Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Magenta Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Pink Dye, 12x Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Pink Dye, 12x Purple Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Purple Dye, 12x Pink Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_terracotta', 8)]), Text.black('Created in Chemical Reactor using Gray Dye, 8x Pink Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_terracotta', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_terracotta', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_terracotta', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Purple Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_terracotta', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Pink Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_wool', 4)]), Text.black('Created in Chemical Reactor using Gray Dye, 4x Pink Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_wool', 4)]), Text.black('Created in Chemical Reactor using Magenta Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_wool', 4)]), Text.black('Created in Chemical Reactor using Pink Dye, 4x Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_wool', 4)]), Text.black('Created in Chemical Reactor using Pink Dye, 4x Purple Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magenta_wool', 4)]), Text.black('Created in Chemical Reactor using Purple Dye, 4x Pink Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:magma_cream', 2)]), Text.black('Created in Chemical Reactor using Blaze Powder, Slime Ball'));
  event.addItem(Ingredient.of([Item.of('minecraft:mangrove_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Mangrove Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:mangrove_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Mangrove Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:mangrove_roots')]), Text.black('Created in Extractor using Muddy Mangrove Roots'));
  event.addItem(Ingredient.of([Item.of('minecraft:mangrove_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Mangrove Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:miner_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Iron Pickaxe'));
  event.addItem(Ingredient.of([Item.of('minecraft:mourner_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Recovery Compass'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_ingot', 3)]), Text.black('Created in Alloy Smelter using 10x Gold Ingot, 10x Netherite Scrap'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_ingot'), Item.of('techreborn:dark_ashes_dust', 12)]), Text.black('Created in Implosion Compressor using 9x Netherite Nuggets, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_ingot'), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 9x Netherite Nuggets, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_scrap', 2), Item.of('minecraft:gold_nugget', 5)]), Text.black('Created in Industrial Grinder using Ancient Debris'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_scrap', 2)]), Text.black('Created in Grinder using Ancient Debris'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_scrap', 3), Item.of('minecraft:gold_nugget', 3)]), Text.black('Created in Industrial Grinder using Ancient Debris'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherite_upgrade_smithing_template')]), Text.black('Created in Assembling Machine using 2x Netherrack, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherrack', 6), Item.of('minecraft:crimson_fungus', 2)]), Text.black('Created in Centrifuge using 8x Crimson Nylium'));
  event.addItem(Ingredient.of([Item.of('minecraft:netherrack', 6), Item.of('minecraft:warped_fungus', 2)]), Text.black('Created in Centrifuge using 8x Warped Nylium'));
  event.addItem(Ingredient.of([Item.of('minecraft:oak_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Oak Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:oak_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Oak Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:oak_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Oak Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_bed')]), Text.black('Created in Assembling Machine using 2x Orange Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_candle', 2)]), Text.black('Created in Chemical Reactor using Orange Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_candle', 2)]), Text.black('Created in Chemical Reactor using Orange Dye, 2x Pink Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_candle', 2)]), Text.black('Created in Chemical Reactor using Orange Dye, 2x Yellow Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_carpet', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Pink Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_carpet', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_carpet', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Yellow Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Pink Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Yellow Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_concrete_powder')]), Text.black('Created in Grinder using Orange Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_dye', 2)]), Text.black('Created in Extractor using Orange Tulip'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_dye', 2)]), Text.black('Created in Extractor using Torchflower'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_dye')]), Text.black('Created in Extractor using 3x Carrot'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_dye')]), Text.black('Created in Extractor using 4x Glow Berries'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Orange Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Orange Dye, 16x Pink Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Orange Dye, 16x Yellow Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Orange Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Orange Dye, 12x Pink Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Orange Dye, 12x Yellow Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_terracotta', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Pink Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_terracotta', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_terracotta', 8)]), Text.black('Created in Chemical Reactor using Orange Dye, 8x Yellow Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_wool', 4)]), Text.black('Created in Chemical Reactor using Orange Dye, 4x Pink Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_wool', 4)]), Text.black('Created in Chemical Reactor using Orange Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:orange_wool', 4)]), Text.black('Created in Chemical Reactor using Orange Dye, 4x Yellow Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:packed_ice')]), Text.black('Created in Vacuum Freezer using 2x Ice'));
  event.addItem(Ingredient.of([Item.of('minecraft:paper', 2)]), Text.black('Created in Extractor using Book'));
  event.addItem(Ingredient.of([Item.of('minecraft:paper', 2)]), Text.black('Created in Extractor using Enchanted Book'));
  event.addItem(Ingredient.of([Item.of('minecraft:paper', 2)]), Text.black('Created in Extractor using Manual'));
  event.addItem(Ingredient.of([Item.of('minecraft:paper', 2)]), Text.black('Created in Extractor using Writable Book'));
  event.addItem(Ingredient.of([Item.of('minecraft:paper', 2)]), Text.black('Created in Extractor using Written Book'));
  event.addItem(Ingredient.of([Item.of('minecraft:phantom_membrane', 2)]), Text.black('Created in Extractor using Elytra'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_bed')]), Text.black('Created in Assembling Machine using 2x Pink Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 2x Magenta Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using Magenta Dye, 2x Light Gray Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using Magenta Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using Pink Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x White Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Magenta Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Red Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_carpet', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Magenta Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_carpet', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Light Gray Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_carpet', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Magenta Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Light Gray Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_concrete_powder')]), Text.black('Created in Grinder using Pink Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye', 2)]), Text.black('Created in Extractor using Pink Petals'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye', 2)]), Text.black('Created in Extractor using Pink Tulip'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye', 4)]), Text.black('Created in Extractor using Peony'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye', 5)]), Text.black('Created in Extractor using Brain Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye')]), Text.black('Created in Extractor using Brain Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_dye')]), Text.black('Created in Extractor using Brain Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_petals', 4)]), Text.black('Created in Extractor using Cherry Leaves'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 16x Magenta Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Magenta Dye, 16x Light Gray Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Magenta Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Pink Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x White Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Magenta Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Red Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 12x Magenta Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Magenta Dye, 12x Light Gray Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Magenta Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Pink Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x White Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Magenta Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Red Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 8x Magenta Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Light Gray Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using Pink Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x White Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Magenta Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Red Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_wool', 4)]), Text.black('Created in Chemical Reactor using Light Gray Dye, 4x Magenta Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_wool', 4)]), Text.black('Created in Chemical Reactor using Magenta Dye, 4x Light Gray Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:pink_wool', 4)]), Text.black('Created in Chemical Reactor using Pink Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:plenty_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Chest'));
  event.addItem(Ingredient.of([Item.of('minecraft:pointed_dripstone')]), Text.black('Created in Chemical Reactor using 3x Calcite Small Dusts, Slime Ball'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_bricks')]), Text.black('Created in Compressor using 2x Prismarine'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_crystals', 2)]), Text.black('Created in Grinder using Froglights'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_crystals', 3), Item.of('minecraft:slime_ball')]), Text.black('Created in Industrial Grinder using Froglights'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_crystals', 4)]), Text.black('Created in Grinder using Sea Lantern'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_shard', 3)]), Text.black('Created in Grinder using Prismarine'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_shard', 7)]), Text.black('Created in Grinder using Prismarine Bricks'));
  event.addItem(Ingredient.of([Item.of('minecraft:prismarine_shard')]), Text.black('Created in Compressor using Prismarine Crystals'));
  event.addItem(Ingredient.of([Item.of('minecraft:prize_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Diamond'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_bed')]), Text.black('Created in Assembling Machine using 2x Purple Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Magenta Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Blue Dye, 2x Red Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Magenta Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Purple Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Purple Dye, 2x Magenta Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Blue Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Magenta Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Red Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Magenta Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Blue Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Magenta Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Red Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Magenta Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Blue Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_concrete_powder')]), Text.black('Created in Grinder using Purple Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_dye', 4)]), Text.black('Created in Extractor using Shulker Shell'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_dye', 5)]), Text.black('Created in Extractor using Bubble Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_dye')]), Text.black('Created in Extractor using 3x Pearlescent Froglight'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_dye')]), Text.black('Created in Extractor using Bubble Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_dye')]), Text.black('Created in Extractor using Bubble Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Magenta Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Blue Dye, 16x Red Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Magenta Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Purple Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Purple Dye, 16x Magenta Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Blue Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Magenta Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Blue Dye, 12x Red Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Magenta Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Purple Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Purple Dye, 12x Magenta Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Blue Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Magenta Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Blue Dye, 8x Red Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Magenta Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Magenta Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Purple Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Blue Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Magenta Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Blue Dye, 4x Red Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Magenta Dye, 4x Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Purple Dye, 4x Magenta Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Purple Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:purple_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x Blue Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:quartz', 2), Item.of('techreborn:sulfur_small_dust', 2)]), Text.black('Created in Industrial Grinder using Nether Quartz Ore'));
  event.addItem(Ingredient.of([Item.of('minecraft:quartz', 2)]), Text.black('Created in Grinder using Nether Quartz Ore'));
  event.addItem(Ingredient.of([Item.of('minecraft:raiser_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Brown Terracotta, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_copper', 2), Item.of('minecraft:gold_nugget', 3)]), Text.black('Created in Industrial Grinder using Copper Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_copper', 2), Item.of('minecraft:raw_gold'), Item.of('techreborn:nickel_dust')]), Text.black('Created in Industrial Grinder using Copper Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_copper', 2)]), Text.black('Created in Grinder using Copper Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_copper', 3), Item.of('minecraft:gold_nugget', 3)]), Text.black('Created in Industrial Grinder using Copper Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_gold', 2), Item.of('minecraft:raw_copper'), Item.of('techreborn:nickel_dust')]), Text.black('Created in Industrial Grinder using Gold Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_gold', 2), Item.of('techreborn:copper_nugget', 3), Item.of('techreborn:nickel_nugget')]), Text.black('Created in Industrial Grinder using Gold Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_gold', 2)]), Text.black('Created in Grinder using Gold Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_gold', 3), Item.of('techreborn:copper_nugget', 3), Item.of('techreborn:nickel_nugget')]), Text.black('Created in Industrial Grinder using Gold Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_iron', 2)]), Text.black('Created in Grinder using Iron Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_iron', 3), Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Almandine Dust, 9x Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_iron', 3), Item.of('techreborn:tin_nugget', 3), Item.of('techreborn:nickel_nugget', 3)]), Text.black('Created in Industrial Grinder using Iron Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:raw_iron'), Item.of('techreborn:sulfur_dust', 2)]), Text.black('Created in Industrial Electrolyzer using 3x Pyrite Dust'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_bed')]), Text.black('Created in Assembling Machine using 2x Red Wool, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Magenta Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Orange Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_candle', 2)]), Text.black('Created in Chemical Reactor using Red Dye, 2x Pink Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Magenta Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Orange Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Pink Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_carpet', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Magenta Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Orange Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Pink Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_concrete_powder')]), Text.black('Created in Grinder using Red Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye', 2)]), Text.black('Created in Extractor using Beetroot'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye', 2)]), Text.black('Created in Extractor using Poppy'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye', 2)]), Text.black('Created in Extractor using Red Tulip'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye', 4)]), Text.black('Created in Extractor using Rose Bush'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye', 5)]), Text.black('Created in Extractor using Fire Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye')]), Text.black('Created in Extractor using 4x Sweet Berries'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye')]), Text.black('Created in Extractor using Fire Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_dye')]), Text.black('Created in Extractor using Fire Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 2)]), Text.black('Created in Grinder using Cut Red Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 2)]), Text.black('Created in Grinder using Red Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 2)]), Text.black('Created in Grinder using Smooth Red Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 3)]), Text.black('Created in Grinder using Red Sandstone Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 3)]), Text.black('Created in Grinder using Red Sandstone Wall'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 3)]), Text.black('Created in Grinder using Smooth Red Sandstone Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 4)]), Text.black('Created in Grinder using Chiseled Red Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 4)]), Text.black('Created in Grinder using Cut Red Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 4)]), Text.black('Created in Grinder using Red Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_sand', 4)]), Text.black('Created in Grinder using Smooth Red Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Magenta Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Orange Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Red Dye, 16x Pink Stained Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Magenta Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Orange Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Red Dye, 12x Pink Stained Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Magenta Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Orange Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Pink Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_terracotta', 8)]), Text.black('Created in Chemical Reactor using Red Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x Magenta Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x Orange Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x Pink Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:red_wool', 4)]), Text.black('Created in Chemical Reactor using Red Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:redstone', 10), Item.of('techreborn:glowstone_small_dust', 2)]), Text.black('Created in Industrial Grinder using Redstone Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:redstone', 8), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:sulfur' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium' })]), Text.black('Created in Centrifuge using 16x Glowstone Dust, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:redstone', 8)]), Text.black('Created in Grinder using Redstone Ores'));
  event.addItem(Ingredient.of([Item.of('minecraft:redstone'), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:sulfur' }), Item.of('techreborn:coal_dust'), Item.of('minecraft:gold_nugget')]), Text.black('Created in Centrifuge using 16x Netherrack Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:rib_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Nether Bricks, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 10), Item.of('techreborn:saltpeter_dust', 4), Item.of('techreborn:coal_dust'), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:oil' })]), Text.black('Created in Centrifuge using 16x Soul Sand, Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 2)]), Text.black('Created in Grinder using Cut Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 2)]), Text.black('Created in Grinder using Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 2)]), Text.black('Created in Grinder using Smooth Sandstone Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 3)]), Text.black('Created in Grinder using Sandstone Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 3)]), Text.black('Created in Grinder using Sandstone Wall'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 3)]), Text.black('Created in Grinder using Smooth Sandstone Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 4), Item.of('minecraft:clay_ball'), Item.of('minecraft:brown_mushroom', 2), Item.of('minecraft:red_mushroom', 2)]), Text.black('Created in Centrifuge using 8x Mycelium'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 4)]), Text.black('Created in Grinder using Chiseled Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 4)]), Text.black('Created in Grinder using Cut Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 4)]), Text.black('Created in Grinder using Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 4)]), Text.black('Created in Grinder using Smooth Sandstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 8), Item.of('minecraft:clay_ball', 2), Item.of('minecraft:gravel', 2), Item.of('techreborn:plantball')]), Text.black('Created in Centrifuge using 16x Podzol'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 8), Item.of('minecraft:clay_ball'), Item.of('minecraft:gravel', 2), Item.of('minecraft:hanging_roots', 7)]), Text.black('Created in Centrifuge using 16x Rooted Dirt'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 8), Item.of('minecraft:clay_ball'), Item.of('minecraft:gravel', 2), Item.of('techreborn:plantball', 2)]), Text.black('Created in Centrifuge using 16x Grass Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand', 8), Item.of('minecraft:clay_ball'), Item.of('minecraft:gravel', 2)]), Text.black('Created in Centrifuge using 16x Dirt'));
  event.addItem(Ingredient.of([Item.of('minecraft:sand')]), Text.black('Created in Grinder using Gravel'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk_catalyst'), Item.of('techreborn:dark_ashes_dust', 4)]), Text.black('Created in Implosion Compressor using 64x Sculk, 8x Tnt'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk_catalyst'), Item.of('techreborn:ender_eye_small_dust', 2)]), Text.black('Created in Implosion Compressor using 64x Sculk, 2x End Crystal'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk_sensor', 2)]), Text.black('Created in Chemical Reactor using 16x Redstone, Sculk'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk_shrieker')]), Text.black('Created in Chemical Reactor using 3x Sculk Catalyst, Nether Star'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk')]), Text.black('Created in Compressor using 16x Sculk Vein'));
  event.addItem(Ingredient.of([Item.of('minecraft:sculk')]), Text.black('Created in Extractor using Sculk Catalyst'));
  event.addItem(Ingredient.of([Item.of('minecraft:sea_lantern')]), Text.black('Created in Chemical Reactor using 6x Prismarine Crystals, Glowstone'));
  event.addItem(Ingredient.of([Item.of('minecraft:sentry_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Smooth Stone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:shaper_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Gray Terracotta, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:sheaf_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Wheat'));
  event.addItem(Ingredient.of([Item.of('minecraft:shelter_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Iron Door'));
  event.addItem(Ingredient.of([Item.of('minecraft:shroomlight')]), Text.black('Created in Chemical Reactor using 4x Glowstone Dust, Brown Mushroom Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:shroomlight')]), Text.black('Created in Chemical Reactor using 4x Glowstone Dust, Nether Wart Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:shroomlight')]), Text.black('Created in Chemical Reactor using 4x Glowstone Dust, Red Mushroom Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:shroomlight')]), Text.black('Created in Chemical Reactor using 4x Glowstone Dust, Warped Wart Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:silence_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Sculk Shrieker, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:skull_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Skeleton Skull'));
  event.addItem(Ingredient.of([Item.of('minecraft:slime_ball')]), Text.black('Created in Extractor using Sticky Piston'));
  event.addItem(Ingredient.of([Item.of('minecraft:snort_pottery_sherd')]), Text.black('Created in Blast Furnace using 4x Clay Ball, Scute'));
  event.addItem(Ingredient.of([Item.of('minecraft:snout_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Chiseled Polished Blackstone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:soul_lantern', 10)]), Text.black('Created in Assembling Machine using 10x Soul Torch, 8x Iron Ingot'));
  event.addItem(Ingredient.of([Item.of('minecraft:soul_sand', 8)]), Text.black('Created in Blast Furnace using 8x Red Sand, Carbon in a Cell'));
  event.addItem(Ingredient.of([Item.of('minecraft:spire_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Purpur Block, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:spruce_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Spruce Logs'));
  event.addItem(Ingredient.of([Item.of('minecraft:spruce_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Spruce Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:spruce_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Spruce Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:stick', 2)]), Text.black('Created in Extractor using Dead Bush'));
  event.addItem(Ingredient.of([Item.of('minecraft:stick', 3)]), Text.black('Created in Extractor using Armor Stand'));
  event.addItem(Ingredient.of([Item.of('minecraft:string', 3)]), Text.black('Created in Extractor using Beds'));
  event.addItem(Ingredient.of([Item.of('minecraft:string', 4)]), Text.black('Created in Grinder using Wool'));
  event.addItem(Ingredient.of([Item.of('minecraft:string', 5)]), Text.black('Created in Extractor using Banners'));
  event.addItem(Ingredient.of([Item.of('minecraft:string')]), Text.black('Created in Extractor using Bow'));
  event.addItem(Ingredient.of([Item.of('minecraft:string')]), Text.black('Created in Extractor using Crossbow'));
  event.addItem(Ingredient.of([Item.of('minecraft:string')]), Text.black('Created in Extractor using Painting Tool'));
  event.addItem(Ingredient.of([Item.of('minecraft:stripped_warped_hyphae')]), Text.black('Created in Chemical Reactor using Stripped Crimson Hyphae, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:stripped_warped_stem')]), Text.black('Created in Chemical Reactor using Stripped Crimson Stem, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:sugar', 3)]), Text.black('Created in Extractor using 2x Sugar Cane'));
  event.addItem(Ingredient.of([Item.of('minecraft:tide_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Prismarine Bricks, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:verdant_froglight')]), Text.black('Created in Chemical Reactor using Blue Dye, Ochre Froglight'));
  event.addItem(Ingredient.of([Item.of('minecraft:vex_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Stone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:ward_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Deepslate, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_button', 2)]), Text.black('Created in Chemical Reactor using 2x Crimson Button, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_door', 2)]), Text.black('Created in Chemical Reactor using 2x Crimson Door, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_fence_gate', 2)]), Text.black('Created in Chemical Reactor using 2x Crimson Fence Gate, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_fence', 3)]), Text.black('Created in Chemical Reactor using 3x Crimson Fence, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_hyphae')]), Text.black('Created in Chemical Reactor using Crimson Hyphae, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_planks', 2)]), Text.black('Created in Chemical Reactor using 2x Crimson Planks, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Warped Stems'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Warped Slab'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_pressure_plate')]), Text.black('Created in Chemical Reactor using Crimson Pressure Plate, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_sign')]), Text.black('Created in Chemical Reactor using Crimson Sign, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_slab', 4)]), Text.black('Created in Chemical Reactor using 4x Crimson Slab, Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Warped Stairs'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_stairs', 4)]), Text.black('Created in Chemical Reactor using 4x Crimson Stairs, 3x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_stem')]), Text.black('Created in Chemical Reactor using Crimson Stem, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_trapdoor', 2)]), Text.black('Created in Chemical Reactor using 2x Crimson Trapdoor, 3x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:warped_wart_block')]), Text.black('Created in Chemical Reactor using Nether Wart Block, 2x Ender Pearl Dusts'));
  event.addItem(Ingredient.of([Item.of('minecraft:wayfinder_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Light Gray Terracotta, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:wheat_seeds')]), Text.black('Created in Extractor using Fern'));
  event.addItem(Ingredient.of([Item.of('minecraft:wheat_seeds')]), Text.black('Created in Extractor using Grass'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_bed')]), Text.black('Created in Assembling Machine using 2x White Dye, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_candle', 2)]), Text.black('Created in Chemical Reactor using White Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_concrete_powder')]), Text.black('Created in Grinder using White Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_dye', 2)]), Text.black('Created in Extractor using Bone Meal'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_dye', 2)]), Text.black('Created in Extractor using Lily Of The Valley'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using White Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_stained_glass', 12)]), Text.black('Created in Chemical Reactor using White Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:white_terracotta', 8)]), Text.black('Created in Chemical Reactor using White Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:wild_armor_trim_smithing_template')]), Text.black('Created in Assembling Machine using 2x Mossy Cobblestone, Template Template'));
  event.addItem(Ingredient.of([Item.of('minecraft:wither_skeleton_skull')]), Text.black('Created in Chemical Reactor using 8x Wither Rose, Skeleton Skull'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_bed')]), Text.black('Created in Assembling Machine using 2x Yellow Dye, Planks'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_candle', 2)]), Text.black('Created in Chemical Reactor using Yellow Dye, 2x Candle'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_carpet', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x White Carpet'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_concrete_powder', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x White Concrete Powder'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_concrete_powder')]), Text.black('Created in Grinder using Yellow Concrete'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye', 2)]), Text.black('Created in Extractor using Dandelion'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye', 4)]), Text.black('Created in Extractor using Sunflower'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye', 5)]), Text.black('Created in Extractor using Horn Coral Block'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye')]), Text.black('Created in Extractor using 3x Ochre Froglight'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye')]), Text.black('Created in Extractor using Horn Coral Fan'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_dye')]), Text.black('Created in Extractor using Horn Coral'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_stained_glass_pane', 16)]), Text.black('Created in Chemical Reactor using Yellow Dye, 16x Glass Pane'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_stained_glass', 12)]), Text.black('Created in Chemical Reactor using Yellow Dye, 12x Glass'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_terracotta', 8)]), Text.black('Created in Chemical Reactor using Yellow Dye, 8x Terracotta'));
  event.addItem(Ingredient.of([Item.of('minecraft:yellow_wool', 4)]), Text.black('Created in Chemical Reactor using Yellow Dye, 4x White Wool'));
  event.addItem(Ingredient.of([Item.of('techreborn:advanced_alloy_plate', 9)]), Text.black('Created in Compressor using Advanced Alloy Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:advanced_alloy_plate')]), Text.black('Created in Compressor using Advanced Alloy Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:advanced_circuit')]), Text.black('Created in Assembling Machine using Silicon Plates, 2x Electrum Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:beryllium' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 7).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 29x Emerald Dust, 16x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 8x Sapphire Dusts, 3x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:chrome_dust'), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 3x Ruby Dusts, 3x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:manganese_dust', 3), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Spessartine Dust, 9x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 3), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:calcium' }), Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:sodium' })]), Text.black('Created in Industrial Electrolyzer using 29x Lazurite Dust, 10x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 8), Item.of('techreborn:titanium_small_dust', 2), Item.of('techreborn:cell', 5).withNBT({ 'fluid': 'techreborn:hydrogen' }), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 12x Bauxite Dusts, 8x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust', 9)]), Text.black('Created in Grinder using Aluminum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_dust')]), Text.black('Created in Grinder using Aluminum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_ingot')]), Text.black('Created in Blast Furnace using Aluminum Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_plate', 9)]), Text.black('Created in Compressor using Aluminum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:aluminum_plate')]), Text.black('Created in Compressor using Aluminum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:amethyst_dust', 2)]), Text.black('Created in Grinder using Amethyst Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:andesite_dust', 2)]), Text.black('Created in Grinder using Andesite'));
  event.addItem(Ingredient.of([Item.of('techreborn:andradite_dust', 5), Item.of('techreborn:grossular_dust', 8), Item.of('techreborn:uvarovite_dust', 3)]), Text.black('Created in Centrifuge using 16x Yellow Garnet Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:ashes_dust')]), Text.black('Created in Centrifuge using 2x Dark Ashes Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:basalt_dust')]), Text.black('Created in Grinder using Basalt'));
  event.addItem(Ingredient.of([Item.of('techreborn:bauxite_dust', 2)]), Text.black('Created in Grinder using Bauxite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:bauxite_dust', 4), Item.of('techreborn:aluminum_dust')]), Text.black('Created in Industrial Grinder using Bauxite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:brass_dust', 9)]), Text.black('Created in Grinder using Brass Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:brass_dust')]), Text.black('Created in Grinder using Brass Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:brass_ingot', 4)]), Text.black('Created in Alloy Smelter using 3x Copper Ingot, Zinc Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:brass_plate', 9)]), Text.black('Created in Compressor using Brass Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:brass_plate')]), Text.black('Created in Compressor using Brass Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_dust', 9)]), Text.black('Created in Grinder using Bronze Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_dust')]), Text.black('Created in Grinder using Bronze Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot', 2), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Boots, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Helmet, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Leggings, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot', 4)]), Text.black('Created in Alloy Smelter using 3x Copper Ingot, Tin Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Chestplate, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Axe, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_ingot'), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Pickaxe, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_nugget', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Spade, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Hoe, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_nugget', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Bronze Sword, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_plate', 9)]), Text.black('Created in Compressor using Bronze Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:bronze_plate')]), Text.black('Created in Compressor using Bronze Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:calcite_dust', 2)]), Text.black('Created in Grinder using Conduit'));
  event.addItem(Ingredient.of([Item.of('techreborn:calcite_dust'), Item.of('techreborn:cell')]), Text.black('Created in Centrifuge using Calcium Carbonate in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:calcite_dust')]), Text.black('Created in Grinder using Calcite Dust Material'));
  event.addItem(Ingredient.of([Item.of('techreborn:calcite_small_dust')]), Text.black('Created in Grinder using Calcite Small Dust Material'));
  event.addItem(Ingredient.of([Item.of('techreborn:carbon_plate')]), Text.black('Created in Compressor using Carbon Mesh'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:biofuel' })]), Text.black('Created in Solid Canning Machine using Compressed Plantball, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:calcium' })]), Text.black('Created in Industrial Electrolyzer using 3x Bone Meal, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:carbon_fiber' })]), Text.black('Created in Industrial Electrolyzer using 2x Ashes Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:carbon' })]), Text.black('Created in Centrifuge using 2x Ashes Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:carbon' })]), Text.black('Created in Industrial Electrolyzer using Charcoal Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Compressor using Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:deuterium' }), Item.of('techreborn:cell', 3)]), Text.black('Created in Centrifuge using Hydrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:electrolyzed_water' })]), Text.black('Created in Industrial Electrolyzer using Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium' })]), Text.black('Created in Vacuum Freezer using Heliumplasma in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium3' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium' }), Item.of('techreborn:tungsten_small_dust'), Item.of('minecraft:sand', 12)]), Text.black('Created in Centrifuge using 16x Endstone Dust, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium3' }), Item.of('techreborn:cell', 15)]), Text.black('Created in Centrifuge using Helium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:helium3' })]), Text.black('Created in Fusion Reactor using Tritium in a Cell, Deuterium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:heliumplasma' })]), Text.black('Created in Fusion Reactor using Helium3 in a Cell, Deuterium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:lithium' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:sodium' }), Item.of('techreborn:aluminum_dust', 2)]), Text.black('Created in Industrial Electrolyzer using 8x Clay Dust, 5x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:mercury' }), Item.of('techreborn:sulfur_dust')]), Text.black('Created in Industrial Electrolyzer using 2x Cinnabar Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:dead_brain_coral', 24), Item.of('minecraft:dead_brain_coral_fan', 12), Item.of('minecraft:pink_dye', 16)]), Text.black('Created in Centrifuge using 12x Brain Coral Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:dead_bubble_coral', 24), Item.of('minecraft:dead_bubble_coral_fan', 12), Item.of('minecraft:purple_dye', 16)]), Text.black('Created in Centrifuge using 12x Bubble Coral Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:dead_fire_coral', 24), Item.of('minecraft:dead_fire_coral_fan', 12), Item.of('minecraft:red_dye', 16)]), Text.black('Created in Centrifuge using 12x Fire Coral Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:dead_horn_coral', 24), Item.of('minecraft:dead_horn_coral_fan', 12), Item.of('minecraft:yellow_dye', 16)]), Text.black('Created in Centrifuge using 12x Horn Coral Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:dead_tube_coral', 24), Item.of('minecraft:dead_tube_coral_fan', 12), Item.of('minecraft:blue_dye', 16)]), Text.black('Created in Centrifuge using 12x Tube Coral Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:glowstone_dust', 4)]), Text.black('Created in Centrifuge using 8x Shroomlight, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:orange_dye', 2), Item.of('minecraft:glowstone_dust', 2)]), Text.black('Created in Centrifuge using 32x Glow Berries, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('minecraft:red_dye', 5)]), Text.black('Created in Centrifuge using 32x Sweet Berries, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('techreborn:calcite_dust')]), Text.black('Created in Centrifuge using 16x Egg, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('techreborn:calcite_dust')]), Text.black('Created in Centrifuge using 32x Turtle Egg, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('techreborn:ender_pearl_dust', 2)]), Text.black('Created in Centrifuge using 12x Warped Wart Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 12x Beetroot, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 12x Brown Mushroom Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 12x Nether Wart Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 12x Raw Meat, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 12x Red Mushroom Block, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Carrot, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Cooked Meat, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Mushroom Stew, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Potato, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Pumpkin, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 16x Rotten Flesh, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 24x Baked Potato, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Apple, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Brown Mushroom, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Kelp, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Nether Wart, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Red Mushroom, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 32x Spider Eye, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 64x Bread, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 64x Cookie, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Centrifuge using 64x Melon Slice, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 16x Sand, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 8x Flint Dust, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:sulfur' })]), Text.black('Created in Solid Canning Machine using Sulfur Dust, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:tritium' }), Item.of('techreborn:cell', 3)]), Text.black('Created in Centrifuge using Deuterium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:wolframium' })]), Text.black('Created in Industrial Electrolyzer using Raw Tungsten Ores, Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 16), Item.of('minecraft:copper_ingot', 4), Item.of('techreborn:electrum_ingot'), Item.of('techreborn:tungsten_small_dust')]), Text.black('Created in Centrifuge using Lava in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 16).withNBT({ 'fluid': 'techreborn:diesel' }), Item.of('techreborn:cell', 15).withNBT({ 'fluid': 'techreborn:sulfuric_acid' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:glyceryl' })]), Text.black('Created in Distillation Tower using 16x Cell, Oil in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'minecraft:water' })]), Text.black('Created in Chemical Reactor using Compressed Air in a Cell, Hydrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:calcium_carbonate' })]), Text.black('Created in Chemical Reactor using Carbon in a Cell, Calcium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:calcium' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:carbon' }), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 10x Calcite Dust, 7x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:carbon' }), Item.of('techreborn:cell', 5).withNBT({ 'fluid': 'minecraft:water' })]), Text.black('Created in Industrial Electrolyzer using 32x Sugar, 7x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:carbon' })]), Text.black('Created in Industrial Electrolyzer using Coal Dust, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:glyceryl' })]), Text.black('Created in Chemical Reactor using Nitro Carbon in a Cell, Water in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:hydrogen' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:sulfur' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 5x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitro_carbon' })]), Text.black('Created in Chemical Reactor using Carbon in a Cell, Nitrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitro_diesel' })]), Text.black('Created in Chemical Reactor using Glyceryl in a Cell, Diesel in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitrocoal_fuel' })]), Text.black('Created in Chemical Reactor using Glyceryl in a Cell, Carbon in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitrofuel' })]), Text.black('Created in Chemical Reactor using Oil in a Cell, Nitrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitrogen_dioxide' })]), Text.black('Created in Chemical Reactor using Compressed Air in a Cell, Nitrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:potassium' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:nitrogen' }), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 10x Saltpeter Dust, 7x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Blast Furnace using 2x Quartz Dust, Carbon in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:sodium_persulfate' })]), Text.black('Created in Chemical Reactor using Sodium Sulfide in a Cell, Compressed Air in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:sodium_sulfide' })]), Text.black('Created in Chemical Reactor using Sulfur in a Cell, Sodium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:sulfuric_acid' })]), Text.black('Created in Chemical Reactor using Sulfur in a Cell, Water in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:calcium' }), Item.of('minecraft:raw_iron', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Andradite Dust, 12x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:calcium' }), Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Grossular Dust, 12x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:calcium' }), Item.of('techreborn:chrome_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Uvarovite Dust, 12x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:pyrite_dust', 16), Item.of('techreborn:ruby_dust', 3), Item.of('techreborn:cell', 10).withNBT({ 'fluid': 'techreborn:mercury' })]), Text.black('Created in Centrifuge using 32x Redstone, 13x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:hydrogen' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:carbon' })]), Text.black('Created in Industrial Electrolyzer using Methane in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:hydrogen' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 5x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:sodium' }), Item.of('techreborn:aluminum_dust', 3), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:chlorite' })]), Text.black('Created in Industrial Electrolyzer using 23x Sodalite Dust, 8x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 5).withNBT({ 'fluid': 'techreborn:methane' })]), Text.black('Created in Chemical Reactor using Carbon in a Cell, Hydrogen in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell', 5).withNBT({ 'fluid': 'techreborn:nitrogen' }), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:beryllium' }), Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:potassium' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:chlorite' })]), Text.black('Created in Industrial Electrolyzer using 16x Ender Pearl Dust, 16x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:cell')]), Text.black('Created in Extractor using Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:charcoal_dust')]), Text.black('Created in Grinder using Charcoal'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_dust', 9)]), Text.black('Created in Grinder using Chromium Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_dust')]), Text.black('Created in Grinder using Chromium Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_ingot')]), Text.black('Created in Blast Furnace using 4x Chrome Small Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_ingot')]), Text.black('Created in Blast Furnace using Chrome Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_plate', 9)]), Text.black('Created in Compressor using Chromium Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:chrome_plate')]), Text.black('Created in Compressor using Chromium Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:cinnabar_dust', 2)]), Text.black('Created in Grinder using Cinnabar Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:cinnabar_dust', 5), Item.of('techreborn:redstone_small_dust', 2), Item.of('techreborn:glowstone_small_dust')]), Text.black('Created in Industrial Grinder using Cinnabar Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:clay_dust')]), Text.black('Created in Grinder using Clay Ball'));
  event.addItem(Ingredient.of([Item.of('techreborn:coal_dust', 9)]), Text.black('Created in Grinder using Coal Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:coal_dust')]), Text.black('Created in Grinder using Coal'));
  event.addItem(Ingredient.of([Item.of('techreborn:coal_plate', 9)]), Text.black('Created in Compressor using Coal Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:coal_plate')]), Text.black('Created in Compressor using Coal Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:compressed_plantball')]), Text.black('Created in Compressor using 64x Melon Slice'));
  event.addItem(Ingredient.of([Item.of('techreborn:compressed_plantball')]), Text.black('Created in Compressor using 8x Plantball Material'));
  event.addItem(Ingredient.of([Item.of('techreborn:compressed_plantball')]), Text.black('Created in Compressor using Plantball'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_cable', 6)]), Text.black('Created in Wire Mill using Copper Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_nugget', 27), Item.of('techreborn:tin_nugget', 9)]), Text.black('Created in Centrifuge using 4x Bronze Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_nugget', 27), Item.of('techreborn:zinc_nugget', 9)]), Text.black('Created in Centrifuge using 4x Brass Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_nugget'), Item.of('techreborn:nickel_nugget')]), Text.black('Created in Centrifuge using Raw Gold'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_plate', 9)]), Text.black('Created in Compressor using Copper Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:copper_plate')]), Text.black('Created in Compressor using Copper Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:dark_ashes_dust', 18), Item.of('techreborn:ashes_dust', 12)]), Text.black('Created in Centrifuge using 16x Tuff'));
  event.addItem(Ingredient.of([Item.of('techreborn:dark_ashes_dust'), Item.of('techreborn:sulfur_dust')]), Text.black('Created in Industrial Electrolyzer using 4x Blaze Powder'));
  event.addItem(Ingredient.of([Item.of('techreborn:data_storage_chip')]), Text.black('Created in Assembling Machine using Data Storage Core, Industrial Circuit'));
  event.addItem(Ingredient.of([Item.of('techreborn:data_storage_core')]), Text.black('Created in Assembling Machine using Electronic Circuit, 2x Peridot Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:data_storage_core')]), Text.black('Created in Assembling Machine using Electronic Circuit, Emerald Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 2), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Diamond Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 2), Item.of('techreborn:diamond_small_dust', 3)]), Text.black('Created in Industrial Grinder using Template Template'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 2), Item.of('techreborn:diamond_small_dust', 3)]), Text.black('Created in Industrial Grinder using Trim Templates'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 2), Item.of('techreborn:titanium_dust', 2), Item.of('techreborn:platinum_dust'), Item.of('techreborn:raw_iridium')]), Text.black('Created in Industrial Grinder using Heart Of The Sea'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 3), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Diamond Horse Armor'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 3), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Diamond Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 3), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Template Template'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 3), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Trim Templates'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 3), Item.of('techreborn:diamond_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 4), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Diamond Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 4), Item.of('techreborn:diamond_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 5), Item.of('techreborn:diamond_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Horse Armor'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 5), Item.of('techreborn:diamond_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust', 6), Item.of('techreborn:diamond_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust'), Item.of('techreborn:diamond_small_dust', 2)]), Text.black('Created in Industrial Grinder using Diamond Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust'), Item.of('techreborn:diamond_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust'), Item.of('techreborn:diamond_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust'), Item.of('techreborn:diamond_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust'), Item.of('techreborn:diamond_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_dust')]), Text.black('Created in Grinder using Diamond'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_plate', 9)]), Text.black('Created in Compressor using Diamond Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_plate')]), Text.black('Created in Compressor using Diamond Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Shovel'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 3), Item.of('techreborn:titanium_small_dust', 3), Item.of('techreborn:platinum_small_dust', 2), Item.of('techreborn:iridium_nugget', 3)]), Text.black('Created in Industrial Grinder using Heart Of The Sea'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 5)]), Text.black('Created in Grinder using Template Template'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust', 5)]), Text.black('Created in Grinder using Trim Templates'));
  event.addItem(Ingredient.of([Item.of('techreborn:diamond_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Diamond Shovel'));
  event.addItem(Ingredient.of([Item.of('techreborn:diorite_dust')]), Text.black('Created in Grinder using Diorite'));
  event.addItem(Ingredient.of([Item.of('techreborn:electronic_circuit')]), Text.black('Created in Assembling Machine using Silicon Plates, 2x Copper Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:electrum_dust', 9)]), Text.black('Created in Grinder using Electrum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:electrum_dust')]), Text.black('Created in Grinder using Electrum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:electrum_ingot', 2)]), Text.black('Created in Alloy Smelter using Gold Ingot, Silver Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:electrum_plate', 9)]), Text.black('Created in Compressor using Electrum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:electrum_plate')]), Text.black('Created in Compressor using Electrum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:emerald_dust')]), Text.black('Created in Grinder using Emerald'));
  event.addItem(Ingredient.of([Item.of('techreborn:emerald_plate', 9)]), Text.black('Created in Compressor using Emerald Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:emerald_plate')]), Text.black('Created in Compressor using Emerald Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:ender_eye_dust', 2)]), Text.black('Created in Grinder using Ender Eye'));
  event.addItem(Ingredient.of([Item.of('techreborn:ender_pearl_dust', 2), Item.of('minecraft:blaze_powder')]), Text.black('Created in Centrifuge using 2x Ender Eye Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:ender_pearl_dust', 2)]), Text.black('Created in Grinder using Ender Pearl'));
  event.addItem(Ingredient.of([Item.of('techreborn:endstone_dust', 2)]), Text.black('Created in Industrial Grinder using End Stone'));
  event.addItem(Ingredient.of([Item.of('techreborn:endstone_dust', 4)]), Text.black('Created in Industrial Grinder using End Stone Bricks'));
  event.addItem(Ingredient.of([Item.of('techreborn:endstone_dust')]), Text.black('Created in Grinder using End Stone'));
  event.addItem(Ingredient.of([Item.of('techreborn:energy_crystal')]), Text.black('Created in Assembling Machine using 2x Synthetic Redstone Crystal, Silicon Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:energy_flow_chip')]), Text.black('Created in Assembling Machine using Lapotron Crystal, Industrial Circuit'));
  event.addItem(Ingredient.of([Item.of('techreborn:flint_dust')]), Text.black('Created in Grinder using Flint'));
  event.addItem(Ingredient.of([Item.of('techreborn:galena_dust', 2), Item.of('techreborn:sulfur_dust'), Item.of('techreborn:raw_silver')]), Text.black('Created in Industrial Grinder using Galena Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:galena_dust', 2), Item.of('techreborn:sulfur_dust')]), Text.black('Created in Industrial Grinder using Galena Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:galena_dust', 2)]), Text.black('Created in Grinder using Galena Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:glowstone_small_dust', 2)]), Text.black('Created in Grinder using Shroomlight'));
  event.addItem(Ingredient.of([Item.of('techreborn:glowstone_small_dust')]), Text.black('Created in Grinder using 4x Glow Berries'));
  event.addItem(Ingredient.of([Item.of('techreborn:gold_cable', 6)]), Text.black('Created in Wire Mill using Gold Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:gold_plate', 9)]), Text.black('Created in Compressor using Gold Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:gold_plate')]), Text.black('Created in Compressor using Gold Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:granite_dust', 2)]), Text.black('Created in Grinder using Granite'));
  event.addItem(Ingredient.of([Item.of('techreborn:helium_coolant_cell_60k')]), Text.black('Created in Solid Canning Machine using Helium in a Cell, 2x Tin Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:hot_tungstensteel_ingot'), Item.of('techreborn:dark_ashes_dust', 4)]), Text.black('Created in Blast Furnace using Steel Ingots, Tungsten Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:hv_cable', 6)]), Text.black('Created in Wire Mill using Refined Iron Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:industrial_circuit')]), Text.black('Created in Assembling Machine using Platinum Plates, Advanced Circuit'));
  event.addItem(Ingredient.of([Item.of('techreborn:invar_dust', 9)]), Text.black('Created in Grinder using Invar Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:invar_dust')]), Text.black('Created in Grinder using Invar Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:invar_ingot', 3)]), Text.black('Created in Alloy Smelter using 3x Iron Ingot, Nickel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:invar_plate', 9)]), Text.black('Created in Compressor using Invar Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:invar_plate')]), Text.black('Created in Compressor using Invar Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_alloy_plate'), Item.of('techreborn:dark_ashes_dust', 4)]), Text.black('Created in Implosion Compressor using Iridium Alloy Ingot, 8x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_alloy_plate'), Item.of('techreborn:ender_eye_small_dust', 2)]), Text.black('Created in Implosion Compressor using Iridium Alloy Ingot, 2x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_ingot')]), Text.black('Created in Blast Furnace using Raw Iridium'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_nugget', 2), Item.of('techreborn:nickel_small_dust')]), Text.black('Created in Centrifuge using 2x Platinum Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_ore')]), Text.black('Created in Fusion Reactor using Wolframium in a Cell, Lithium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_plate', 9)]), Text.black('Created in Compressor using Iridium Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:iridium_plate')]), Text.black('Created in Compressor using Iridium Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:iron_plate', 9)]), Text.black('Created in Compressor using Iron Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:iron_plate')]), Text.black('Created in Compressor using Iron Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:lapis_plate')]), Text.black('Created in Compressor using Lapis Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:lazurite_dust', 3), Item.of('techreborn:pyrite_small_dust'), Item.of('techreborn:calcite_small_dust'), Item.of('techreborn:sodalite_small_dust', 2)]), Text.black('Created in Centrifuge using 4x Lapis Lazuli'));
  event.addItem(Ingredient.of([Item.of('techreborn:lazurite_plate')]), Text.black('Created in Compressor using Lazurite Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:lead_ingot'), Item.of('techreborn:silver_ingot')]), Text.black('Created in Blast Furnace using 2x Galena Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:lead_ingot'), Item.of('techreborn:silver_ingot')]), Text.black('Created in Blast Furnace using 8x Galena Small Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:lead_nugget', 3)]), Text.black('Created in Centrifuge using 2x Raw Silver Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:lead_plate', 9)]), Text.black('Created in Compressor using Lead Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:lead_plate')]), Text.black('Created in Compressor using Lead Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:lithium_ion_battery')]), Text.black('Created in Assembling Machine using 2x Aluminum Plates, 2x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:magnesium_dust', 2), Item.of('minecraft:raw_iron', 2), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 9x Peridot Dusts, 3x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:magnesium_dust', 3), Item.of('techreborn:aluminum_dust', 2), Item.of('techreborn:cell', 3).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 6).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 20x Pyrope Dust, 9x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:magnesium_dust'), Item.of('techreborn:calcite_dust', 7)]), Text.black('Created in Centrifuge using 8x Marble Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:magnesium_small_dust', 2), Item.of('minecraft:iron_nugget', 5), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:silicon' }), Item.of('techreborn:cell', 2).withNBT({ 'fluid': 'techreborn:compressed_air' })]), Text.black('Created in Industrial Electrolyzer using 4x Obsidian Dust, 3x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:marble_dust')]), Text.black('Created in Grinder using Limestone'));
  event.addItem(Ingredient.of([Item.of('techreborn:marble_dust')]), Text.black('Created in Grinder using Marble'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherite_nugget', 9)]), Text.black('Created in Industrial Grinder using Netherite Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherrack_dust', 16), Item.of('minecraft:gold_nugget')]), Text.black('Created in Industrial Grinder using 16x Netherrack'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherrack_dust', 8), Item.of('minecraft:gold_nugget')]), Text.black('Created in Industrial Grinder using 8x Netherrack'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherrack_dust')]), Text.black('Created in Grinder using Crimson Nylium'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherrack_dust')]), Text.black('Created in Grinder using Netherrack'));
  event.addItem(Ingredient.of([Item.of('techreborn:netherrack_dust')]), Text.black('Created in Grinder using Warped Nylium'));
  event.addItem(Ingredient.of([Item.of('techreborn:nickel_dust', 9)]), Text.black('Created in Grinder using Nickel Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:nickel_dust')]), Text.black('Created in Grinder using Nickel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:nickel_plate', 9)]), Text.black('Created in Compressor using Nickel Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:nickel_plate')]), Text.black('Created in Compressor using Nickel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_dust', 4), Item.of('minecraft:magma_cream')]), Text.black('Created in Industrial Grinder using 5x Magma Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_dust', 4), Item.of('techreborn:ender_eye_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ender Chest'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_dust', 4)]), Text.black('Created in Grinder using Obsidian'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_dust', 7), Item.of('techreborn:ender_eye_dust')]), Text.black('Created in Industrial Grinder using Ender Chest'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_plate', 9)]), Text.black('Created in Compressor using Obsidian'));
  event.addItem(Ingredient.of([Item.of('techreborn:obsidian_plate')]), Text.black('Created in Compressor using Obsidian Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 2), Item.of('techreborn:peridot_small_dust', 2)]), Text.black('Created in Industrial Grinder using Peridot Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 2)]), Text.black('Created in Grinder using Peridot Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 3), Item.of('techreborn:peridot_small_dust', 2)]), Text.black('Created in Industrial Grinder using Peridot Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 3), Item.of('techreborn:peridot_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 4), Item.of('techreborn:peridot_small_dust', 2)]), Text.black('Created in Industrial Grinder using Peridot Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 4), Item.of('techreborn:peridot_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 5), Item.of('techreborn:peridot_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 6), Item.of('techreborn:peridot_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust', 9)]), Text.black('Created in Grinder using Peridot Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:calcite_dust', 3), Item.of('techreborn:flint_dust', 8), Item.of('techreborn:dark_ashes_dust', 4)]), Text.black('Created in Centrifuge using 16x Basalt Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:peridot_small_dust', 2)]), Text.black('Created in Industrial Grinder using Peridot Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:peridot_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:peridot_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:peridot_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust'), Item.of('techreborn:peridot_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_dust')]), Text.black('Created in Grinder using Peridot Gems'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_gem', 3), Item.of('techreborn:dark_ashes_dust', 12)]), Text.black('Created in Implosion Compressor using 4x Peridot Dusts, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_gem', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Peridot Dusts, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_gem'), Item.of('techreborn:peridot_small_dust', 6), Item.of('techreborn:emerald_small_dust', 2)]), Text.black('Created in Industrial Grinder using Peridot Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_plate', 9)]), Text.black('Created in Compressor using Peridot Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_plate')]), Text.black('Created in Compressor using Peridot Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:peridot_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Peridot Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:plantball', 9), Item.of('minecraft:dirt', 4), Item.of('minecraft:sand', 2), Item.of('minecraft:gravel', 2)]), Text.black('Created in Centrifuge using 16x Moss Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_dust', 2), Item.of('techreborn:nickel_dust'), Item.of('techreborn:iridium_nugget', 2)]), Text.black('Created in Industrial Grinder using Sheldonite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_dust', 3), Item.of('techreborn:nickel_dust'), Item.of('techreborn:iridium_nugget', 2)]), Text.black('Created in Industrial Grinder using Sheldonite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_dust', 9)]), Text.black('Created in Grinder using Platinum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_dust')]), Text.black('Created in Fusion Reactor using Wolframium in a Cell, Beryllium in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_dust')]), Text.black('Created in Grinder using Platinum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_plate', 9)]), Text.black('Created in Compressor using Platinum Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:platinum_plate')]), Text.black('Created in Compressor using Platinum Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:pyrite_dust', 2)]), Text.black('Created in Grinder using Pyrite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:pyrite_dust', 5), Item.of('techreborn:sulfur_dust', 2)]), Text.black('Created in Industrial Grinder using Pyrite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:pyrope_dust', 3), Item.of('techreborn:almandine_dust', 5), Item.of('techreborn:spessartine_dust', 8)]), Text.black('Created in Centrifuge using 16x Red Garnet Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:quartz_dust', 4)]), Text.black('Created in Grinder using Quartz Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:quartz_dust')]), Text.black('Created in Grinder using Quartz'));
  event.addItem(Ingredient.of([Item.of('techreborn:quartz_plate')]), Text.black('Created in Compressor using Quartz Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_iridium', 2), Item.of('techreborn:platinum_small_dust', 2)]), Text.black('Created in Industrial Grinder using Iridium Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_iridium'), Item.of('techreborn:platinum_dust')]), Text.black('Created in Industrial Grinder using Iridium Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_iridium'), Item.of('techreborn:platinum_small_dust', 2)]), Text.black('Created in Industrial Grinder using Iridium Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_lead', 2), Item.of('techreborn:galena_small_dust', 2)]), Text.black('Created in Industrial Grinder using Lead Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_lead', 2)]), Text.black('Created in Grinder using Lead Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_silver', 2), Item.of('techreborn:galena_small_dust', 2)]), Text.black('Created in Industrial Grinder using Silver Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_silver', 2)]), Text.black('Created in Grinder using Silver Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_tin', 2), Item.of('minecraft:iron_nugget', 3), Item.of('techreborn:zinc_nugget', 3)]), Text.black('Created in Industrial Grinder using Tin Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_tin', 2), Item.of('minecraft:raw_iron'), Item.of('techreborn:zinc_dust')]), Text.black('Created in Industrial Grinder using Tin Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_tin', 2)]), Text.black('Created in Grinder using Tin Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:raw_tungsten', 2), Item.of('minecraft:iron_nugget', 7), Item.of('techreborn:manganese_small_dust', 3)]), Text.black('Created in Industrial Grinder using Tungsten Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_dust', 4), Item.of('techreborn:dark_ashes_dust', 4)]), Text.black('Created in Implosion Compressor using 9x Redstone Block, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_dust', 4), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 9x Redstone Block, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_dust', 9)]), Text.black('Created in Grinder using Red Garnet Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_dust')]), Text.black('Created in Grinder using Red Garnet Gems'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_gem', 3), Item.of('techreborn:dark_ashes_dust', 8)]), Text.black('Created in Implosion Compressor using 4x Red Garnet Dust, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_gem', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Red Garnet Dust, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_plate', 9)]), Text.black('Created in Compressor using Red Garnet Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:red_garnet_plate')]), Text.black('Created in Compressor using Red Garnet Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:redstone_plate')]), Text.black('Created in Compressor using Redstone Block'));
  event.addItem(Ingredient.of([Item.of('techreborn:refined_iron_ingot', 2), Item.of('techreborn:cell')]), Text.black('Created in Blast Furnace using Pyrite Ores, Calcium Carbonate in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:refined_iron_ingot', 3), Item.of('techreborn:cell')]), Text.black('Created in Blast Furnace using Iron Ores, Calcium Carbonate in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:refined_iron_plate', 9)]), Text.black('Created in Compressor using Refined Iron Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:refined_iron_plate')]), Text.black('Created in Compressor using Refined Iron Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber_planks', 4), Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Rubber Logs'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber_pressure_plate', 2), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Rubber Slab'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber_slab'), Item.of('techreborn:saw_dust', 2)]), Text.black('Created in Industrial Sawmill using Rubber Stair'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber', 14)]), Text.black('Created in Centrifuge using 4x Sap'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber', 2)]), Text.black('Created in Extractor using Slime Ball'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber', 3)]), Text.black('Created in Extractor using Sap'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber')]), Text.black('Created in Extractor using Rubber Logs'));
  event.addItem(Ingredient.of([Item.of('techreborn:rubber')]), Text.black('Created in Extractor using Rubber Sapling'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 2), Item.of('techreborn:ruby_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ruby Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 2)]), Text.black('Created in Grinder using Ruby Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 3), Item.of('techreborn:ruby_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ruby Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 3), Item.of('techreborn:ruby_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 4), Item.of('techreborn:ruby_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ruby Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 4), Item.of('techreborn:ruby_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 5), Item.of('techreborn:ruby_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 6), Item.of('techreborn:ruby_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust', 9)]), Text.black('Created in Grinder using Ruby Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust'), Item.of('techreborn:ruby_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ruby Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust'), Item.of('techreborn:ruby_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust'), Item.of('techreborn:ruby_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust'), Item.of('techreborn:ruby_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust'), Item.of('techreborn:ruby_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_dust')]), Text.black('Created in Grinder using Rubies'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_gem', 3), Item.of('techreborn:dark_ashes_dust', 12)]), Text.black('Created in Implosion Compressor using 4x Ruby Dusts, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_gem', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Ruby Dusts, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_gem'), Item.of('techreborn:ruby_small_dust', 6), Item.of('techreborn:red_garnet_small_dust', 2)]), Text.black('Created in Industrial Grinder using Ruby Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_plate', 9)]), Text.black('Created in Compressor using Ruby Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_plate')]), Text.black('Created in Compressor using Ruby Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:ruby_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Ruby Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:sap', 8), Item.of('techreborn:cell', 1).withNBT({ 'fluid': 'techreborn:methane' }), Item.of('techreborn:cell', 4).withNBT({ 'fluid': 'techreborn:carbon' })]), Text.black('Created in Centrifuge using 16x Rubber Logs, 5x Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 2), Item.of('techreborn:sapphire_small_dust', 2)]), Text.black('Created in Industrial Grinder using Sapphire Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 2)]), Text.black('Created in Grinder using Sapphire Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 3), Item.of('techreborn:sapphire_small_dust', 2)]), Text.black('Created in Industrial Grinder using Sapphire Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 3), Item.of('techreborn:sapphire_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 4), Item.of('techreborn:sapphire_small_dust', 2)]), Text.black('Created in Industrial Grinder using Sapphire Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 4), Item.of('techreborn:sapphire_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Helmet'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 5), Item.of('techreborn:sapphire_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Leggings'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 6), Item.of('techreborn:sapphire_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Chestplate'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust', 9)]), Text.black('Created in Grinder using Sapphire Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust'), Item.of('techreborn:sapphire_small_dust', 2)]), Text.black('Created in Industrial Grinder using Sapphire Boots'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust'), Item.of('techreborn:sapphire_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust'), Item.of('techreborn:sapphire_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust'), Item.of('techreborn:sapphire_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust'), Item.of('techreborn:sapphire_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_dust')]), Text.black('Created in Grinder using Sapphires'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_gem', 3), Item.of('techreborn:dark_ashes_dust', 12)]), Text.black('Created in Implosion Compressor using 4x Sapphire Dusts, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_gem', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Sapphire Dusts, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_gem'), Item.of('techreborn:sapphire_small_dust', 6), Item.of('techreborn:peridot_small_dust', 2)]), Text.black('Created in Industrial Grinder using Sapphire Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_plate', 9)]), Text.black('Created in Compressor using Sapphire Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_plate')]), Text.black('Created in Compressor using Sapphire Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust', 2), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust', 3), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:sapphire_small_dust'), Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Grinder using Sapphire Spade'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust', 3)]), Text.black('Created in Industrial Sawmill using Wooden Doors'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust', 8)]), Text.black('Created in Industrial Sawmill using Planks'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust')]), Text.black('Created in Industrial Sawmill using Signs'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust')]), Text.black('Created in Industrial Sawmill using Wooden Fences'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust')]), Text.black('Created in Industrial Sawmill using Wooden Pressure Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_dust')]), Text.black('Created in Industrial Sawmill using Wooden Trapdoors'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 2)]), Text.black('Created in Industrial Sawmill using Bowl'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 2)]), Text.black('Created in Industrial Sawmill using Mangrove Roots'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 2)]), Text.black('Created in Industrial Sawmill using Wooden Shovel'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 2)]), Text.black('Created in Industrial Sawmill using Wooden Sword'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 3)]), Text.black('Created in Grinder using Wooden Doors'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 3)]), Text.black('Created in Industrial Sawmill using Treetap'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 3)]), Text.black('Created in Industrial Sawmill using Wooden Hoe'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 4)]), Text.black('Created in Grinder using Wooden Slabs'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 5)]), Text.black('Created in Industrial Sawmill using Wooden Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 5)]), Text.black('Created in Industrial Sawmill using Wooden Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 6)]), Text.black('Created in Grinder using Wooden Stairs'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust', 8)]), Text.black('Created in Grinder using Planks'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Signs'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Wooden Axe'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Wooden Fences'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Wooden Pickaxe'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Wooden Pressure Plates'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Grinder using Wooden Trapdoors'));
  event.addItem(Ingredient.of([Item.of('techreborn:saw_small_dust')]), Text.black('Created in Industrial Sawmill using Wooden Buttons'));
  event.addItem(Ingredient.of([Item.of('techreborn:silicon_plate'), Item.of('techreborn:cell', 2)]), Text.black('Created in Blast Furnace using Silicon in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_ingot', 2), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Silver Boots, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Silver Helmet, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Silver Leggings, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_ingot', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Silver Chestplate, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_nugget', 3)]), Text.black('Created in Centrifuge using 2x Raw Lead Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_nugget', 6), Item.of('techreborn:lead_nugget', 6), Item.of('techreborn:sulfur_small_dust', 2)]), Text.black('Created in Industrial Electrolyzer using 2x Galena Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_plate', 9)]), Text.black('Created in Compressor using Silver Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:silver_plate')]), Text.black('Created in Compressor using Silver Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:sodalite_dust', 12), Item.of('techreborn:aluminum_dust', 3)]), Text.black('Created in Industrial Grinder using Sodalite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sodalite_dust', 2)]), Text.black('Created in Grinder using Sodalite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sphalerite_dust', 2)]), Text.black('Created in Grinder using Sphalerite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sphalerite_dust', 5), Item.of('techreborn:zinc_dust', 3), Item.of('techreborn:yellow_garnet_dust')]), Text.black('Created in Industrial Grinder using Sphalerite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sphalerite_dust', 5), Item.of('techreborn:zinc_dust'), Item.of('techreborn:yellow_garnet_small_dust')]), Text.black('Created in Industrial Grinder using Sphalerite Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sponge_piece', 5)]), Text.black('Created in Grinder using Sponges'));
  event.addItem(Ingredient.of([Item.of('techreborn:sponge_piece')]), Text.black('Created in Extractor using 32x Pufferfish'));
  event.addItem(Ingredient.of([Item.of('techreborn:sponge_piece')]), Text.black('Created in Extractor using 64x Cod'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_dust', 9)]), Text.black('Created in Grinder using Steel Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_dust')]), Text.black('Created in Grinder using Steel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot', 2), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Steel Boots, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot', 3), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Steel Helmet, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot', 4), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Steel Leggings, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot', 5), Item.of('techreborn:dark_ashes_dust')]), Text.black('Created in Blast Furnace using Steel Chestplate, Sand'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot'), Item.of('techreborn:cell', 2)]), Text.black('Created in Blast Furnace using Refined Iron Ingot, Carbon in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot'), Item.of('techreborn:dark_ashes_dust', 2)]), Text.black('Created in Blast Furnace using Refined Iron Ingot, 4x Coal Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot')]), Text.black('Created in Blast Furnace using 4x Steel Small Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_ingot')]), Text.black('Created in Blast Furnace using Steel Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_plate', 9)]), Text.black('Created in Compressor using Steel Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:steel_plate')]), Text.black('Created in Compressor using Steel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:sulfur_dust', 2)]), Text.black('Created in Grinder using Sulfur Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:sulfur_dust'), Item.of('techreborn:cell')]), Text.black('Created in Centrifuge using Sulfur in a Cell'));
  event.addItem(Ingredient.of([Item.of('techreborn:sulfur_dust')]), Text.black('Created in Grinder using Sulfurs'));
  event.addItem(Ingredient.of([Item.of('techreborn:synthetic_redstone_crystal')]), Text.black('Created in Chemical Reactor using 32x Redstone, Diamond'));
  event.addItem(Ingredient.of([Item.of('techreborn:tin_cable', 6)]), Text.black('Created in Wire Mill using Tin Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:tin_nugget', 3), Item.of('techreborn:nickel_nugget', 3)]), Text.black('Created in Centrifuge using 2x Raw Iron'));
  event.addItem(Ingredient.of([Item.of('techreborn:tin_nugget', 3)]), Text.black('Created in Centrifuge using Zinc Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:tin_plate', 9)]), Text.black('Created in Compressor using Tin Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:tin_plate')]), Text.black('Created in Compressor using Tin Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_dust', 9)]), Text.black('Created in Grinder using Titanium Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_dust')]), Text.black('Created in Grinder using Titanium Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_ingot')]), Text.black('Created in Blast Furnace using 4x Titanium Small Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_ingot')]), Text.black('Created in Blast Furnace using Titanium Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_plate', 9)]), Text.black('Created in Compressor using Titanium Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:titanium_plate')]), Text.black('Created in Compressor using Titanium Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungsten_ingot')]), Text.black('Created in Blast Furnace using 4x Tungsten Small Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungsten_ingot')]), Text.black('Created in Blast Furnace using Raw Tungsten Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungsten_plate', 9)]), Text.black('Created in Compressor using Tungsten Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungsten_plate')]), Text.black('Created in Compressor using Tungsten Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungstensteel_ingot')]), Text.black('Created in Vacuum Freezer using Hot Tungstensteel Ingot'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungstensteel_plate', 9)]), Text.black('Created in Compressor using Tungstensteel Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:tungstensteel_plate')]), Text.black('Created in Compressor using Tungstensteel Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:water_coolant_cell_10k', 2)]), Text.black('Created in Solid Canning Machine using Water in a Cell, 2x Tin Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:wind_mill')]), Text.black('Created in Assembling Machine using Solid Fuel Generator, Magnalium Plate'));
  event.addItem(Ingredient.of([Item.of('techreborn:wood_plate')]), Text.black('Created in Compressor using 2x Saw Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:wood_plate')]), Text.black('Created in Compressor using Planks'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_dust', 9)]), Text.black('Created in Grinder using Yellow Garnet Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_dust')]), Text.black('Created in Grinder using Yellow Garnet Gems'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_gem', 3), Item.of('techreborn:dark_ashes_dust', 8)]), Text.black('Created in Implosion Compressor using 4x Yellow Garnet Dust, 16x Tnt'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_gem', 3), Item.of('techreborn:ender_eye_small_dust', 4)]), Text.black('Created in Implosion Compressor using 4x Yellow Garnet Dust, 4x End Crystal'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_plate', 9)]), Text.black('Created in Compressor using Yellow Garnet Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:yellow_garnet_plate')]), Text.black('Created in Compressor using Yellow Garnet Dusts'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_dust', 9)]), Text.black('Created in Grinder using Zinc Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_dust'), Item.of('techreborn:sulfur_dust')]), Text.black('Created in Industrial Electrolyzer using 2x Sphalerite Dust'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_dust')]), Text.black('Created in Grinder using Zinc Ingots'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_nugget', 3), Item.of('minecraft:iron_nugget', 3)]), Text.black('Created in Centrifuge using 2x Raw Tin Ores'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_plate', 9)]), Text.black('Created in Compressor using Zinc Blocks'));
  event.addItem(Ingredient.of([Item.of('techreborn:zinc_plate')]), Text.black('Created in Compressor using Zinc Ingots'));
});