/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.core.Templates;
import com.jozufozu.flywheel.core.compile.CompileUtil;
import com.jozufozu.flywheel.core.compile.Memoizer;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.StateSnapshot;
import com.jozufozu.flywheel.core.source.FileIndexImpl;
import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.core.source.SourceFile;
import java.util.Objects;

public class VertexCompiler
extends Memoizer<Context, GlShader> {
    private final Template<? extends VertexData> template;
    private final FileResolution header;

    public VertexCompiler(Template<? extends VertexData> template, FileResolution header) {
        this.template = template;
        this.header = header;
    }

    @Override
    protected GlShader _create(Context key) {
        StringBuilder finalSource = new StringBuilder();
        finalSource.append(CompileUtil.generateHeader(this.template.getVersion(), ShaderType.VERTEX));
        key.ctx.getShaderConstants().writeInto(finalSource);
        finalSource.append("struct Vertex {\n\tvec3 pos;\n\tvec4 color;\n\tvec2 texCoords;\n\tvec2 light;\n\tvec3 normal;\n};\n");
        finalSource.append(key.vertexType.getShaderHeader());
        FileIndexImpl index = new FileIndexImpl();
        Templates.DIFFUSE_FILE.getFile().generateFinalSource(index, finalSource);
        this.header.getFile().generateFinalSource(index, finalSource);
        key.file.generateFinalSource(index, finalSource);
        VertexData appliedTemplate = this.template.apply(key.file);
        finalSource.append(appliedTemplate.generateFooter(index, key.vertexType));
        return new GlShader(key.file.name, ShaderType.VERTEX, finalSource.toString());
    }

    @Override
    protected void _destroy(GlShader value) {
        value.delete();
    }

    public static class Context {
        private final SourceFile file;
        private final StateSnapshot ctx;
        private final VertexType vertexType;

        public Context(SourceFile file, StateSnapshot ctx, VertexType vertexType) {
            this.file = file;
            this.ctx = ctx;
            this.vertexType = vertexType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context that = (Context)o;
            return this.file == that.file && this.vertexType == that.vertexType && this.ctx.equals(that.ctx);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.ctx, this.vertexType);
        }
    }
}

