/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.compiler;

import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import top.leonx.irisflw.accessors.NewWorldRenderingPipelineAccessor;
import top.leonx.irisflw.accessors.ProgramDirectivesAccessor;
import top.leonx.irisflw.accessors.ProgramSetAccessor;
import top.leonx.irisflw.compiler.IrisProgramCompilerBase;
import top.leonx.irisflw.transformer.PreprocessorBase;
import top.leonx.irisflw.transformer.TemplatePreprocessor;

public class TemplateProgramCompiler<P extends WorldProgram>
extends IrisProgramCompilerBase<P> {
    TemplatePreprocessor preprocessor;

    public TemplateProgramCompiler(GlProgram.Factory<P> factory, Template<? extends VertexData> template, FileResolution header) {
        super(factory, template, header);
        this.preprocessor = new TemplatePreprocessor(template, header);
    }

    @Override
    P createIrisShaderProgram(ProgramContext ctx, boolean isShadow) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof NewWorldRenderingPipeline) {
            ProgramSource source;
            NewWorldRenderingPipeline newPipeline = (NewWorldRenderingPipeline)pipeline;
            ProgramSet programSet = ((NewWorldRenderingPipelineAccessor)newPipeline).getProgramSet();
            Optional<ProgramSource> sourceOptional = isShadow ? ((ProgramSetAccessor)programSet).getShadowFlw() : ((ProgramSetAccessor)programSet).getGbuffersFlw();
            if (sourceOptional.isPresent() && (source = sourceOptional.get()).getVertexSource().isPresent()) {
                String vertexSource = (String)source.getVertexSource().get();
                vertexSource = this.preprocessor.preprocess(vertexSource, new PreprocessorBase.Context(ctx.spec.getVertexFile(), ctx.ctx, ctx.vertexType));
                ProgramSource processedSource = this.programSourceOverrideVertexSource(ctx, programSet, source, vertexSource);
                ((ProgramDirectivesAccessor)processedSource.getDirectives()).setFlwAlphaTestOverride(new AlphaTest(AlphaTestFunction.GREATER, ctx.alphaDiscard));
                return this.createWorldProgramBySource(ctx, isShadow, (NewWorldRenderingPipelineAccessor)pipeline, processedSource);
            }
        }
        return null;
    }
}

