/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.transformer;

import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileResolution;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.leonx.irisflw.transformer.PreprocessorBase;

public class AutoInsertPreprocessor
extends PreprocessorBase {
    Pattern versionPattern = Pattern.compile("#version\\s+\\d+");
    Pattern ftransformAssignPattern = Pattern.compile("ftransform\\(\\)");
    Pattern textureMatrixPattern = Pattern.compile("gl_TextureMatrix\\[\\d\\]");
    Pattern boxCoordDetector = Pattern.compile("BoxCoord");
    Pattern definePattern = Pattern.compile("(?<=#define\\s)\\w+(?=\\s+)");
    public String mainFunctionRegex = "void\\s+main\\(\\s*\\)\\s*\\{";
    private Pattern mainFunctionPattern = Pattern.compile(this.mainFunctionRegex);

    public AutoInsertPreprocessor(Template<? extends VertexData> template, FileResolution header) {
        super(template, header);
    }

    @Override
    public String preprocess(String irisSource, PreprocessorBase.Context key) {
        Matcher mainFuncMatcher;
        StringBuilder builder = new StringBuilder(irisSource);
        VertexData appliedTemplate = (VertexData)this.template.apply(key.file);
        StringBuilder predefinedCodeBuilder = new StringBuilder();
        this.genPredefine(key, builder, appliedTemplate, predefinedCodeBuilder);
        this.renameFlwDefine(predefinedCodeBuilder);
        this.replaceOriginalDefine(builder, predefinedCodeBuilder);
        StringBuilder createVertexBuilder = new StringBuilder();
        createVertexBuilder.append('\n');
        this.generateCreateVertex(appliedTemplate, createVertexBuilder);
        createVertexBuilder.append("vec4 _flw_patched_vertex_pos = FLWVertex(v);\n");
        createVertexBuilder.append('\n');
        Matcher versionMatcher = this.versionPattern.matcher(builder);
        if (versionMatcher.find()) {
            builder.insert(versionMatcher.end(), predefinedCodeBuilder);
        }
        if ((mainFuncMatcher = this.mainFunctionPattern.matcher(builder)).find()) {
            builder.insert(mainFuncMatcher.end(), createVertexBuilder);
        }
        Matcher ftransformMatcher = this.ftransformAssignPattern.matcher(builder);
        while (ftransformMatcher.find()) {
            builder.replace(ftransformMatcher.start(), ftransformMatcher.end(), "_flw_patched_vertex_pos");
            ftransformMatcher = this.ftransformAssignPattern.matcher(builder);
        }
        Matcher textureMatrixMatcher = this.textureMatrixPattern.matcher(builder);
        while (textureMatrixMatcher.find()) {
            builder.replace(textureMatrixMatcher.start(), textureMatrixMatcher.end(), "1.0");
            textureMatrixMatcher = this.textureMatrixPattern.matcher(builder);
        }
        return builder.toString();
    }

    private void replaceOriginalDefine(StringBuilder builder, StringBuilder predefinedCodeBuilder) {
        predefinedCodeBuilder.append("#undef gl_Vertex\n#undef gl_MultiTexCoord0\n#undef gl_Normal\n#undef gl_Color\n#define gl_Vertex (inverse(gl_ProjectionMatrix*gl_ModelViewMatrix)*_flw_patched_vertex_pos)\n#define gl_MultiTexCoord0 (vec4(v.texCoords,0,1))\n#define gl_Normal (v.normal)\n#define gl_Color (v.color)\n");
        if (this.boxCoordDetector.matcher(builder).find()) {
            predefinedCodeBuilder.append("#undef gl_MultiTexCoord1\n#define gl_MultiTexCoord1 (vec4(max(v.light,texture3D(uLightVolume,BoxCoord).rg),0,1))\n");
        } else {
            predefinedCodeBuilder.append("#undef gl_MultiTexCoord1\n#define gl_MultiTexCoord1 (vec4(v.light,0,1))\n");
        }
        predefinedCodeBuilder.append('\n');
    }

    private void genPredefine(PreprocessorBase.Context key, StringBuilder builder, VertexData appliedTemplate, StringBuilder predefinedCodeBuilder) {
        predefinedCodeBuilder.append('\n');
        this.genHeadSource(predefinedCodeBuilder, key);
        this.genCommonSource(predefinedCodeBuilder, key, appliedTemplate);
    }

    private void renameFlwDefine(StringBuilder predefinedCodeBuilder) {
        this.definePattern = Pattern.compile("(?<=#define\\s)\\w+(?<!_flw)(?=\\s+)");
        Matcher defineMatcher = this.definePattern.matcher(predefinedCodeBuilder);
        while (defineMatcher.find()) {
            String name = defineMatcher.group();
            if (name.contains("_flw")) continue;
            Pattern thisIdentPattern = Pattern.compile(String.format("(?<=\\W)%s(?=\\W)", name));
            Matcher thisIdentMatcher = thisIdentPattern.matcher(predefinedCodeBuilder);
            String newName = name + "_flw";
            while (thisIdentMatcher.find()) {
                predefinedCodeBuilder.replace(thisIdentMatcher.start(), thisIdentMatcher.end(), newName);
                thisIdentMatcher = thisIdentPattern.matcher(predefinedCodeBuilder);
            }
            defineMatcher = this.definePattern.matcher(predefinedCodeBuilder);
        }
    }
}

