/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.EggHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodDefinition;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatDefinition;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.player.PlayerData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.commands.TFCCommands;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.ChunkAccessAccessor;
import net.dries007.tfc.network.ChunkUnwatchPacket;
import net.dries007.tfc.network.EffectExpirePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PlayerDrinkPacket;
import net.dries007.tfc.util.AxeLoggingHelper;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.EntityDamageResistance;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.InteractionManager;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.SelfTests;
import net.dries007.tfc.util.Support;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.events.SelectClimateModelEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.dries007.tfc.world.NoopClimateSampler;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataCache;
import net.dries007.tfc.world.chunkdata.ChunkDataCapability;
import net.dries007.tfc.world.chunkdata.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public final class ForgeEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final BlockHitResult FAKE_MISS = BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ForgeEventHandler::onCreateWorldSpawn);
        bus.addGenericListener(LevelChunk.class, ForgeEventHandler::attachChunkCapabilities);
        bus.addGenericListener(Level.class, ForgeEventHandler::attachWorldCapabilities);
        bus.addGenericListener(ItemStack.class, ForgeEventHandler::attachItemCapabilities);
        bus.addGenericListener(Entity.class, ForgeEventHandler::attachEntityCapabilities);
        bus.addListener(ForgeEventHandler::onChunkWatch);
        bus.addListener(ForgeEventHandler::onChunkUnwatch);
        bus.addListener(ForgeEventHandler::onChunkLoad);
        bus.addListener(ForgeEventHandler::onChunkUnload);
        bus.addListener(ForgeEventHandler::onChunkDataSave);
        bus.addListener(ForgeEventHandler::onChunkDataLoad);
        bus.addListener(ForgeEventHandler::registerCommands);
        bus.addListener(ForgeEventHandler::onBlockBroken);
        bus.addListener(ForgeEventHandler::onBlockPlace);
        bus.addListener(ForgeEventHandler::onBreakSpeed);
        bus.addListener(ForgeEventHandler::onNeighborUpdate);
        bus.addListener(ForgeEventHandler::onExplosionDetonate);
        bus.addListener(ForgeEventHandler::onWorldTick);
        bus.addListener(ForgeEventHandler::onWorldLoad);
        bus.addListener(ForgeEventHandler::onCreateNetherPortal);
        bus.addListener(ForgeEventHandler::onFluidPlaceBlock);
        bus.addListener(ForgeEventHandler::onFireStart);
        bus.addListener(ForgeEventHandler::onProjectileImpact);
        bus.addListener(ForgeEventHandler::onPlayerTick);
        bus.addListener(ForgeEventHandler::onEffectRemove);
        bus.addListener(ForgeEventHandler::onEffectExpire);
        bus.addListener(ForgeEventHandler::onLivingJump);
        bus.addListener(ForgeEventHandler::onLivingHurt);
        bus.addListener(ForgeEventHandler::onLivingSpawnCheck);
        bus.addListener(ForgeEventHandler::onEntityJoinWorld);
        bus.addListener(ForgeEventHandler::onItemExpire);
        bus.addListener(ForgeEventHandler::onPlayerLoggedIn);
        bus.addListener(ForgeEventHandler::onPlayerRespawn);
        bus.addListener(ForgeEventHandler::onPlayerChangeDimension);
        bus.addListener(ForgeEventHandler::onServerChat);
        bus.addListener(ForgeEventHandler::onPlayerRightClickBlock);
        bus.addListener(ForgeEventHandler::onPlayerRightClickItem);
        bus.addListener(ForgeEventHandler::onPlayerRightClickEmpty);
        bus.addListener(ForgeEventHandler::addReloadListeners);
        bus.addListener(ForgeEventHandler::onDataPackSync);
        bus.addListener(ForgeEventHandler::onTagsUpdated);
        bus.addListener(ForgeEventHandler::onBoneMeal);
        bus.addListener(ForgeEventHandler::onSelectClimateModel);
        bus.addListener(ForgeEventHandler::onAnimalTame);
    }

    public static void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && (levelAccessor = (level = (ServerLevel)levelAccessor).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
            BlockPos pos;
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)levelAccessor;
            ChunkGenerator generator = extension.self();
            ServerLevelData settings = event.getSettings();
            BiomeSourceExtension source = extension.getBiomeSource();
            Random random = new Random(level.m_7328_());
            Pair posPair = generator.m_62218_().m_207481_(source.getSpawnCenterX(), 0, source.getSpawnCenterZ(), source.getSpawnDistance(), source.getSpawnDistance() / 256, biome -> TFCBiomes.getExtensionOrThrow((LevelAccessor)level, (Biome)biome.m_203334_()).isSpawnable(), random, false, NoopClimateSampler.INSTANCE);
            if (posPair == null) {
                LOGGER.warn("Unable to find spawn biome!");
                pos = new BlockPos(0, generator.m_6337_(), 0);
            } else {
                pos = (BlockPos)posPair.getFirst();
            }
            ChunkPos chunkPos = new ChunkPos(pos);
            settings.m_7250_(chunkPos.m_45615_().m_142082_(8, generator.m_142051_((LevelHeightAccessor)level), 8), 0.0f);
            boolean foundExactSpawn = false;
            int x = 0;
            int z = 0;
            int xStep = 0;
            int zStep = -1;
            for (int tries = 0; tries < 1024; ++tries) {
                BlockPos spawnPos;
                if (x > -16 && x <= 16 && z > -16 && z <= 16 && (spawnPos = PlayerRespawnLogic.m_183932_((ServerLevel)level, (ChunkPos)new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z))) != null) {
                    settings.m_7250_(spawnPos, 0.0f);
                    foundExactSpawn = true;
                    break;
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = xStep;
                    xStep = -zStep;
                    zStep = swap;
                }
                x += xStep;
                z += zStep;
            }
            if (!foundExactSpawn) {
                LOGGER.warn("Unable to find a suitable spawn location!");
            }
            if (level.m_142572_().m_129910_().m_5961_().m_64660_()) {
                LOGGER.warn("No bonus chest for you, you cheaty cheater!");
            }
            event.setCanceled(true);
        }
    }

    public static void attachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        LevelChunk chunk = (LevelChunk)event.getObject();
        if (!chunk.m_6430_()) {
            ServerLevel serverLevel;
            ChunkGenerator chunkGenerator;
            ChunkData data;
            Level level = ((LevelChunk)event.getObject()).m_62953_();
            ChunkPos chunkPos = ((LevelChunk)event.getObject()).m_7697_();
            if (Helpers.isClientSide((LevelReader)level)) {
                data = ChunkDataCache.CLIENT.computeIfAbsent(chunkPos, ChunkData::createClient);
            } else if (level instanceof ServerLevel && (chunkGenerator = (serverLevel = (ServerLevel)level).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
                ChunkGeneratorExtension ex = (ChunkGeneratorExtension)chunkGenerator;
                data = ex.getChunkDataProvider().promotePartialOrCreate(chunkPos);
            } else {
                data = new ChunkData(chunkPos, RockLayerSettings.EMPTY);
            }
            event.addCapability(ChunkDataCapability.KEY, (ICapabilityProvider)data);
        }
    }

    public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(WorldTrackerCapability.KEY, (ICapabilityProvider)new WorldTracker((Level)event.getObject()));
    }

    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!stack.m_41619_()) {
            FoodDefinition food;
            event.addCapability(ForgingCapability.KEY, (ICapabilityProvider)new Forging(stack));
            HeatDefinition def = HeatCapability.get(stack);
            if (def != null) {
                event.addCapability(HeatCapability.KEY, def.create());
            }
            if ((food = FoodCapability.get(stack)) != null) {
                event.addCapability(FoodCapability.KEY, (ICapabilityProvider)new FoodHandler(food.getData()));
            }
            if (stack.m_41720_() == Items.f_42521_) {
                event.addCapability(EggCapability.KEY, (ICapabilityProvider)new EggHandler(stack));
            }
        }
    }

    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(PlayerDataCapability.KEY, (ICapabilityProvider)new PlayerData(player));
        }
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ChunkPos pos = event.getPos();
        ChunkData chunkData = ChunkData.get((LevelReader)event.getWorld(), pos);
        if (chunkData.getStatus() != ChunkData.Status.EMPTY) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((ChunkWatchEvent.Watch)event).getPlayer()), chunkData.getUpdatePacket());
        } else {
            ChunkDataCache.WATCH_QUEUE.enqueueUnloadedChunk(pos, event.getPlayer());
        }
    }

    public static void onChunkUnwatch(ChunkWatchEvent.UnWatch event) {
        ChunkPos pos = event.getPos();
        PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((ChunkWatchEvent.UnWatch)event).getPlayer()), new ChunkUnwatchPacket(pos));
        ChunkDataCache.WATCH_QUEUE.dequeueChunk(pos, event.getPlayer());
    }

    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!Helpers.isClientSide((LevelReader)event.getWorld()) && !(event.getChunk() instanceof EmptyLevelChunk)) {
            ChunkPos pos = event.getChunk().m_7697_();
            ChunkData.getCapability(event.getChunk()).ifPresent(data -> {
                ChunkDataCache.SERVER.update(pos, (ChunkData)data);
                ChunkDataCache.WATCH_QUEUE.dequeueLoadedChunk(pos, (ChunkData)data);
            });
        }
    }

    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!Helpers.isClientSide((LevelReader)event.getWorld()) && !(event.getChunk() instanceof EmptyLevelChunk)) {
            ChunkDataCache.SERVER.remove(event.getChunk().m_7697_());
        }
    }

    public static void onChunkDataSave(ChunkDataEvent.Save event) {
        ChunkAccess chunkAccess;
        if (event.getChunk().m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK && (chunkAccess = event.getChunk()) instanceof ProtoChunk) {
            ChunkGeneratorExtension ex;
            CompoundTag nbt;
            ProtoChunk chunk = (ProtoChunk)chunkAccess;
            chunkAccess = ((ServerChunkCache)event.getWorld().m_7726_()).m_8481_();
            if (chunkAccess instanceof ChunkGeneratorExtension && (nbt = (ex = (ChunkGeneratorExtension)chunkAccess).getChunkDataProvider().savePartial(chunk)) != null) {
                event.getData().m_128365_("tfc_protochunk_data", (Tag)nbt);
            }
        }
    }

    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        ServerLevel level;
        ProtoChunk chunk;
        ChunkAccess chunkAccess;
        if (event.getChunk().m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK && event.getData().m_128425_("tfc_protochunk_data", 10) && (chunkAccess = event.getChunk()) instanceof ProtoChunk && (chunkAccess = ((ChunkAccessAccessor)(chunk = (ProtoChunk)chunkAccess)).accessor$getLevelHeightAccessor()) instanceof ServerLevel && (chunkAccess = (level = (ServerLevel)chunkAccess).m_7726_().m_8481_()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension generator = (ChunkGeneratorExtension)chunkAccess;
            generator.getChunkDataProvider().loadPartial(chunk, event.getData().m_128469_("tfc_protochunk_data"));
        }
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        LOGGER.debug("Registering TFC Commands");
        TFCCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        BlockPos pos;
        LevelAccessor world = event.getWorld();
        BlockState state = world.m_8055_(pos = event.getPos());
        if (Helpers.isBlock(state, TFCTags.Blocks.CAN_TRIGGER_COLLAPSE) && world instanceof Level) {
            Level level = (Level)world;
            CollapseRecipe.tryTriggerCollapse(level, pos);
            return;
        }
        ItemStack stack = event.getPlayer().m_21205_();
        if (AxeLoggingHelper.isLoggingAxe(stack) && AxeLoggingHelper.isLoggingBlock(state)) {
            event.setCanceled(true);
            AxeLoggingHelper.doLogging(world, pos, event.getPlayer(), stack);
        }
    }

    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            if (Helpers.isBlock(state, TFCTags.Blocks.CAN_LANDSLIDE)) {
                world.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addLandslidePos(pos));
            }
            if (Helpers.isBlock(state, TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) {
                world.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addIsolatedPos(pos));
            }
        }
    }

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ForgingBonus bonus = ForgingBonus.get(event.getPlayer().m_21205_());
        if (bonus != ForgingBonus.NONE) {
            event.setNewSpeed(event.getNewSpeed() * bonus.efficiency());
        }
    }

    public static void onNeighborUpdate(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            for (Direction direction : event.getNotifiedSides()) {
                BlockPos pos = event.getPos().m_142300_(direction);
                BlockState state = level.m_8055_(pos);
                if (Helpers.isBlock(state, TFCTags.Blocks.CAN_LANDSLIDE)) {
                    level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addLandslidePos(pos));
                }
                if (!Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) continue;
                level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addIsolatedPos(pos));
            }
        }
    }

    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (!event.getWorld().f_46443_) {
            event.getWorld().getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addCollapsePositions(new BlockPos(event.getExplosion().getPosition()), event.getAffectedBlocks()));
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.START && (level = event.world) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WeatherHelpers.preAdvancedWeatherCycle(level2);
            level2.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.tick(level2));
        }
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            MinecraftServer server = level.m_142572_();
            if (((Boolean)TFCConfig.SERVER.enableForcedTFCGameRules.get()).booleanValue()) {
                GameRules rules = level.m_46469_();
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46139_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46155_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46124_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46125_)).m_46246_(false, server);
                LOGGER.info("Updating TFC Relevant Game Rules for level {}.", (Object)level.m_46472_().m_135782_());
            }
            Climate.onWorldLoad(level);
            if (level.m_46472_() == Level.f_46428_) {
                ItemSizeManager.applyItemStackSizeOverrides();
                SelfTests.runServerSelfTests();
            }
        }
    }

    public static void onCreateNetherPortal(BlockEvent.PortalSpawnEvent event) {
        if (!((Boolean)TFCConfig.SERVER.enableNetherPortals.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        BlockState state = event.getNewState();
        if (Helpers.isBlock(state, Blocks.f_50069_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GABBRO).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        } else if (Helpers.isBlock(state, Blocks.f_50652_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.RHYOLITE).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        } else if (Helpers.isBlock(state, Blocks.f_50137_)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.HARDENED).get()).m_49966_());
        }
    }

    public static void onFireStart(StartFireEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (block == TFCBlocks.FIREPIT.get() || block == TFCBlocks.POT.get() || block == TFCBlocks.GRILL.get()) {
            AbstractFirepitBlockEntity firepit;
            BlockEntity entity2 = level.m_7702_(pos);
            if (entity2 instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)entity2).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.TORCH.get() || block == TFCBlocks.WALL_TORCH.get()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.TORCH.get()).m_49966_());
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_WALL_TORCH.get()) {
            level.m_46597_(pos, ((Block)TFCBlocks.WALL_TORCH.get()).m_152465_(state));
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.LOG_PILE.get()) {
            BurningLogPileBlock.tryLightLogPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.PIT_KILN.get() && (Integer)state.m_61143_((Property)PitKilnBlock.STAGE) == 15) {
            PitKilnBlockEntity kiln;
            BlockEntity firepit = level.m_7702_(pos);
            if (firepit instanceof PitKilnBlockEntity && (kiln = (PitKilnBlockEntity)firepit).tryLight()) {
                event.setCanceled(true);
                event.setFireResult(StartFireEvent.FireResult.ALWAYS);
            }
        } else if (block == TFCBlocks.CHARCOAL_PILE.get() && (Integer)state.m_61143_((Property)CharcoalPileBlock.LAYERS) >= 7 && CharcoalForgeBlock.isValid((LevelAccessor)level, pos)) {
            CharcoalForgeBlockEntity.createFromCharcoalPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.CHARCOAL_FORGE.get() && CharcoalForgeBlock.isValid((LevelAccessor)level, pos)) {
            CharcoalForgeBlockEntity forge;
            BlockEntity entity3 = level.m_7702_(pos);
            if (entity3 instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)entity3).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.BLOOMERY.get() && !((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
            BloomeryBlockEntity bloomery;
            BlockEntity entity4 = level.m_7702_(pos);
            if (entity4 instanceof BloomeryBlockEntity && (bloomery = (BloomeryBlockEntity)entity4).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.POWDERKEG.get() && ((Boolean)state.m_61143_((Property)PowderkegBlock.SEALED)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(entity -> {
                entity.setLit(true, (Entity)event.getPlayer());
                event.setCanceled(true);
            });
        } else if (block == TFCBlocks.BLAST_FURNACE.get() && !((Boolean)state.m_61143_((Property)BlastFurnaceBlock.LIT)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).ifPresent(blastFurnace -> {
                if (blastFurnace.light(level, pos, state)) {
                    event.setCanceled(true);
                }
            });
        } else if (block instanceof LampBlock) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).ifPresent(lamp -> {
                if (lamp.getFuel() != null) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                    lamp.resetCounter();
                    event.setCanceled(true);
                }
            });
        } else if (block instanceof TFCCandleBlock) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TFCCandleBlock.f_152791_, (Comparable)Boolean.valueOf(true)));
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == Blocks.f_50143_) {
            level.m_46597_(pos, Helpers.copyProperty(((Block)TFCBlocks.JACK_O_LANTERN.get()).m_49966_(), state, HorizontalDirectionalBlock.f_54117_));
            event.setCanceled(true);
        }
    }

    public static void onProjectileImpact(ProjectileImpactEvent event) {
        if (!((Boolean)TFCConfig.SERVER.enableFireArrowSpreading.get()).booleanValue()) {
            return;
        }
        Projectile projectile = event.getProjectile();
        HitResult result = event.getRayTraceResult();
        if (result.m_6662_() == HitResult.Type.BLOCK && projectile.m_6060_()) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.m_82425_();
            StartFireEvent.startFire(projectile.f_19853_, pos, projectile.f_19853_.m_8055_(pos), blockResult.m_82434_(), null, ItemStack.f_41583_);
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        FoodData foodData;
        Player player = event.player;
        Level level = player.m_183503_();
        float angle = Mth.m_14177_((float)player.m_146909_());
        if (angle <= -80.0f && !level.m_5776_() && level.m_46758_(player.m_142538_()) && (foodData = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData2 = (TFCFoodData)foodData;
            foodData2.addThirst(((Double)TFCConfig.SERVER.thirstGainedFromDrinkingInTheRain.get()).floatValue());
        }
        if (!level.m_5776_() && !player.m_7500_() && ((Boolean)TFCConfig.SERVER.enableOverburdening.get()).booleanValue() && level.m_46467_() % 20L == 0L) {
            int hugeHeavyCount = Helpers.countOverburdened((Container)player.m_150109_());
            if (hugeHeavyCount >= 1) {
                player.m_7292_(Helpers.getExhausted(false));
            }
            if (hugeHeavyCount == 2) {
                player.m_7292_(Helpers.getOverburdened(false));
            }
        }
    }

    public static void onEffectRemove(PotionEvent.PotionRemoveEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new EffectExpirePacket(event.getPotion()));
            if (event.getPotion() == TFCEffects.PINNED.get()) {
                player.setForcedPose(null);
            }
        }
    }

    public static void onEffectExpire(PotionEvent.PotionExpiryEvent event) {
        LivingEntity livingEntity;
        MobEffectInstance instance = event.getPotionEffect();
        if (instance != null && (livingEntity = event.getEntityLiving()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new EffectExpirePacket(instance.m_19544_()));
            if (instance.m_19544_() == TFCEffects.PINNED.get()) {
                player.setForcedPose(null);
            }
        }
    }

    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)TFCEffects.PINNED.get())) {
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.f_19812_ = false;
        }
    }

    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        float amount = event.getAmount();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            amount *= ForgingBonus.get(livingEntity.m_21205_()).damage();
        }
        amount *= PhysicalDamageType.calculateMultiplier(event.getSource(), event.getEntity());
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).m_36324_()) instanceof TFCFoodData) {
            TFCFoodData foodData = (TFCFoodData)livingEntity;
            amount /= foodData.getHealthModifier();
        }
        event.setAmount(amount);
    }

    public static void onLivingSpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        LevelAccessor level = event.getWorld();
        MobSpawnType spawn = event.getSpawnReason();
        if ((spawn == MobSpawnType.NATURAL || spawn == MobSpawnType.CHUNK_GENERATION || spawn == MobSpawnType.REINFORCEMENT) && Helpers.isEntity((Entity)entity, TFCTags.Entities.VANILLA_MONSTERS)) {
            if (((Boolean)TFCConfig.SERVER.enableVanillaMonsters.get()).booleanValue()) {
                BlockPos pos;
                if (!(((Boolean)TFCConfig.SERVER.enableVanillaMonstersOnSurface.get()).booleanValue() || level.m_45524_(pos = entity.m_142538_(), 0) == 0 && level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) > pos.m_123342_())) {
                    event.setResult(Event.Result.DENY);
                }
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.loadedFromDisk()) {
            return;
        }
        level = event.getWorld();
        entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) ** GOTO lbl-1000
        itemEntity = (ItemEntity)entity;
        if (!level.f_46443_ && ((Boolean)TFCConfig.SERVER.coolHotItemEntities.get()).booleanValue()) {
            item = itemEntity.m_32055_();
            item.getCapability(HeatCapability.CAPABILITY).ifPresent((NonNullConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onEntityJoinWorld$13(net.minecraft.world.entity.item.ItemEntity net.dries007.tfc.common.capabilities.heat.IHeat ), (Lnet/dries007/tfc/common/capabilities/heat/IHeat;)V)((ItemEntity)itemEntity));
        } else if (entity instanceof LightningBolt) {
            lightning = (LightningBolt)entity;
            if (!level.f_46443_ && !event.isCanceled()) {
                mutable = new BlockPos.MutableBlockPos();
                pos = lightning.m_142538_();
                for (x = -5; x <= 5; ++x) {
                    for (y = -5; y <= 5; ++y) {
                        for (z = -5; z <= 5; ++z) {
                            if (level.f_46441_.nextInt(3) != 0 || x * x + y * y + z * z > 25) continue;
                            mutable.m_122154_((Vec3i)pos, x, y, z);
                            state = level.m_8055_((BlockPos)mutable);
                            modified = state.getToolModifiedState(new UseOnContext(level, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42391_), new BlockHitResult(Vec3.m_82539_((Vec3i)mutable), Direction.DOWN, (BlockPos)mutable, false)), ToolActions.AXE_STRIP, true);
                            if (modified == null) continue;
                            level.m_46597_((BlockPos)mutable, modified);
                        }
                    }
                }
            }
        }
        if (entity instanceof Monster) {
            monster = (Monster)entity;
            if (!((Boolean)TFCConfig.SERVER.enableVanillaMobsSpawningWithVanillaEquipment.get()).booleanValue()) {
                if (Helpers.isItem(monster.m_21120_(InteractionHand.MAIN_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                    monster.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                if (Helpers.isItem(monster.m_21120_(InteractionHand.OFF_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                    monster.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                }
            }
        }
        if (!(entity instanceof Chicken)) ** GOTO lbl-1000
        chicken = (Chicken)entity;
        if (chicken.f_28232_ && !((Boolean)TFCConfig.SERVER.enableChickenJockies.get()).booleanValue()) {
            event.setCanceled(true);
        } else if (entity.m_6095_() == EntityType.f_20525_ && !((Boolean)TFCConfig.SERVER.enableVanillaSkeletonHorseSpawning.get()).booleanValue()) {
            event.setCanceled(true);
        } else if (entity instanceof IronGolem || entity instanceof SnowGolem && ((Boolean)TFCConfig.SERVER.enableVanillaGolems.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onItemExpire(ItemExpireEvent event) {
        if (!((Boolean)TFCConfig.SERVER.coolHotItemEntities.get()).booleanValue()) {
            return;
        }
        ItemEntity entity = event.getEntityItem();
        ServerLevel level = (ServerLevel)entity.m_183503_();
        ItemStack stack = entity.m_32055_();
        BlockPos pos = entity.m_142538_();
        stack.getCapability(HeatCapability.CAPABILITY).ifPresent(heat -> {
            int lifespan = stack.m_41720_().getEntityLifespan(stack, (Level)level);
            if (entity.lifespan >= lifespan) {
                return;
            }
            float itemTemp = heat.getTemperature();
            if (itemTemp > 0.0f) {
                float coolAmount = 0.0f;
                BlockState state = level.m_8055_(pos);
                FluidState fluid = level.m_6425_(pos);
                if (Helpers.isFluid(fluid, (TagKey<Fluid>)FluidTags.f_13131_)) {
                    coolAmount = 50.0f;
                    if (level.f_46441_.nextFloat() < 0.001f) {
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                } else if (Helpers.isBlock(state, Blocks.f_50125_)) {
                    coolAmount = 70.0f;
                    if (level.f_46441_.nextFloat() < 0.1f) {
                        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                        if (layers > 1) {
                            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers - 1)));
                        } else {
                            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        }
                    }
                } else {
                    BlockPos belowPos = pos.m_7495_();
                    BlockState belowState = level.m_8055_(belowPos);
                    if (Helpers.isBlock(belowState, Blocks.f_50127_)) {
                        coolAmount = 75.0f;
                        if (level.f_46441_.nextFloat() < 0.1f) {
                            level.m_46597_(belowPos, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(7)));
                        }
                    } else if (belowState.m_60767_() == Material.f_76276_) {
                        coolAmount = 100.0f;
                        if (level.f_46441_.nextFloat() < 0.01f) {
                            level.m_46597_(belowPos, Helpers.isBlock(belowState, (Block)TFCBlocks.SEA_ICE.get()) ? ((LiquidBlock)TFCBlocks.SALT_WATER.get()).m_49966_() : Blocks.f_49990_.m_49966_());
                        }
                    } else if (belowState.m_60767_() == Material.f_76316_) {
                        coolAmount = 125.0f;
                        if (level.f_46441_.nextFloat() < 0.005f) {
                            level.m_46597_(belowPos, Blocks.f_49990_.m_49966_());
                        }
                    }
                }
                if (coolAmount > 0.0f) {
                    heat.setTemperature(Math.max(0.0f, heat.getTemperature() - coolAmount));
                    Helpers.playSound((Level)level, pos, SoundEvents.f_12031_);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
                event.setExtraLife(heat.getTemperature() == 0.0f ? lifespan : (Integer)TFCConfig.SERVER.ticksBeforeItemCool.get());
            } else {
                event.setExtraLife(lifespan);
            }
            event.setCanceled(true);
        });
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getPlayer());
    }

    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getPlayer());
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getPlayer());
    }

    private static void onNewPlayerInWorld(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TFCFoodData.replaceFoodStats((Player)serverPlayer);
            serverPlayer.f_19853_.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(c -> c.syncTo(serverPlayer));
            serverPlayer.getCapability(PlayerDataCapability.CAPABILITY).ifPresent(PlayerData::sync);
        }
    }

    public static void onServerChat(ServerChatEvent event) {
        long intoxicatedTicks = event.getPlayer().getCapability(PlayerDataCapability.CAPABILITY).map(p -> p.getIntoxicatedTicks(event.getPlayer().m_183503_().m_5776_()) - 6000L).orElse(0L);
        if (intoxicatedTicks > 0L) {
            float intoxicationChance = Mth.m_14036_((float)((float)(intoxicatedTicks - 6000L) / 36000.0f), (float)0.0f, (float)0.7f);
            Random random = event.getPlayer().m_21187_();
            String originalMessage = event.getMessage();
            CharSequence[] words = originalMessage.split(" ");
            for (int i = 0; i < words.length; ++i) {
                int pos;
                Object word = words[i];
                if (((String)word).length() == 0) continue;
                if (random.nextFloat() < intoxicationChance && ((String)word).length() >= 2) {
                    pos = random.nextInt(((String)word).length() - 1);
                    word = ((String)word).substring(0, pos) + ((String)word).charAt(pos + 1) + ((String)word).charAt(pos) + ((String)word).substring(pos + 2);
                }
                if (random.nextFloat() < intoxicationChance) {
                    pos = random.nextInt(((String)word).length());
                    char repeat = ((String)word).charAt(pos);
                    int amount = 1 + random.nextInt(3);
                    word = ((String)word).substring(0, pos) + new String(new char[amount]).replace('\u0000', repeat) + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                if (random.nextFloat() < intoxicationChance) {
                    pos = random.nextInt(((String)word).length());
                    char replacement = ALPHABET.charAt(random.nextInt(ALPHABET.length()));
                    if (Character.isUpperCase(((String)word).charAt(random.nextInt(((String)word).length())))) {
                        replacement = Character.toUpperCase(replacement);
                    }
                    word = ((String)word).substring(0, pos) + replacement + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                words[i] = word;
            }
            event.setComponent((Component)Helpers.translatable("<" + event.getUsername() + "> " + String.join((CharSequence)" ", words)));
        }
    }

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world;
        BlockState state;
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_41619_()) {
            InteractionResult result = Drinkable.attemptDrink(event.getWorld(), event.getPlayer(), true);
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        } else if ((Helpers.isItem(event.getItemStack(), Items.f_42614_) || Helpers.isItem(event.getItemStack(), Items.f_42615_)) && (state = (world = event.getWorld()).m_8055_(event.getPos())).m_60734_() instanceof TFCLecternBlock && LecternBlock.m_153566_((Player)event.getPlayer(), (Level)event.getWorld(), (BlockPos)event.getPos(), (BlockState)state, (ItemStack)event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        Level level = event.getWorld();
        state = level.m_8055_(event.getPos());
        if (state.m_60734_() instanceof AnvilBlock || state.m_60734_() instanceof RockAnvilBlock) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        UseOnContext context = new UseOnContext(event.getPlayer(), event.getHand(), FAKE_MISS);
        InteractionManager.onItemUse(event.getItemStack(), context, true).ifPresent(result -> {
            event.setCanceled(true);
            event.setCancellationResult(result);
        });
    }

    public static void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        InteractionResult result;
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_41619_() && (result = Drinkable.attemptDrink(event.getWorld(), event.getPlayer(), false)) == InteractionResult.SUCCESS) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PlayerDrinkPacket());
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(Fuel.MANAGER);
        event.addListener(Drinkable.MANAGER);
        event.addListener(Support.MANAGER);
        event.addListener(LampFuel.MANAGER);
        event.addListener(Fertilizer.MANAGER);
        event.addListener(ItemSizeManager.MANAGER);
        event.addListener(ClimateRange.MANAGER);
        event.addListener(Fauna.MANAGER);
        event.addListener(HeatCapability.MANAGER);
        event.addListener(FoodCapability.MANAGER);
        event.addListener(EntityDamageResistance.MANAGER);
        Helpers.setCachedRecipeManager(event.getServerResources().m_206887_());
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        PacketHandler.send(target, Metal.MANAGER.createSyncPacket());
        PacketHandler.send(target, Fuel.MANAGER.createSyncPacket());
        PacketHandler.send(target, Fertilizer.MANAGER.createSyncPacket());
        PacketHandler.send(target, HeatCapability.MANAGER.createSyncPacket());
        PacketHandler.send(target, FoodCapability.MANAGER.createSyncPacket());
        PacketHandler.send(target, ItemSizeManager.MANAGER.createSyncPacket());
        PacketHandler.send(target, ClimateRange.MANAGER.createSyncPacket());
        PacketHandler.send(target, Drinkable.MANAGER.createSyncPacket());
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        IndirectHashCollection.reloadAllCaches(Helpers.getUnsafeRecipeManager());
        Support.updateMaximumSupportRange();
        Metal.updateMetalFluidMap();
        ItemSizeManager.applyItemStackSizeOverrides();
        FoodCapability.markRecipeOutputsAsNonDecaying();
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            ClientHelpers.updateSearchTrees();
        }
    }

    public static void onBoneMeal(BonemealEvent event) {
        if (!((Boolean)TFCConfig.SERVER.enableVanillaBonemeal.get()).booleanValue()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static void onSelectClimateModel(SelectClimateModelEvent event) {
        ServerLevel level = event.level();
        if (event.level().m_46472_() == Level.f_46428_ && level.m_7726_().m_8481_() instanceof ChunkGeneratorExtension) {
            event.setModel(new OverworldClimateModel());
        }
    }

    public static void onAnimalTame(AnimalTameEvent event) {
        if (Helpers.isEntity(event.getEntity(), TFCTags.Entities.HORSES)) {
            event.setCanceled(true);
        }
    }

    private static /* synthetic */ void lambda$onEntityJoinWorld$13(ItemEntity itemEntity, IHeat cap) {
        if (cap.getTemperature() > 0.0f) {
            itemEntity.lifespan = (Integer)TFCConfig.SERVER.ticksBeforeItemCool.get();
        }
    }
}

