/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.dries007.tfc.client.ColorMapReloadListener;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.TFCKeyBindings;
import net.dries007.tfc.client.model.ContainedFluidModel;
import net.dries007.tfc.client.model.entity.AlpacaModel;
import net.dries007.tfc.client.model.entity.BearModel;
import net.dries007.tfc.client.model.entity.BluegillModel;
import net.dries007.tfc.client.model.entity.CougarModel;
import net.dries007.tfc.client.model.entity.DuckModel;
import net.dries007.tfc.client.model.entity.HorseshoeCrabModel;
import net.dries007.tfc.client.model.entity.IsopodModel;
import net.dries007.tfc.client.model.entity.JavelinModel;
import net.dries007.tfc.client.model.entity.JellyfishModel;
import net.dries007.tfc.client.model.entity.LionModel;
import net.dries007.tfc.client.model.entity.LobsterModel;
import net.dries007.tfc.client.model.entity.ManateeModel;
import net.dries007.tfc.client.model.entity.MuskOxModel;
import net.dries007.tfc.client.model.entity.OrcaModel;
import net.dries007.tfc.client.model.entity.PenguinModel;
import net.dries007.tfc.client.model.entity.QuailModel;
import net.dries007.tfc.client.model.entity.SabertoothModel;
import net.dries007.tfc.client.model.entity.TFCChickenModel;
import net.dries007.tfc.client.model.entity.TFCCowModel;
import net.dries007.tfc.client.model.entity.TFCGoatModel;
import net.dries007.tfc.client.model.entity.TFCPigModel;
import net.dries007.tfc.client.model.entity.TFCSheepModel;
import net.dries007.tfc.client.model.entity.TFCTurtleModel;
import net.dries007.tfc.client.model.entity.YakModel;
import net.dries007.tfc.client.particle.BubbleParticle;
import net.dries007.tfc.client.particle.GlintParticleProvider;
import net.dries007.tfc.client.particle.LeafParticle;
import net.dries007.tfc.client.particle.SleepParticle;
import net.dries007.tfc.client.particle.SparkParticle;
import net.dries007.tfc.client.particle.SteamParticle;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.client.render.blockentity.AnvilBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BarrelBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.BellowsBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.CrucibleBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.GrillBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.IngotPileBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.LoomBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PitKilnBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PlacedItemBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.PotBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.QuernBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.ScrapingBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.SheetPileBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.SluiceBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCChestBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.TFCSignBlockEntityRenderer;
import net.dries007.tfc.client.render.blockentity.ToolRackBlockEntityRenderer;
import net.dries007.tfc.client.render.entity.AnimalRenderer;
import net.dries007.tfc.client.render.entity.BearRenderer;
import net.dries007.tfc.client.render.entity.GlowArrowRenderer;
import net.dries007.tfc.client.render.entity.JellyfishRenderer;
import net.dries007.tfc.client.render.entity.OctopoteuthisRenderer;
import net.dries007.tfc.client.render.entity.OviparousRenderer;
import net.dries007.tfc.client.render.entity.PenguinRenderer;
import net.dries007.tfc.client.render.entity.SimpleMobRenderer;
import net.dries007.tfc.client.render.entity.TFCBoatRenderer;
import net.dries007.tfc.client.render.entity.TFCChestedHorseRenderer;
import net.dries007.tfc.client.render.entity.TFCFishingHookRenderer;
import net.dries007.tfc.client.render.entity.TFCSquidRenderer;
import net.dries007.tfc.client.render.entity.ThrownJavelinRenderer;
import net.dries007.tfc.client.screen.AnvilPlanScreen;
import net.dries007.tfc.client.screen.AnvilScreen;
import net.dries007.tfc.client.screen.BarrelScreen;
import net.dries007.tfc.client.screen.BlastFurnaceScreen;
import net.dries007.tfc.client.screen.CalendarScreen;
import net.dries007.tfc.client.screen.CharcoalForgeScreen;
import net.dries007.tfc.client.screen.ClimateScreen;
import net.dries007.tfc.client.screen.CrucibleScreen;
import net.dries007.tfc.client.screen.FirepitScreen;
import net.dries007.tfc.client.screen.GrillScreen;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.client.screen.LargeVesselScreen;
import net.dries007.tfc.client.screen.LogPileScreen;
import net.dries007.tfc.client.screen.MoldLikeAlloyScreen;
import net.dries007.tfc.client.screen.NestBoxScreen;
import net.dries007.tfc.client.screen.NutritionScreen;
import net.dries007.tfc.client.screen.PotScreen;
import net.dries007.tfc.client.screen.PowderkegScreen;
import net.dries007.tfc.client.screen.SaladScreen;
import net.dries007.tfc.client.screen.ScribingTableScreen;
import net.dries007.tfc.client.screen.SmallVesselInventoryScreen;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ItemPropertyProviderBlock;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.fluids.FluidType;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.client.accessor.BiomeColorsAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.GoatModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public final class ClientEventHandler {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEventHandler::clientSetup);
        bus.addListener(ClientEventHandler::onConfigReload);
        bus.addListener(ClientEventHandler::registerModelLoaders);
        bus.addListener(ClientEventHandler::registerColorHandlerBlocks);
        bus.addListener(ClientEventHandler::registerColorHandlerItems);
        bus.addListener(ClientEventHandler::registerParticleFactories);
        bus.addListener(ClientEventHandler::registerClientReloadListeners);
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::registerLayerDefinitions);
        bus.addListener(ClientEventHandler::onTextureStitch);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CALENDAR.get()), CalendarScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.NUTRITION.get()), NutritionScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CLIMATE.get()), ClimateScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.SALAD.get()), SaladScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.WORKBENCH.get()), CraftingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.FIREPIT.get()), FirepitScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.GRILL.get()), GrillScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.POT.get()), PotScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.POWDERKEG.get()), PowderkegScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CHARCOAL_FORGE.get()), CharcoalForgeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.LOG_PILE.get()), LogPileScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.NEST_BOX.get()), NestBoxScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CRUCIBLE.get()), CrucibleScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.BARREL.get()), BarrelScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.ANVIL.get()), AnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.ANVIL_PLAN.get()), AnvilPlanScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.BLAST_FURNACE.get()), BlastFurnaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CHEST_9x2.get()), ContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CHEST_9x4.get()), ContainerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.CLAY_KNAPPING.get()), KnappingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.FIRE_CLAY_KNAPPING.get()), KnappingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.LEATHER_KNAPPING.get()), KnappingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.ROCK_KNAPPING.get()), KnappingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.SMALL_VESSEL_INVENTORY.get()), SmallVesselInventoryScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.MOLD_LIKE_ALLOY.get()), MoldLikeAlloyScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.LARGE_VESSEL.get()), LargeVesselScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TFCContainerTypes.SCRIBING_TABLE.get()), ScribingTableScreen::new);
            for (Metal.Default metal : Metal.Default.values()) {
                if (!metal.hasTools()) continue;
                Item rod = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.FISHING_ROD).get();
                ItemProperties.register((Item)rod, (ResourceLocation)Helpers.identifier("cast"), (stack, level, entity, unused) -> {
                    Player player;
                    if (entity == null) {
                        return 0.0f;
                    }
                    return entity instanceof Player && TFCFishingRodItem.isThisTheHeldRod(player = (Player)entity, stack) && player.f_36083_ != null ? 1.0f : 0.0f;
                });
                Item shield = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.SHIELD).get();
                ItemProperties.register((Item)shield, (ResourceLocation)new ResourceLocation("blocking"), (stack, level, entity, unused) -> {
                    if (entity == null) {
                        return 0.0f;
                    }
                    return entity instanceof Player && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
                });
                Item javelin = (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)Metal.ItemType.JAVELIN).get();
                ItemProperties.register((Item)javelin, (ResourceLocation)Helpers.identifier("throwing"), (stack, level, entity, unused) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
            }
            TFCItems.ROCK_TOOLS.values().forEach(tool -> {
                Item javelin = (Item)((RegistryObject)tool.get((Object)RockCategory.ItemType.JAVELIN)).get();
                ItemProperties.register((Item)javelin, (ResourceLocation)Helpers.identifier("throwing"), (stack, level, entity, unused) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
            });
            ItemProperties.register((Item)((Item)TFCItems.FILLED_PAN.get()), (ResourceLocation)Helpers.identifier("stage"), (stack, level, entity, unused) -> {
                Player player;
                if (entity instanceof Player && (player = (Player)entity).m_6117_() && stack == player.m_21205_()) {
                    return (float)player.m_21212_() / 120.0f;
                }
                return 1.0f;
            });
            ItemProperties.register((Item)((Item)TFCItems.FILLED_PAN.get()), (ResourceLocation)OreDeposit.ROCK_PROPERTY.id(), (stack, level, entity, unused) -> {
                BlockState state = PanItem.readState(stack);
                return state != null ? (float)ItemPropertyProviderBlock.getValue(state.m_60734_(), OreDeposit.ROCK_PROPERTY) : 0.0f;
            });
            ItemProperties.register((Item)((Item)TFCItems.FILLED_PAN.get()), (ResourceLocation)OreDeposit.ORE_PROPERTY.id(), (stack, level, entity, unused) -> {
                BlockState state = PanItem.readState(stack);
                return state != null ? (float)ItemPropertyProviderBlock.getValue(state.m_60734_(), OreDeposit.ORE_PROPERTY) : 0.0f;
            });
            ItemProperties.register((Item)((Item)TFCItems.HANDSTONE.get()), (ResourceLocation)Helpers.identifier("damaged"), (stack, level, entity, unused) -> stack.m_41773_() > stack.m_41776_() - 10 ? 1.0f : 0.0f);
            TFCBlocks.WOODS.values().forEach(map -> ItemProperties.register((Item)((Block)((RegistryObject)map.get((Object)Wood.BlockType.BARREL)).get()).m_5456_(), (ResourceLocation)Helpers.identifier("sealed"), (stack, level, entity, unused) -> stack.m_41782_() ? 1.0f : 0.0f));
            ItemProperties.register((Item)((Block)TFCBlocks.POWDERKEG.get()).m_5456_(), (ResourceLocation)Helpers.identifier("sealed"), (stack, level, entity, unused) -> stack.m_41782_() ? 1.0f : 0.0f);
            Stream.of(TFCBlocks.LARGE_VESSEL, TFCBlocks.GLAZED_LARGE_VESSELS.values()).flatMap(Helpers::flatten).forEach(vessel -> ItemProperties.register((Item)((Block)vessel.get()).m_5456_(), (ResourceLocation)Helpers.identifier("sealed"), (stack, level, entity, unused) -> stack.m_41782_() ? 1.0f : 0.0f));
            ItemProperties.register((Item)((Block)TFCBlocks.LIGHT.get()).m_5456_(), (ResourceLocation)new ResourceLocation("level"), (stack, level, entity, unused) -> {
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag != null && stackTag.m_128425_("level", 3)) {
                    return (float)stackTag.m_128451_("level") / 16.0f;
                }
                return 1.0f;
            });
            TFCBlocks.WOODS.values().forEach(map -> ItemProperties.register((Item)((Block)((RegistryObject)map.get((Object)Wood.BlockType.BARREL)).get()).m_5456_(), (ResourceLocation)Helpers.identifier("sealed"), (stack, level, entity, unused) -> stack.m_41782_() ? 1.0f : 0.0f));
        });
        ClientRegistry.registerKeyBinding((KeyMapping)TFCKeyBindings.PLACE_BLOCK);
        ClientRegistry.registerKeyBinding((KeyMapping)TFCKeyBindings.CYCLE_CHISEL_MODE);
        ClientRegistry.registerKeyBinding((KeyMapping)TFCKeyBindings.STACK_FOOD);
        RenderType solid = RenderType.m_110451_();
        RenderType cutout = RenderType.m_110463_();
        RenderType cutoutMipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        TFCBlocks.ROCK_BLOCKS.values().stream().map(map -> (RegistryObject)map.get((Object)Rock.BlockType.SPIKE)).forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.GRADED_ORES.values().forEach(map -> map.values().forEach(inner -> inner.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout))));
        TFCBlocks.ORE_DEPOSITS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.WOODS.values().forEach(map -> {
            Stream.of(Wood.BlockType.SAPLING, Wood.BlockType.DOOR, Wood.BlockType.TRAPDOOR, Wood.BlockType.FENCE, Wood.BlockType.FENCE_GATE, Wood.BlockType.BUTTON, Wood.BlockType.PRESSURE_PLATE, Wood.BlockType.SLAB, Wood.BlockType.STAIRS, Wood.BlockType.TWIG, Wood.BlockType.BARREL, Wood.BlockType.SCRIBING_TABLE).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), (RenderType)cutout));
            Stream.of(Wood.BlockType.LEAVES, Wood.BlockType.FALLEN_LEAVES).forEach(type -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)map.get(type)).get()), layer -> Minecraft.m_91405_() ? layer == cutoutMipped : layer == solid));
        });
        TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        TFCBlocks.SOIL.get((Object)SoilBlockType.CLAY_GRASS).values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutoutMipped));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.PEAT_GRASS.get()), (RenderType)cutoutMipped);
        TFCBlocks.METALS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.GROUNDCOVER.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.SMALL_ORES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.CALCITE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.ICICLE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.SEA_ICE.get()), (RenderType)cutout);
        TFCBlocks.CROPS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.DEAD_CROPS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.WILD_CROPS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.PLANTS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        TFCBlocks.CORAL.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        TFCBlocks.SPREADING_BUSHES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        TFCBlocks.SPREADING_CANES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        TFCBlocks.STATIONARY_BUSHES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.CRANBERRY_BUSH.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_CANE.get()), (RenderType)cutout);
        TFCBlocks.FRUIT_TREE_LEAVES.values().forEach(leaves -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)leaves.get()), (RenderType)cutoutMipped));
        TFCBlocks.FRUIT_TREE_SAPLINGS.values().forEach(leaves -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)leaves.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BANANA_PLANT.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_BANANA_PLANT.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BANANA_SAPLING.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.FIREPIT.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.WALL_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.DEAD_WALL_TORCH.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.WATTLE.get()), (RenderType)cutout);
        TFCBlocks.STAINED_WATTLE.values().forEach(wattle -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)wattle.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.UNSTAINED_WATTLE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.SHEET_PILE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.INGOT_PILE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.COMPOSTER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.BLOOMERY.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.ICE_PILE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFCBlocks.LARGE_VESSEL.get()), (RenderType)cutout);
        TFCBlocks.GLAZED_LARGE_VESSELS.values().forEach(vessel -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)vessel.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SALT_WATER.getFlowing(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SALT_WATER.getSource(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SPRING_WATER.getFlowing(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)TFCFluids.SPRING_WATER.getSource(), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)TFCFluids.RIVER_WATER.get()), (RenderType)translucent);
        BiomeColorsAccessor.accessor$setWaterColorsResolver(TFCColors.FRESH_WATER);
        IngameOverlays.reloadOverlays();
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TFCEntities.FALLING_BLOCK.get(), FallingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FISHING_BOBBER.get(), TFCFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.THROWN_JAVELIN.get(), ThrownJavelinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.GLOW_ARROW.get(), GlowArrowRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.SEAT.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.CHEST_MINECART.get(), ctx -> new MinecartRenderer(ctx, RenderHelpers.modelIdentifier("chest_minecart")));
        for (Wood wood : Wood.VALUES) {
            event.registerEntityRenderer((EntityType)TFCEntities.BOATS.get(wood).get(), ctx -> new TFCBoatRenderer(ctx, wood.m_7912_()));
        }
        event.registerEntityRenderer((EntityType)TFCEntities.COD.get(), CodRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.SALMON.get(), SalmonRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.TROPICAL_FISH.get(), TropicalFishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.PUFFERFISH.get(), PufferfishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.BLUEGILL.get(), ctx -> new SimpleMobRenderer(ctx, new BluegillModel(RenderHelpers.bakeSimple(ctx, "bluegill")), "bluegill", true));
        event.registerEntityRenderer((EntityType)TFCEntities.JELLYFISH.get(), JellyfishRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.LOBSTER.get(), ctx -> new SimpleMobRenderer(ctx, new LobsterModel(RenderHelpers.bakeSimple(ctx, "lobster")), "lobster"));
        event.registerEntityRenderer((EntityType)TFCEntities.CRAYFISH.get(), ctx -> new SimpleMobRenderer(ctx, new LobsterModel(RenderHelpers.bakeSimple(ctx, "crayfish")), "crayfish"));
        event.registerEntityRenderer((EntityType)TFCEntities.ISOPOD.get(), ctx -> new SimpleMobRenderer(ctx, new IsopodModel(RenderHelpers.bakeSimple(ctx, "isopod")), "isopod"));
        event.registerEntityRenderer((EntityType)TFCEntities.HORSESHOE_CRAB.get(), ctx -> new SimpleMobRenderer(ctx, new HorseshoeCrabModel(RenderHelpers.bakeSimple(ctx, "horseshoe_crab")), "horseshoe_crab"));
        event.registerEntityRenderer((EntityType)TFCEntities.DOLPHIN.get(), DolphinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.ORCA.get(), ctx -> new SimpleMobRenderer(ctx, new OrcaModel(RenderHelpers.bakeSimple(ctx, "orca")), "orca"));
        event.registerEntityRenderer((EntityType)TFCEntities.MANATEE.get(), ctx -> new SimpleMobRenderer(ctx, new ManateeModel(RenderHelpers.bakeSimple(ctx, "manatee")), "manatee"));
        event.registerEntityRenderer((EntityType)TFCEntities.TURTLE.get(), ctx -> new SimpleMobRenderer(ctx, new TFCTurtleModel(RenderHelpers.bakeSimple(ctx, "turtle")), "turtle"));
        event.registerEntityRenderer((EntityType)TFCEntities.PENGUIN.get(), PenguinRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.POLAR_BEAR.get(), ctx -> new BearRenderer(ctx, 1.3f, "polar_bear"));
        event.registerEntityRenderer((EntityType)TFCEntities.GRIZZLY_BEAR.get(), ctx -> new BearRenderer(ctx, 1.1f, "grizzly_bear"));
        event.registerEntityRenderer((EntityType)TFCEntities.BLACK_BEAR.get(), ctx -> new BearRenderer(ctx, 0.9f, "black_bear"));
        event.registerEntityRenderer((EntityType)TFCEntities.COUGAR.get(), ctx -> new SimpleMobRenderer(ctx, new CougarModel(RenderHelpers.bakeSimple(ctx, "cougar")), "cougar", 0.8f));
        event.registerEntityRenderer((EntityType)TFCEntities.PANTHER.get(), ctx -> new SimpleMobRenderer(ctx, new CougarModel(RenderHelpers.bakeSimple(ctx, "panther")), "panther", 0.8f));
        event.registerEntityRenderer((EntityType)TFCEntities.LION.get(), ctx -> new SimpleMobRenderer(ctx, new LionModel(RenderHelpers.bakeSimple(ctx, "lion")), "lion", 0.8f));
        event.registerEntityRenderer((EntityType)TFCEntities.SABERTOOTH.get(), ctx -> new SimpleMobRenderer(ctx, new SabertoothModel(RenderHelpers.bakeSimple(ctx, "sabertooth")), "sabertooth", 0.8f));
        event.registerEntityRenderer((EntityType)TFCEntities.SQUID.get(), ctx -> new TFCSquidRenderer(ctx, new SquidModel(RenderHelpers.bakeSimple(ctx, "squid"))));
        event.registerEntityRenderer((EntityType)TFCEntities.OCTOPOTEUTHIS.get(), ctx -> new OctopoteuthisRenderer(ctx, (SquidModel<Octopoteuthis>)new SquidModel(RenderHelpers.bakeSimple(ctx, "glow_squid"))));
        event.registerEntityRenderer((EntityType)TFCEntities.PIG.get(), ctx -> new AnimalRenderer(ctx, new TFCPigModel(RenderHelpers.bakeSimple(ctx, "pig")), "pig"));
        event.registerEntityRenderer((EntityType)TFCEntities.COW.get(), ctx -> new AnimalRenderer(ctx, new TFCCowModel(RenderHelpers.bakeSimple(ctx, "cow")), "cow"));
        event.registerEntityRenderer((EntityType)TFCEntities.GOAT.get(), ctx -> new AnimalRenderer(ctx, new TFCGoatModel(RenderHelpers.bakeSimple(ctx, "goat")), "goat"));
        event.registerEntityRenderer((EntityType)TFCEntities.YAK.get(), ctx -> new AnimalRenderer(ctx, new YakModel(RenderHelpers.bakeSimple(ctx, "yak")), "yak"));
        event.registerEntityRenderer((EntityType)TFCEntities.ALPACA.get(), ctx -> new AnimalRenderer(ctx, new AlpacaModel(RenderHelpers.bakeSimple(ctx, "alpaca")), "alpaca"));
        event.registerEntityRenderer((EntityType)TFCEntities.SHEEP.get(), ctx -> new AnimalRenderer(ctx, new TFCSheepModel(RenderHelpers.bakeSimple(ctx, "sheep")), "sheep"));
        event.registerEntityRenderer((EntityType)TFCEntities.MUSK_OX.get(), ctx -> new AnimalRenderer(ctx, new MuskOxModel(RenderHelpers.bakeSimple(ctx, "musk_ox")), "musk_ox"));
        event.registerEntityRenderer((EntityType)TFCEntities.CHICKEN.get(), ctx -> new OviparousRenderer(ctx, new TFCChickenModel(RenderHelpers.bakeSimple(ctx, "chicken")), "chicken", "rooster", "chick"));
        event.registerEntityRenderer((EntityType)TFCEntities.DUCK.get(), ctx -> new OviparousRenderer(ctx, new DuckModel(RenderHelpers.bakeSimple(ctx, "duck")), "duck", "drake", "duckling"));
        event.registerEntityRenderer((EntityType)TFCEntities.QUAIL.get(), ctx -> new OviparousRenderer(ctx, new QuailModel(RenderHelpers.bakeSimple(ctx, "quail")), "quail", "quail_male", "quail_chick"));
        event.registerEntityRenderer((EntityType)TFCEntities.RABBIT.get(), RabbitRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.FOX.get(), FoxRenderer::new);
        event.registerEntityRenderer((EntityType)TFCEntities.BOAR.get(), ctx -> new SimpleMobRenderer(ctx, new TFCPigModel(RenderHelpers.bakeSimple(ctx, "boar")), "boar", 0.3f, false, 0.6f));
        event.registerEntityRenderer((EntityType)TFCEntities.MULE.get(), ctx -> new TFCChestedHorseRenderer(ctx, 0.92f, ModelLayers.f_171200_, "mule"));
        event.registerEntityRenderer((EntityType)TFCEntities.DONKEY.get(), ctx -> new TFCChestedHorseRenderer(ctx, 0.87f, ModelLayers.f_171132_, "donkey"));
        event.registerEntityRenderer((EntityType)TFCEntities.HORSE.get(), HorseRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.POT.get(), ctx -> new PotBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.GRILL.get(), ctx -> new GrillBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.PLACED_ITEM.get(), ctx -> new PlacedItemBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.PIT_KILN.get(), ctx -> new PitKilnBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.QUERN.get(), ctx -> new QuernBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SCRAPING.get(), ctx -> new ScrapingBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CHEST.get(), TFCChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.TRAPPED_CHEST.get(), TFCChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.LOOM.get(), ctx -> new LoomBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SLUICE.get(), ctx -> new SluiceBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BELLOWS.get(), ctx -> new BellowsBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), ctx -> new ToolRackBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SIGN.get(), TFCSignBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.BARREL.get(), ctx -> new BarrelBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), ctx -> new CrucibleBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.LECTERN.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.ANVIL.get(), ctx -> new AnvilBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.SHEET_PILE.get(), ctx -> new SheetPileBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)TFCBlockEntities.INGOT_PILE.get(), ctx -> new IngotPileBlockEntityRenderer());
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition boatLayer = BoatModel.m_170463_();
        LayerDefinition signLayer = SignRenderer.m_173654_();
        for (Wood wood : Wood.VALUES) {
            event.registerLayerDefinition(TFCBoatRenderer.boatName(wood.m_7912_()), () -> boatLayer);
            event.registerLayerDefinition(RenderHelpers.modelIdentifier("sign/" + wood.name().toLowerCase(Locale.ROOT)), () -> signLayer);
        }
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("bluegill"), BluegillModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("jellyfish"), JellyfishModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("lobster"), LobsterModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("crayfish"), LobsterModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("horseshoe_crab"), HorseshoeCrabModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("isopod"), IsopodModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("orca"), OrcaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("manatee"), ManateeModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("turtle"), TFCTurtleModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("penguin"), PenguinModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("polar_bear"), BearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("grizzly_bear"), BearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("black_bear"), BearModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("cougar"), CougarModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("panther"), CougarModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("lion"), LionModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("sabertooth"), SabertoothModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("squid"), SquidModel::m_170990_);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("glow_squid"), SquidModel::m_170990_);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("pig"), () -> TFCPigModel.createTFCBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("cow"), TFCCowModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("goat"), GoatModel::m_170593_);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("yak"), YakModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("alpaca"), AlpacaModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("sheep"), TFCSheepModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("musk_ox"), MuskOxModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("chicken"), TFCChickenModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("duck"), DuckModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("quail"), QuailModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("boar"), () -> TFCPigModel.createTFCBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("javelin"), JavelinModel::createBodyLayer);
        event.registerLayerDefinition(RenderHelpers.modelIdentifier("chest_minecart"), MinecartModel::m_170738_);
    }

    public static void onConfigReload(ModConfigEvent.Reloading event) {
        IngameOverlays.reloadOverlays();
    }

    public static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Helpers.identifier("contained_fluid"), (IModelLoader)new ContainedFluidModel.Loader());
    }

    public static void registerColorHandlerBlocks(ColorHandlerEvent.Block event) {
        BlockColors registry = event.getBlockColors();
        BlockColor grassColor = (state, worldIn, pos, tintIndex) -> TFCColors.getGrassColor(pos, tintIndex);
        BlockColor tallGrassColor = (state, worldIn, pos, tintIndex) -> TFCColors.getTallGrassColor(pos, tintIndex);
        BlockColor foliageColor = (state, worldIn, pos, tintIndex) -> TFCColors.getFoliageColor(pos, tintIndex);
        BlockColor seasonalFoliageColor = (state, worldIn, pos, tintIndex) -> TFCColors.getSeasonalFoliageColor(pos, tintIndex);
        TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).values().forEach(reg -> registry.m_92589_(grassColor, new Block[]{(Block)reg.get()}));
        TFCBlocks.SOIL.get((Object)SoilBlockType.CLAY_GRASS).values().forEach(reg -> registry.m_92589_(grassColor, new Block[]{(Block)reg.get()}));
        registry.m_92589_(grassColor, new Block[]{(Block)TFCBlocks.PEAT_GRASS.get()});
        TFCBlocks.PLANTS.forEach((plant, reg) -> registry.m_92589_(plant.isTallGrass() ? tallGrassColor : (plant.isSeasonal() ? seasonalFoliageColor : (plant.isFoliage() ? foliageColor : grassColor)), new Block[]{(Block)reg.get()}));
        TFCBlocks.WOODS.forEach((wood, reg) -> registry.m_92589_(wood.isConifer() ? foliageColor : seasonalFoliageColor, new Block[]{(Block)((RegistryObject)reg.get((Object)Wood.BlockType.LEAVES)).get(), (Block)((RegistryObject)reg.get((Object)Wood.BlockType.FALLEN_LEAVES)).get()}));
        TFCBlocks.WILD_CROPS.forEach((crop, reg) -> registry.m_92589_(grassColor, new Block[]{(Block)reg.get()}));
        registry.m_92589_((state, worldIn, pos, tintIndex) -> TFCColors.getWaterColor(pos), new Block[]{(Block)TFCBlocks.SALT_WATER.get(), (Block)TFCBlocks.SEA_ICE.get(), (Block)TFCBlocks.RIVER_WATER.get(), (Block)TFCBlocks.CAULDRONS.get(FluidType.SALT_WATER).get()});
        registry.m_92589_(ClientEventHandler.blockColor(6272440), new Block[]{(Block)TFCBlocks.SPRING_WATER.get(), (Block)TFCBlocks.CAULDRONS.get(FluidType.SPRING_WATER).get()});
        TFCBlocks.CAULDRONS.forEach((type, reg) -> type.color().ifPresent(color -> registry.m_92589_(ClientEventHandler.blockColor(color), new Block[]{(Block)reg.get()})));
    }

    public static void registerColorHandlerItems(ColorHandlerEvent.Item event) {
        ItemColors registry = event.getItemColors();
        ItemColor grassColor = (stack, tintIndex) -> TFCColors.getGrassColor(null, tintIndex);
        ItemColor seasonalFoliageColor = (stack, tintIndex) -> TFCColors.getFoliageColor(null, tintIndex);
        TFCBlocks.PLANTS.forEach((plant, reg) -> {
            if (plant.isItemTinted()) {
                registry.m_92689_(plant.isSeasonal() ? seasonalFoliageColor : grassColor, new ItemLike[]{(ItemLike)reg.get()});
            }
        });
        TFCBlocks.WOODS.forEach((key, value) -> registry.m_92689_(seasonalFoliageColor, new ItemLike[]{(ItemLike)((RegistryObject)value.get((Object)Wood.BlockType.FALLEN_LEAVES)).get(), (ItemLike)((RegistryObject)value.get((Object)Wood.BlockType.LEAVES)).get()}));
        TFCBlocks.WILD_CROPS.forEach((key, value) -> registry.m_92689_(grassColor, new ItemLike[]{((Block)value.get()).m_5456_()}));
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setSkyColors, TFCColors.SKY_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFogColors, TFCColors.FOG_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setWaterColors, TFCColors.WATER_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setWaterFogColors, TFCColors.WATER_FOG_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setGrassColors, TFCColors.GRASS_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setTallGrassColors, TFCColors.TALL_GRASS_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageColors, TFCColors.FOLIAGE_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageFallColors, TFCColors.FOLIAGE_FALL_COLORS_LOCATION));
        event.registerReloadListener((PreparableReloadListener)new ColorMapReloadListener(TFCColors::setFoliageWinterColors, TFCColors.FOLIAGE_WINTER_COLORS_LOCATION));
    }

    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        particleEngine.m_107378_((ParticleType)TFCParticles.BUBBLE.get(), BubbleParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)TFCParticles.STEAM.get(), SteamParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)TFCParticles.NITROGEN.get(), set -> new GlintParticleProvider(set, ChatFormatting.AQUA));
        particleEngine.m_107378_((ParticleType)TFCParticles.PHOSPHORUS.get(), set -> new GlintParticleProvider(set, ChatFormatting.GOLD));
        particleEngine.m_107378_((ParticleType)TFCParticles.POTASSIUM.get(), set -> new GlintParticleProvider(set, ChatFormatting.LIGHT_PURPLE));
        particleEngine.m_107378_((ParticleType)TFCParticles.COMPOST_READY.get(), set -> new GlintParticleProvider(set, ChatFormatting.GRAY));
        particleEngine.m_107378_((ParticleType)TFCParticles.COMPOST_ROTTEN.get(), set -> new GlintParticleProvider(set, ChatFormatting.DARK_RED));
        particleEngine.m_107378_((ParticleType)TFCParticles.SLEEP.get(), SleepParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)TFCParticles.LEAF.get(), LeafParticle.Provider::new);
        particleEngine.m_107378_((ParticleType)TFCParticles.SPARK.get(), SparkParticle.Provider::new);
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation sheet = event.getAtlas().m_118330_();
        if (sheet.equals((Object)RenderHelpers.BLOCKS_ATLAS)) {
            event.addSprite(Helpers.identifier("block/burlap"));
            event.addSprite(Helpers.identifier("block/devices/bellows/back"));
            event.addSprite(Helpers.identifier("block/devices/bellows/side"));
            for (Metal.Default metal : Metal.Default.values()) {
                event.addSprite(Helpers.identifier("block/metal/full/" + metal.m_7912_()));
            }
            for (String texture : (List)TFCConfig.CLIENT.additionalMetalSheetTextures.get()) {
                event.addSprite(new ResourceLocation(texture));
            }
        } else if (sheet.equals((Object)Sheets.f_110740_)) {
            Arrays.stream(Wood.VALUES).map(Wood::m_7912_).forEach(name -> {
                event.addSprite(Helpers.identifier("entity/chest/normal/" + name));
                event.addSprite(Helpers.identifier("entity/chest/normal_left/" + name));
                event.addSprite(Helpers.identifier("entity/chest/normal_right/" + name));
                event.addSprite(Helpers.identifier("entity/chest/trapped/" + name));
                event.addSprite(Helpers.identifier("entity/chest/trapped_left/" + name));
                event.addSprite(Helpers.identifier("entity/chest/trapped_right/" + name));
            });
        } else if (sheet.equals((Object)Sheets.f_110739_)) {
            Arrays.stream(Wood.VALUES).map(Wood::m_7912_).forEach(name -> event.addSprite(Helpers.identifier("entity/signs/" + name)));
        }
    }

    private static BlockColor blockColor(int color) {
        return (state, level, pos, tintIndex) -> color;
    }
}

