/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Objects;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ClientHelpers {
    public static final Direction[] DIRECTIONS_AND_NULL = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN, Direction.UP, null};
    public static final ResourceLocation GUI_ICONS = new ResourceLocation("tfc", "textures/gui/icons.png");

    @Nullable
    public static Level getLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static Level getLevelOrThrow() {
        return Objects.requireNonNull(ClientHelpers.getLevel());
    }

    @Nullable
    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Player getPlayerOrThrow() {
        return Objects.requireNonNull(ClientHelpers.getPlayer());
    }

    @Nullable
    public static BlockPos getTargetedPos() {
        HitResult hitResult;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (hitResult = mc.f_91077_) instanceof BlockHitResult) {
            BlockHitResult block = (BlockHitResult)hitResult;
            return block.m_82425_();
        }
        return null;
    }

    public static boolean hasShiftDown() {
        return Screen.m_96638_();
    }

    public static void updateSearchTrees() {
        MutableSearchTree namesTree = Minecraft.m_91087_().m_91171_(SearchRegistry.f_119941_);
        MutableSearchTree tagsTree = Minecraft.m_91087_().m_91171_(SearchRegistry.f_119942_);
        namesTree.m_7716_();
        tagsTree.m_7716_();
        NonNullList items = NonNullList.m_122779_();
        for (Item item : ForgeRegistries.ITEMS) {
            item.m_6787_(CreativeModeTab.f_40754_, items);
        }
        items.forEach(stack -> {
            FoodCapability.setStackNonDecaying(stack);
            namesTree.m_8080_(stack);
            tagsTree.m_8080_(stack);
        });
        namesTree.m_7729_();
        tagsTree.m_7729_();
    }
}

