/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.dries007.tfc.client.ClientHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.Nullable;

public interface IGhostBlockHandler {
    default public boolean draw(Level level, Player player, BlockState lookState, BlockPos lookPos, Vec3 location, Direction lookDirection, PoseStack stack, MultiBufferSource buffer, ItemStack item) {
        BlockState state = this.getStateToDraw(level, player, lookState, lookDirection, lookPos, location.f_82479_ - (double)lookPos.m_123341_(), location.f_82480_ - (double)lookPos.m_123342_(), location.f_82481_ - (double)lookPos.m_123343_(), item);
        if (state == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockModelShaper shaper = mc.m_91289_().m_110907_();
        BakedModel model = shaper.m_110893_(state);
        if (model == shaper.m_110881_().m_119409_()) {
            return false;
        }
        ForgeHooksClient.setRenderType((RenderType)RenderType.m_110466_());
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110466_());
        stack.m_85836_();
        Vec3 camera = mc.f_91063_.m_109153_().m_90583_();
        stack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        stack.m_85837_((double)lookPos.m_123341_(), (double)lookPos.m_123342_(), (double)lookPos.m_123343_());
        if (this.shouldGrowSlightly()) {
            stack.m_85837_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            stack.m_85841_(1.01f, 1.01f, 1.01f);
        }
        PoseStack.Pose pose = stack.m_85850_();
        Arrays.stream(ClientHelpers.DIRECTIONS_AND_NULL).flatMap(dir -> model.getQuads(state, dir, level.f_46441_, (IModelData)EmptyModelData.INSTANCE).stream()).forEach(quad -> consumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, this.alpha(), LevelRenderer.m_109537_((BlockAndTintGetter)level, (BlockState)state, (BlockPos)lookPos), OverlayTexture.f_118083_));
        ((MultiBufferSource.BufferSource)buffer).m_109912_(RenderType.m_110466_());
        ForgeHooksClient.setRenderType(null);
        stack.m_85849_();
        return true;
    }

    default public boolean shouldGrowSlightly() {
        return true;
    }

    default public float alpha() {
        return 0.66f;
    }

    @Nullable
    public BlockState getStateToDraw(Level var1, Player var2, BlockState var3, Direction var4, BlockPos var5, double var6, double var8, double var10, ItemStack var12);
}

