/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class TFCSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"tfc");
    public static final RegistryObject<SoundEvent> KNAP_STONE = TFCSounds.create("item.knapping.stone");
    public static final RegistryObject<SoundEvent> KNAP_CLAY = TFCSounds.create("item.knapping.clay");
    public static final RegistryObject<SoundEvent> KNAP_LEATHER = TFCSounds.create("item.knapping.leather");
    public static final RegistryObject<SoundEvent> FIRESTARTER = TFCSounds.create("item.firestarter.use");
    public static final RegistryObject<SoundEvent> CERAMIC_BREAK = TFCSounds.create("item.ceramic.break");
    public static final RegistryObject<SoundEvent> JUG_BLOW = TFCSounds.create("item.jug.blow");
    public static final RegistryObject<SoundEvent> PANNING = TFCSounds.create("item.pan.use");
    public static final RegistryObject<SoundEvent> QUERN_DRAG = TFCSounds.create("block.quern.drag");
    public static final RegistryObject<SoundEvent> LOOM_WEAVE = TFCSounds.create("block.loom.weave");
    public static final RegistryObject<SoundEvent> TOOL_RACK_PLACE = TFCSounds.create("block.tool_rack.place");
    public static final RegistryObject<SoundEvent> BELLOWS_BLOW = TFCSounds.create("block.bellows.blow");
    public static final RegistryObject<SoundEvent> SCRIBING_TABLE = TFCSounds.create("block.scribing_table.use");
    public static final RegistryObject<SoundEvent> OPEN_VESSEL = TFCSounds.create("block.large_vessel.open");
    public static final RegistryObject<SoundEvent> CLOSE_VESSEL = TFCSounds.create("block.large_vessel.close");
    public static final RegistryObject<SoundEvent> WATTLE_DYED = TFCSounds.create("block.wattle.dyed");
    public static final RegistryObject<SoundEvent> WATTLE_DAUBED = TFCSounds.create("block.wattle.daubed");
    public static final RegistryObject<SoundEvent> WATTLE_WOVEN = TFCSounds.create("block.wattle.woven");
    public static final Map<TFCArmorMaterials, RegistryObject<SoundEvent>> ARMOR_EQUIP = Helpers.mapOfKeys(TFCArmorMaterials.class, mat -> TFCSounds.create("item.armor.equip_" + mat.getId().m_135815_()));
    public static final ForgeSoundType CHARCOAL = TFCSounds.createBlock("charcoal");
    public static final ForgeSoundType THATCH = TFCSounds.createBlock("thatch");
    public static final ForgeSoundType PEAT = TFCSounds.createBlock("peat");
    public static final ForgeSoundType THIN = TFCSounds.createBlock("thin");
    public static final EntitySound PIG = new EntitySound(() -> SoundEvents.f_12233_, () -> SoundEvents.f_12234_, () -> SoundEvents.f_12235_, () -> SoundEvents.f_12237_);
    public static final EntitySound COW = new EntitySound(() -> SoundEvents.f_11830_, () -> SoundEvents.f_11831_, () -> SoundEvents.f_11832_, () -> SoundEvents.f_11834_);
    public static final EntitySound CHICKEN = new EntitySound(() -> SoundEvents.f_11750_, () -> SoundEvents.f_11751_, () -> SoundEvents.f_11753_, () -> SoundEvents.f_11754_);
    public static final EntitySound GOAT = new EntitySound(() -> SoundEvents.f_144163_, () -> SoundEvents.f_144164_, () -> SoundEvents.f_144166_, () -> SoundEvents.f_144151_);
    public static final EntitySound SHEEP = new EntitySound(() -> SoundEvents.f_12341_, () -> SoundEvents.f_12342_, () -> SoundEvents.f_12343_, () -> SoundEvents.f_12345_);
    public static final EntitySound DONKEY = new EntitySound(() -> SoundEvents.f_11809_, () -> SoundEvents.f_11812_, () -> SoundEvents.f_11814_, () -> SoundEvents.f_12035_);
    public static final EntitySound MULE = new EntitySound(() -> SoundEvents.f_12076_, () -> SoundEvents.f_12079_, () -> SoundEvents.f_12081_, () -> SoundEvents.f_12035_);
    public static final EntitySound HORSE = new EntitySound(() -> SoundEvents.f_11971_, () -> SoundEvents.f_11975_, () -> SoundEvents.f_11978_, () -> SoundEvents.f_12035_);
    public static final EntitySound ALPACA = TFCSounds.createEntity("alpaca", false, false);
    public static final EntitySound YAK = TFCSounds.createEntity("yak", false, false);
    public static final EntitySound MUSK_OX = TFCSounds.createEntity("musk_ox", false, false);
    public static final EntitySound DUCK = TFCSounds.createEntity("duck", false, false);
    public static final EntitySound QUAIL = TFCSounds.createEntity("quail", false, false);
    public static final EntitySound LION = TFCSounds.createEntity("lion", true, true);
    public static final EntitySound COUGAR = TFCSounds.createEntity("cougar", true, true);
    public static final EntitySound SABERTOOTH = TFCSounds.createEntity("sabertooth", true, true);
    public static final EntitySound BEAR = TFCSounds.createEntity("bear", true, true);
    public static final RegistryObject<SoundEvent> ROCK_SLIDE_LONG = TFCSounds.create("random.rock_slide_long");
    public static final RegistryObject<SoundEvent> ROCK_SLIDE_SHORT = TFCSounds.create("random.rock_slide_short");
    public static final RegistryObject<SoundEvent> DIRT_SLIDE_SHORT = TFCSounds.create("random.dirt_slide_short");

    private static RegistryObject<SoundEvent> create(String name) {
        return SOUNDS.register(name, () -> new SoundEvent(Helpers.identifier(name)));
    }

    private static Optional<Supplier<SoundEvent>> createOptional(String name, boolean present) {
        return Optional.ofNullable(present ? TFCSounds.create(name) : null);
    }

    private static ForgeSoundType createBlock(String name) {
        return new ForgeSoundType(1.0f, 1.0f, TFCSounds.create("block.%s.break".formatted(name)), TFCSounds.create("block.%s.step".formatted(name)), TFCSounds.create("block.%s.place".formatted(name)), TFCSounds.create("block.%s.hit".formatted(name)), TFCSounds.create("block.%s.fall".formatted(name)));
    }

    private static EntitySound createEntity(String name, boolean attack, boolean sleep) {
        return new EntitySound((Supplier<SoundEvent>)TFCSounds.create("entity.%s.ambient".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.death".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.hurt".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.step".formatted(name)), TFCSounds.createOptional("entity.%s.attack".formatted(name), attack), TFCSounds.createOptional("entity.%s.sleep".formatted(name), sleep));
    }

    public record EntitySound(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> step, Optional<Supplier<SoundEvent>> attack, Optional<Supplier<SoundEvent>> sleep) {
        public EntitySound(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> step) {
            this(ambient, death, hurt, step, Optional.empty(), Optional.empty());
        }
    }
}

