/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.dries007.tfc.client.model.Easing;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public record Animation(int lengthInTicks, float lengthScale, Map<String, Bone> bones) {
    public static ImmutableMap<ModelPart, PartPose> initDefaults(Map<String, ModelPart> parts) {
        ImmutableMap.Builder rotationsMap = new ImmutableMap.Builder();
        parts.forEach((s, part) -> rotationsMap.put(part, (Object)part.m_171308_()));
        return rotationsMap.build();
    }

    @Nullable
    private static Vector3f getTransformForTime(Map<Float, Vector3f> times, float totalProgress, Easing easing) {
        if (!times.isEmpty()) {
            Map.Entry<Float, Vector3f> current = null;
            Map.Entry<Float, Vector3f> next = null;
            for (Map.Entry<Float, Vector3f> entry : times.entrySet()) {
                if (totalProgress >= entry.getKey().floatValue()) {
                    current = entry;
                    continue;
                }
                next = entry;
                break;
            }
            if (current != null && next != null) {
                return Animation.lerp(current, next, totalProgress, easing);
            }
        }
        return null;
    }

    private static Vector3f lerp(Map.Entry<Float, Vector3f> a, Map.Entry<Float, Vector3f> b, float totalProgress, Easing easing) {
        float time = easing.apply(Mth.m_184637_((float)totalProgress, (float)a.getKey().floatValue(), (float)b.getKey().floatValue(), (float)0.0f, (float)1.0f));
        Vector3f start = a.getValue();
        Vector3f end = b.getValue();
        return new Vector3f(Mth.m_14179_((float)time, (float)start.m_122239_(), (float)end.m_122239_()), Mth.m_14179_((float)time, (float)start.m_122260_(), (float)end.m_122260_()), Mth.m_14179_((float)time, (float)start.m_122269_(), (float)end.m_122269_()));
    }

    public void tick(Map<String, ModelPart> map, float ageInTicks) {
        float progress = ageInTicks % (float)this.lengthInTicks / (float)this.lengthInTicks * this.lengthScale;
        this.bones.forEach((name, bone) -> {
            ModelPart part = (ModelPart)map.get(name);
            Vector3f rotations = Animation.getTransformForTime(bone.rotations, progress, bone.easing);
            Vector3f translations = Animation.getTransformForTime(bone.translations, progress, bone.easing);
            if (rotations != null) {
                part.m_171327_(rotations.m_122239_(), rotations.m_122260_(), rotations.m_122269_());
            }
            if (translations != null) {
                part.f_104200_ = translations.m_122239_();
                part.f_104201_ = translations.m_122260_();
                part.f_104202_ = translations.m_122269_();
            }
        });
    }

    public record Bone(Map<Float, Vector3f> rotations, Map<Float, Vector3f> translations, Map<Float, Vector3f> scales, Easing easing) {

        public static class Builder {
            private final Easing easing;
            private final ImmutableMap.Builder<Float, Vector3f> rotationBuilder = new ImmutableMap.Builder();
            private final ImmutableMap.Builder<Float, Vector3f> translationBuilder = new ImmutableMap.Builder();
            private final ImmutableMap.Builder<Float, Vector3f> scaleBuilder = new ImmutableMap.Builder();

            public Builder(Easing easing) {
                this.easing = easing;
            }

            public Builder rotation(float time, float x, float y, float z) {
                this.rotationBuilder.put((Object)Float.valueOf(time), (Object)new Vector3f(x / 180.0f * (float)Math.PI, y / 180.0f * (float)Math.PI, z / 180.0f * (float)Math.PI));
                return this;
            }

            public Builder translation(float time, float x, float y, float z) {
                this.translationBuilder.put((Object)Float.valueOf(time), (Object)new Vector3f(x / 180.0f * (float)Math.PI, y / 180.0f * (float)Math.PI, z / 180.0f * (float)Math.PI));
                return this;
            }

            public Builder scale(float time, float x, float y, float z) {
                this.scaleBuilder.put((Object)Float.valueOf(time), (Object)new Vector3f(x / 180.0f * (float)Math.PI, y / 180.0f * (float)Math.PI, z / 180.0f * (float)Math.PI));
                return this;
            }

            public Builder noRotation(float time) {
                this.rotationBuilder.put((Object)Float.valueOf(time), (Object)Vector3f.f_176763_);
                return this;
            }

            public Bone build() {
                return new Bone((Map<Float, Vector3f>)this.rotationBuilder.build(), (Map<Float, Vector3f>)this.translationBuilder.build(), (Map<Float, Vector3f>)this.scaleBuilder.build(), this.easing);
            }
        }
    }

    public static class Builder {
        private final float lengthScale;
        private final int lengthInTicks;
        private final ImmutableMap.Builder<String, Bone> boneBuilder;

        public Builder(float length) {
            this.lengthScale = length;
            this.lengthInTicks = Mth.m_14143_((float)(length * 20.0f));
            this.boneBuilder = new ImmutableMap.Builder();
        }

        public Builder bone(String name, Bone bone) {
            this.boneBuilder.put((Object)name, (Object)bone);
            return this;
        }

        public Animation build() {
            return new Animation(this.lengthInTicks, this.lengthScale, (Map<String, Bone>)this.boneBuilder.build());
        }
    }
}

