/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.jetbrains.annotations.Nullable;

public class ContainedFluidModel
implements IModelGeometry<ContainedFluidModel> {
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    private final Fluid fluid;

    public ContainedFluidModel(Fluid fluid) {
        this.fluid = fluid;
    }

    public ContainedFluidModel withFluid(Fluid newFluid) {
        return new ContainedFluidModel(newFluid);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        Material baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        Material fluidMaskLocation = owner.isTexturePresent("fluid") ? owner.resolveTexture("fluid") : null;
        Material coverLocation = owner.isTexturePresent("cover") ? owner.resolveTexture("cover") : null;
        ModelState transformsFromModel = owner.getCombinedTransform();
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)this.fluid.getAttributes().getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && baseLocation != null ? spriteGetter.apply(coverLocation) : null;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite == null ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, Helpers.identifier("block/empty"))) : fluidSprite;
        }
        Transformation transform = modelTransform.m_6189_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)Objects.requireNonNull(particleSprite), (ItemOverrides)new ContainedFluidItemOverride(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseLocation), (Transformation)transform, spriteGetter));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = this.fluid.getAttributes().getLuminosity();
            int color = this.fluid.getAttributes().getColor();
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)1, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)1, (int)luminosity));
        }
        if (coverSprite != null) {
            TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.4685f, (Direction)Direction.NORTH, (int)-1, (int)2));
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.5315f, (Direction)Direction.SOUTH, (int)-1, (int)2));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        if (owner.isTexturePresent("particle")) {
            textures.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            textures.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid")) {
            textures.add(owner.resolveTexture("fluid"));
        }
        if (owner.isTexturePresent("cover")) {
            textures.add(owner.resolveTexture("cover"));
        }
        return textures;
    }

    private static final class ContainedFluidItemOverride
    extends ItemOverrides {
        private final Map<Fluid, BakedModel> cache = new HashMap<Fluid, BakedModel>();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final ContainedFluidModel parent;

        private ContainedFluidItemOverride(ItemOverrides nested, ModelBakery bakery, IModelConfiguration owner, ContainedFluidModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            return stack.getCapability(Capabilities.FLUID).map(cap -> {
                Fluid fluid = cap.getFluidInTank(0).getFluid();
                return this.cache.computeIfAbsent(fluid, key -> {
                    ContainedFluidModel unbaked = this.parent.withFluid((Fluid)key);
                    return unbaked.bake(this.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("forge:bucket_override"));
                });
            }).orElse(originalModel);
        }
    }

    public static class Loader
    implements IModelLoader<ContainedFluidModel> {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public ContainedFluidModel read(JsonDeserializationContext context, JsonObject json) {
            return new ContainedFluidModel(Fluids.f_76191_);
        }
    }
}

