/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.dries007.tfc.client.model.Animation;
import net.dries007.tfc.client.model.Easing;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Pose;

public class CougarModel
extends EntityModel<FelinePredator> {
    public static final Animation WALK = new Animation.Builder(1.0f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 0.0f, 0.0f, -1.0f).rotation(0.5f, 0.0f, 0.0f, 1.0f).rotation(1.0f, 0.0f, 0.0f, -1.0f).build()).bone("tail", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -30.0f, 0.0f, 0.0f).rotation(0.25f, -30.43855f, 7.05302f, -7.10708f).rotation(0.75f, -30.47002f, -6.45856f, 6.51352f).rotation(1.0f, -30.0f, 0.0f, 0.0f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 50.0f, 0.0f, 0.0f).rotation(0.375f, 51.16156f, 8.64738f, 15.27269f).rotation(0.875f, 67.99327f, -4.47045f, -7.80797f).rotation(1.0f, 50.0f, 0.0f, 0.0f).build()).bone("head", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 0.0f, 0.0f, 1.0f).rotation(0.5f, 0.0f, 0.0f, -1.0f).rotation(1.0f, 0.0f, 0.0f, 1.0f).build()).bone("right_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.25f, 22.5f, 0.0f, 0.0f).noRotation(0.5f).rotation(0.75f, -22.5f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("left_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.25f, -22.5f, 0.0f, 0.0f).noRotation(0.5417f).rotation(0.75f, 22.5f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("left_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, -22.5f, 0.0f, 0.0f).noRotation(0.4167f).rotation(0.75f, 22.5f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("right_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.25f, 22.5f, 0.0f, 0.0f).noRotation(0.5f).rotation(0.75f, -22.5f, 0.0f, 0.0f).noRotation(1.0f).build()).build();
    public static final Animation RUN = new Animation.Builder(0.5f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, -7.5f, 0.0f, 0.0f).noRotation(0.3333f).rotation(0.4167f, 4.69f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("tail", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.2083f, 60.0f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.25f, -90.0f, 0.0f, 0.0f).rotation(0.4167f, -2.5f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("head", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, 7.5f, 0.0f, 0.0f).noRotation(0.3333f).rotation(0.4167f, -4.69f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("right_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, -32.5f, 0.0f, 0.0f).rotation(0.375f, 25.5f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("left_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.125f, -32.5f, 0.0f, 0.0f).rotation(0.3333f, 25.5f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("left_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.125f, 40.0f, 0.0f, 0.0f).rotation(0.3333f, -30.0f, 0.0f, 0.0f).noRotation(0.5f).build()).bone("right_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, 40.0f, 0.0f, 0.0f).rotation(0.375f, -30.0f, 0.0f, 0.0f).noRotation(0.5f).build()).build();
    public static final Animation ATTACK = new Animation.Builder(0.4f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, -15.0f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("neck", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.2083f, 15.0f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("jaw", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.2083f, 15.0f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("right_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.0833f, -21.8848f, 23.55077f, 9.29137f).rotation(0.1667f, -58.9136f, 17.66308f, 6.96853f).noRotation(0.4f).build()).bone("left_front_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.0833f, -17.5f, 0.0f, -20.0f).rotation(0.1667f, -65.625f, 0.0f, -15.0f).noRotation(0.4f).build()).bone("rear", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).noRotation(0.4f).build()).bone("tail", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, 95.0f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, -109.17912f, 0.0f, 0.0f).rotation(0.25f, -32.51868f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("left_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, 15.0f, 0.0f, 0.0f).noRotation(0.4f).build()).bone("right_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.1667f, 17.5f, 0.0f, 0.0f).noRotation(0.4f).build()).build();
    public static final Animation SLEEP = new Animation.Builder(2.0f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 5.0f, 0.0f, 72.5f).rotation(0.5f, 5.0f, 0.0f, 72.5f).rotation(2.0f, 5.0f, 0.0f, 72.5f).build()).bone("neck", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 90.0f, 0.0f, 0.0f).rotation(2.0f, 90.0f, 0.0f, 0.0f).build()).bone("tail", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -35.17255f, 2.54237f, -1.37822f).rotation(0.0833f, -34.83923f, -11.59079f, 19.36245f).rotation(0.5f, -35.17255f, 2.54237f, -1.37822f).rotation(0.75f, -35.28937f, 4.0f, -3.43513f).rotation(2.0f, -35.17255f, 2.54237f, -1.37822f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 14.0f, -12.27659f, 12.56853f).rotation(0.0833f, -13.0f, 14.0f, -14.43276f).rotation(0.1667f, 11.0f, -16.87977f, 18.66145f).rotation(0.5f, -14.0f, -12.27659f, 12.56853f).rotation(0.75f, -15.0f, -8.80349f, 8.90928f).rotation(2.0f, -14.0f, -12.27659f, 12.56853f).build()).bone("right_front_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 0.22267f, 4.02155f, 6.33586f).rotation(0.5f, 0.22267f, 4.02155f, 6.33586f).rotation(2.0f, 0.22267f, 4.02155f, 6.33586f).build()).bone("left_front_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 15.0f, 0.0f, 12.5f).rotation(0.5f, 15.0f, 0.0f, 12.5f).rotation(2.0f, 15.0f, 0.0f, 12.5f).build()).bone("left_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 12.5f, 0.0f, 12.5f).rotation(0.5f, 12.5f, 0.0f, 12.5f).rotation(2.0f, 12.5f, 0.0f, 12.5f).build()).bone("rear", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -45.0f, 0.0f, 0.0f).rotation(0.5f, -45.0f, 0.0f, 0.0f).rotation(2.0f, -45.0f, 0.0f, 0.0f).build()).build();
    public static final Animation CROUCH = new Animation.Builder(1.0f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 20.0f, 0.0f, -1.0f).rotation(0.5f, 18.0f, 0.0f, 1.0f).rotation(1.0f, 20.0f, 0.0f, -1.0f).build()).bone("tail", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -55.0f, 0.0f, 0.0f).rotation(0.25f, -45.4385f, 7.05302f, -7.10708f).rotation(0.75f, -45.47f, -6.45856f, 6.51352f).rotation(1.0f, -55.0f, 0.0f, 0.0f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 60.0f, 0.0f, 0.0f).rotation(0.375f, 61.1616f, 8.64738f, 15.27269f).rotation(0.875f, 77.9933f, -4.47045f, -7.80797f).rotation(1.0f, 60.0f, 0.0f, 0.0f).build()).bone("head", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, 0.0f, 0.0f, 1.0f).rotation(0.5f, 0.0f, 0.0f, -1.0f).rotation(1.0f, 0.0f, 0.0f, 1.0f).build()).bone("right_front_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -75.0f, 0.0f, 0.0f).rotation(0.25f, -65.0f, 0.0f, 0.0f).rotation(0.5f, -75.0f, 0.0f, 0.0f).rotation(0.75f, -80.0f, 0.0f, 0.0f).rotation(1.0f, -75.0f, 0.0f, 0.0f).build()).bone("left_front_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -75.0f, 0.0f, 0.0f).rotation(0.25f, -80.0f, 0.0f, 0.0f).rotation(0.5417f, -75.0f, 0.0f, 0.0f).rotation(0.75f, -65.0f, 0.0f, 0.0f).rotation(1.0f, -75.0f, 0.0f, 0.0f).build()).bone("left_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -10.0f, 0.0f, 0.0f).rotation(0.1667f, -22.5f, 0.0f, 0.0f).rotation(0.4167f, -10.0f, 0.0f, 0.0f).rotation(0.75f, 2.5f, 0.0f, 0.0f).rotation(1.0f, -10.0f, 0.0f, 0.0f).build()).bone("right_hind_leg", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -10.0f, 0.0f, 0.0f).rotation(0.25f, 2.5f, 0.0f, 0.0f).rotation(0.5f, -10.0f, 0.0f, 0.0f).rotation(0.75f, -22.5f, 0.0f, 0.0f).rotation(1.0f, -10.0f, 0.0f, 0.0f).build()).bone("neck", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -7.5f, 0.0f, 0.0f).rotation(0.5f, -5.5f, 0.0f, 0.0f).rotation(1.0f, -7.5f, 0.0f, 0.0f).build()).build();
    public final Map<String, ModelPart> parts;
    public final Map<ModelPart, PartPose> defaults;
    private final ModelPart body;
    private final ModelPart tail1;
    private final ModelPart tail;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart legFR;
    private final ModelPart legBR;
    private final ModelPart legFL;
    private final ModelPart legBL;
    private final ModelPart earL;
    private final ModelPart earR;
    private final ModelPart jaw;
    private final ModelPart nose;
    private final ModelPart rear;
    private float prevLimbSwing;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -15.0f, -8.0f, 7.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-2.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)-7.0f));
        PartDefinition neck0_r1 = neck.m_171599_("neck0_r1", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-2.0f, -1.5f, -3.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 8).m_171488_(-2.0f, -1.0f, -8.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-1.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(12, 48).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-5.5f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(13, 36).m_171488_(-1.0f, -1.1743f, -3.9924f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition earL = head.m_171599_("earL", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)-0.1745f));
        PartDefinition earR = head.m_171599_("earR", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.1745f));
        PartDefinition legFR = body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(35, 35).m_171488_(-1.0f, -2.0f, 0.0f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(47, 38).m_171488_(-1.0f, 12.0f, -1.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-14.0f, (float)-7.0f));
        PartDefinition legFL = body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(-2.0f, -2.0f, 0.0f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(47, 44).m_171488_(-2.0f, 12.0f, -1.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-14.0f, (float)-7.0f));
        PartDefinition rear = body.m_171599_("rear", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)4.0f));
        PartDefinition tail = rear.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(38, 23).m_171488_(-2.0f, -1.5f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)7.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = tail.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-1.0f, -0.5f, -0.366f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-1.0f, (float)7.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition legBL = rear.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(49, 6).m_171488_(-1.0f, 5.0f, 1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(18, 38).m_171488_(-1.0f, -2.0f, -1.0f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(-1.0f, 10.0f, 0.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)3.0f, (float)3.0f));
        PartDefinition legBR = rear.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, 5.0f, 2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(38, 11).m_171488_(-6.0f, -2.0f, 0.0f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(44, 32).m_171488_(-6.0f, 10.0f, 1.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)3.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public CougarModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.rear = this.body.m_171324_("rear");
        this.tail = this.rear.m_171324_("tail");
        this.tail1 = this.tail.m_171324_("tail1");
        this.head = this.neck.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.nose = this.head.m_171324_("nose");
        this.earL = this.head.m_171324_("earL");
        this.earR = this.head.m_171324_("earR");
        this.legFR = this.body.m_171324_("right_front_leg");
        this.legFL = this.body.m_171324_("left_front_leg");
        this.legBR = this.rear.m_171324_("right_hind_leg");
        this.legBL = this.rear.m_171324_("left_hind_leg");
        this.parts = new ImmutableMap.Builder().put((Object)"body", (Object)this.body).put((Object)"tail", (Object)this.tail).put((Object)"tail1", (Object)this.tail1).put((Object)"head", (Object)this.head).put((Object)"jaw", (Object)this.jaw).put((Object)"earL", (Object)this.earL).put((Object)"earR", (Object)this.earR).put((Object)"right_front_leg", (Object)this.legFR).put((Object)"left_front_leg", (Object)this.legFL).put((Object)"right_hind_leg", (Object)this.legBR).put((Object)"left_hind_leg", (Object)this.legBL).put((Object)"nose", (Object)this.nose).put((Object)"neck", (Object)this.neck).put((Object)"rear", (Object)this.rear).build();
        this.defaults = Animation.initDefaults(this.parts);
    }

    public void setupAnim(FelinePredator felinePredator, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaults.forEach(ModelPart::m_171322_);
        felinePredator.setLimbSwing(Math.min(Math.max((limbSwing - this.prevLimbSwing) * 10.0f, 0.4f), 1.4f));
        this.prevLimbSwing = limbSwing;
        if (felinePredator.m_5803_()) {
            this.body.f_104200_ = -8.0f;
            this.body.f_104202_ = -2.0f;
            SLEEP.tick(this.parts, ageInTicks);
        } else {
            if (felinePredator.getAttackTicks() > 0) {
                ATTACK.tick(this.parts, ageInTicks);
            } else if (felinePredator.m_20089_() == Pose.CROUCHING) {
                this.body.f_104201_ = 28.0f;
                CROUCH.tick(this.parts, felinePredator.walkProgress);
            } else if (felinePredator.walkProgress > 0.0f || felinePredator.isMoving()) {
                if (felinePredator.m_5912_()) {
                    RUN.tick(this.parts, ageInTicks);
                } else {
                    WALK.tick(this.parts, felinePredator.walkProgress);
                }
            }
            this.head.f_104203_ = netHeadYaw * (float)Math.PI / 720.0f;
            this.neck.f_104203_ = netHeadYaw * (float)Math.PI / 720.0f;
            this.head.f_104204_ = headPitch * (float)Math.PI / 360.0f;
            this.neck.f_104204_ = headPitch * (float)Math.PI / 360.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

