/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.dries007.tfc.client.model.Animation;
import net.dries007.tfc.client.model.Easing;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LobsterModel
extends EntityModel<AquaticCritter> {
    public static final Animation SWIM = new Animation.Builder(0.45f).bone("body", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -170.0f, 0.0f, -180.0f).rotation(0.125f, -180.0f, 0.0f, -180.0f).rotation(0.45f, -170.0f, 0.0f, -180.0f).build()).bone("tail1", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -30.0f, 0.0f, 0.0f).rotation(0.0417f, -60.0f, 0.0f, 0.0f).rotation(0.125f, -60.0f, 0.0f, 0.0f).rotation(0.45f, -30.0f, 0.0f, 0.0f).build()).bone("tail2", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -50.0f, 0.0f, 0.0f).rotation(0.0833f, -80.0f, 0.0f, 0.0f).rotation(0.125f, -80.0f, 0.0f, 0.0f).rotation(0.45f, -50.0f, 0.0f, 0.0f).build()).bone("tail3", new Animation.Bone.Builder(Easing.LINEAR).rotation(0.0f, -47.5f, 0.0f, 0.0f).rotation(0.125f, -77.5f, 0.0f, 0.0f).rotation(0.45f, -47.5f, 0.0f, 0.0f).build()).bone("armLeft", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.125f, 0.0f, 27.5f, 0.0f).noRotation(0.45f).build()).bone("armRight", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.125f, 0.0f, -37.5f, 0.0f).noRotation(0.45f).build()).build();
    public final Map<String, ModelPart> parts;
    public final Map<ModelPart, PartPose> defaults;
    private final ModelPart body;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart rightAntenna;
    private final ModelPart leftAntenna;
    private final ModelPart armLeft;
    private final ModelPart armRight;
    private final ModelPart clawTopLeft;
    private final ModelPart clawTopRight;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tail1 = body.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(13, 5).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition rightAntenna = body.m_171599_("rightAntenna", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.0f));
        PartDefinition skinny_r1 = rightAntenna.m_171599_("skinny_r1", CubeListBuilder.m_171558_().m_171514_(8, 14).m_171488_(0.0f, -4.75f, -0.5f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)-2.5f, (float)-0.6981f, (float)0.0f, (float)0.6109f));
        PartDefinition leftAntenna = body.m_171599_("leftAntenna", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)0.0f));
        PartDefinition skinny_r2 = leftAntenna.m_171599_("skinny_r2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(0.0f, -4.75f, -0.5f, 0.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)-2.5f, (float)-0.6981f, (float)0.0f, (float)-0.6109f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(10, 9).m_171488_(0.0f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition clawLeft = armLeft.m_171599_("clawLeft", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition clawBottomLeft = clawLeft.m_171599_("clawBottomLeft", CubeListBuilder.m_171558_().m_171514_(14, 2).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition clawTopLeft = clawLeft.m_171599_("clawTopLeft", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171488_(0.0f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition clawRight = armRight.m_171599_("clawRight", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition clawBottomRight = clawRight.m_171599_("clawBottomRight", CubeListBuilder.m_171558_().m_171514_(6, 12).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition clawTopRight = clawRight.m_171599_("clawTopRight", CubeListBuilder.m_171558_().m_171514_(10, 13).m_171488_(-1.0f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition legsLeft = body.m_171599_("legsLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)-1.0f, (float)-1.0f));
        PartDefinition cube_r1 = legsLeft.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(4, 7).m_171488_(0.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition legsRight = body.m_171599_("legsRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)-1.0f, (float)-1.0f));
        PartDefinition cube_r2 = legsRight.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-2.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public LobsterModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tail1 = this.body.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.tail3 = this.tail2.m_171324_("tail3");
        this.rightAntenna = this.body.m_171324_("rightAntenna");
        this.leftAntenna = this.body.m_171324_("leftAntenna");
        this.armLeft = this.body.m_171324_("armLeft");
        this.armRight = this.body.m_171324_("armRight");
        this.clawTopLeft = this.armLeft.m_171324_("clawLeft").m_171324_("clawTopLeft");
        this.clawTopRight = this.armRight.m_171324_("clawRight").m_171324_("clawTopRight");
        this.parts = new ImmutableMap.Builder().put((Object)"body", (Object)this.body).put((Object)"tail1", (Object)this.tail1).put((Object)"tail2", (Object)this.tail2).put((Object)"tail3", (Object)this.tail3).put((Object)"leftAntenna", (Object)this.leftAntenna).put((Object)"rightAntenna", (Object)this.rightAntenna).put((Object)"armLeft", (Object)this.armLeft).put((Object)"armRight", (Object)this.armRight).put((Object)"clawTopLeft", (Object)this.clawTopLeft).put((Object)"clawTopRight", (Object)this.clawTopRight).build();
        this.defaults = Animation.initDefaults(this.parts);
    }

    public void setupAnim(AquaticCritter entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaults.forEach(ModelPart::m_171322_);
        if (!entity.m_20096_()) {
            float adjustedAgeInTicks = ageInTicks + limbSwingAmount * 2.0f;
            SWIM.tick(this.parts, adjustedAgeInTicks);
        } else {
            float oscillation;
            this.armLeft.f_104203_ = oscillation = 0.2f * Mth.m_14089_((float)(0.2f * ageInTicks));
            this.armRight.f_104203_ = -1.0f * oscillation;
            this.tail1.f_104203_ = oscillation * 0.5f;
            this.rightAntenna.f_104205_ = oscillation * 0.1f;
            this.leftAntenna.f_104205_ = oscillation * -0.1f;
            this.clawTopLeft.f_104203_ = oscillation * 0.1f;
            this.clawTopRight.f_104203_ = oscillation * -0.1f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

