/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.dries007.tfc.client.model.Animation;
import net.dries007.tfc.client.model.Easing;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PenguinModel
extends EntityModel<AmphibiousAnimal> {
    public static final Animation WALK = new Animation.Builder(1.0f).bone("core", new Animation.Bone.Builder(Easing.EASE_IN_OUT_CUBIC).rotation(0.0f, 0.0f, 0.0f, 15.0f).rotation(0.5f, 0.0f, 0.0f, -15.0f).rotation(1.0f, 0.0f, 0.0f, 15.0f).build()).bone("head", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.33f, 0.0f, 0.0f, -15.0f).rotation(0.66f, 0.0f, 0.0f, 15.0f).noRotation(1.0f).build()).bone("leftFoot", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 45.0f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("rightFoot", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, -45.0f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("leftWing", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 25.0f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("rightWing", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 25.0f, 0.0f, 0.0f).noRotation(1.0f).build()).build();
    public static final Animation SWIM = new Animation.Builder(0.5f).bone("leftFoot", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 45.0f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("rightFoot", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, -45.0f, 0.0f, 0.0f).noRotation(1.0f).build()).bone("leftWing", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 0.0f, 0.0f, -25.0f).noRotation(1.0f).build()).bone("rightWing", new Animation.Bone.Builder(Easing.LINEAR).noRotation(0.0f).rotation(0.5f, 0.0f, 0.0f, 25.0f).noRotation(1.0f).build()).build();
    public final Map<String, ModelPart> parts;
    public final Map<ModelPart, PartPose> defaults;
    private final ModelPart core;
    private final ModelPart head;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition core = partdefinition.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition core_r1 = core.m_171599_("core_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -9.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head = core.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(16, 4).m_171488_(-1.0f, -10.0f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(13, 9).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition leftfoot = core.m_171599_("leftfoot", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(1.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition rightfoot = core.m_171599_("rightfoot", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftwing = core.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightwing = core.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(8, 12).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public PenguinModel(ModelPart root) {
        this.core = root.m_171324_("core");
        this.head = this.core.m_171324_("head");
        this.leftFoot = this.core.m_171324_("leftfoot");
        this.rightFoot = this.core.m_171324_("rightfoot");
        this.leftWing = this.core.m_171324_("leftwing");
        this.rightWing = this.core.m_171324_("rightwing");
        this.parts = new ImmutableMap.Builder().put((Object)"core", (Object)this.core).put((Object)"head", (Object)this.head).put((Object)"leftFoot", (Object)this.leftFoot).put((Object)"rightFoot", (Object)this.rightFoot).put((Object)"leftWing", (Object)this.leftWing).put((Object)"rightWing", (Object)this.rightWing).build();
        this.defaults = Animation.initDefaults(this.parts);
    }

    public void setupAnim(AmphibiousAnimal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaults.forEach(ModelPart::m_171322_);
        if (entity.isPlayingDead()) {
            this.core.f_104203_ = -1.5707964f;
        } else {
            if (entity.m_20184_().m_82556_() > 0.0) {
                float adjustedAgeInTicks = ageInTicks + limbSwingAmount * 2.0f;
                if (entity.m_20069_()) {
                    SWIM.tick(this.parts, adjustedAgeInTicks);
                } else {
                    WALK.tick(this.parts, adjustedAgeInTicks);
                }
            }
            this.head.f_104203_ = entity.m_20069_() ? -1.0f : headPitch * (float)Math.PI / 180.0f;
            this.head.f_104204_ = netHeadYaw * (float)Math.PI / 180.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.core.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

