/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ScrapingBlockEntityRenderer
implements BlockEntityRenderer<ScrapingBlockEntity> {
    public void render(ScrapingBlockEntity scraping, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        scraping.getCapability(Capabilities.ITEM).ifPresent(cap -> {
            ItemStack baseStack = cap.getStackInSlot(0);
            ItemStack scrapeStack = scraping.getCachedItem();
            if (!baseStack.m_41619_() && !scrapeStack.m_41619_()) {
                ItemModelShaper shaper = Minecraft.m_91087_().m_91291_().m_115103_();
                ResourceLocation base = shaper.m_109406_(baseStack).getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_();
                ResourceLocation scraped = shaper.m_109406_(scrapeStack).getParticleIcon((IModelData)EmptyModelData.INSTANCE).m_118413_();
                short positions = scraping.getScrapedPositions();
                this.drawTiles(buffer, poseStack, base, positions, 0, combinedLight, combinedOverlay);
                this.drawTiles(buffer, poseStack, scraped, positions, 1, combinedLight, combinedOverlay);
            }
        });
    }

    private void drawTiles(MultiBufferSource buffer, PoseStack poseStack, ResourceLocation texture, short positions, int condition, int combinedLight, int combinedOverlay) {
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        for (int xOffset = 0; xOffset < 4; ++xOffset) {
            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                if ((positions >> xOffset + 4 * zOffset & 1) != condition) continue;
                builder.m_85982_(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0), sprite.m_118393_((double)zOffset * 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f + 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0), sprite.m_118393_((double)zOffset * 4.0 + 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f + 0.25f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0 + 4.0), sprite.m_118393_((double)zOffset * 4.0 + 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0 + 4.0), sprite.m_118393_((double)zOffset * 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
    }
}

