/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class AnimalRenderer<T extends TFCAnimal, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation young;
    private final ResourceLocation old;

    public AnimalRenderer(EntityRendererProvider.Context ctx, M model, String name) {
        this(ctx, model, name, 0.3f);
    }

    public AnimalRenderer(EntityRendererProvider.Context ctx, M model, String name, float shadow) {
        super(ctx, model, shadow);
        this.young = Helpers.animalTexture(name + "_young");
        this.old = Helpers.animalTexture(name + "_old");
    }

    public ResourceLocation getTextureLocation(T entity) {
        return RenderHelpers.getTextureForAge(entity, this.young, this.old);
    }
}

