/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class SimpleMobRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final ResourceLocation texture;
    private final boolean doesFlop;
    private final float scale;

    public SimpleMobRenderer(EntityRendererProvider.Context ctx, M model, String name) {
        this(ctx, model, name, 0.3f, false, 1.0f);
    }

    public SimpleMobRenderer(EntityRendererProvider.Context ctx, M model, String name, float shadow) {
        this(ctx, model, name, shadow, false, 1.0f);
    }

    public SimpleMobRenderer(EntityRendererProvider.Context ctx, M model, String name, boolean flop) {
        this(ctx, model, name, 0.3f, flop, 1.0f);
    }

    public SimpleMobRenderer(EntityRendererProvider.Context ctx, M model, String name, float shadow, boolean flop, float scale) {
        super(ctx, model, shadow);
        this.doesFlop = flop;
        this.texture = Helpers.animalTexture(name);
        this.scale = scale;
    }

    protected void setupRotations(T entity, PoseStack stack, float age, float yaw, float partialTicks) {
        super.m_7523_(entity, stack, age, yaw, partialTicks);
        if (this.doesFlop) {
            float amplitude = 1.0f;
            float deg = 1.0f;
            if (!entity.m_20069_()) {
                amplitude = 1.3f;
                deg = 1.7f;
            }
            float yRot = amplitude * 4.3f * Mth.m_14031_((float)(deg * 0.6f * age));
            stack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
            stack.m_85837_(0.0, 0.0, (double)-0.4f);
            if (!entity.m_20069_()) {
                stack.m_85837_((double)0.2f, (double)0.1f, 0.0);
                stack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
        }
    }

    protected void scale(T entity, PoseStack poseStack, float scale) {
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        super.m_7546_(entity, poseStack, scale);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }
}

