/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.util.AlloyView;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CrucibleScreen
extends BlockEntityScreen<CrucibleBlockEntity, CrucibleContainer> {
    private static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/crucible.png");
    private static final int MAX_ELEMENTS = 3;
    private int scrollPos;
    private boolean scrollPress;

    public CrucibleScreen(CrucibleContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 55;
        this.f_97727_ += 55;
        this.scrollPos = 0;
        this.scrollPress = false;
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.f_97735_ + 154) && mouseX <= (double)(this.f_97735_ + 165) && mouseY >= (double)(this.f_97736_ + 11 + this.scrollPos) && mouseY <= (double)(this.f_97736_ + 26 + this.scrollPos)) {
            this.scrollPress = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrollPress) {
            this.scrollPos = Math.min(Math.max((int)mouseY - this.f_97736_ - 18, 0), 49);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.scrollPress && button == 0) {
            this.scrollPress = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int temperature = (int)(51.0f * ((CrucibleBlockEntity)this.blockEntity).getTemperature() / Heat.maxVisibleTemperature());
        if (temperature > 0) {
            this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 131 - Math.min(temperature, 51), 176, 0, 15, 5);
        }
        this.m_93228_(poseStack, this.f_97735_ + 154, this.f_97736_ + 11 + this.scrollPos, 176, 7, 12, 15);
        AlloyView alloy = ((CrucibleBlockEntity)this.blockEntity).getAlloy();
        if (alloy.getAmount() > 0) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(alloy.getResultAsFluidStack());
            int startY = 93;
            int endY = 124;
            int fillHeight = (int)Math.ceil(31.0f * (float)alloy.getAmount() / (float)alloy.getMaxUnits());
            RenderHelpers.fillAreaWithSprite(this.f_97735_, this.f_97736_, sprite, poseStack, 97, 133, 124, fillHeight);
            this.resetToBackgroundSprite();
            Metal result = alloy.getResult(ClientHelpers.getLevelOrThrow());
            String resultText = ChatFormatting.UNDERLINE + I18n.m_118938_((String)result.getTranslationKey(), (Object[])new Object[0]);
            this.f_96547_.m_92883_(poseStack, resultText, (float)(this.f_97735_ + 10), (float)(this.f_97736_ + 11), 0);
            int startElement = Math.max(0, (int)Math.floor((double)(alloy.getMetals().size() - 3) / 49.0 * (double)(this.scrollPos + 1)));
            int yPos = this.f_97736_ + 22;
            int index = -1;
            for (Object2DoubleMap.Entry entry : alloy.getMetals().object2DoubleEntrySet()) {
                if (++index < startElement) continue;
                if (index > startElement - 1 + 3) break;
                Object metalName = this.f_96547_.m_92834_(I18n.m_118938_((String)((Metal)entry.getKey()).getTranslationKey(), (Object[])new Object[0]), 141);
                metalName = (String)metalName + ":";
                String units = entry.getDoubleValue() >= 1.0 ? I18n.m_118938_((String)"tfc.tooltip.fluid_units", (Object[])new Object[]{Math.round(entry.getDoubleValue())}) : I18n.m_118938_((String)"tfc.tooltip.less_than_one_fluid_units", (Object[])new Object[0]);
                String content = String.format("  %s (%s%2.1f%%%s)", units, ChatFormatting.DARK_GREEN, Float.valueOf((float)Math.round(1000.0 * entry.getDoubleValue() / (double)alloy.getAmount()) / 10.0f), ChatFormatting.RESET);
                this.f_96547_.m_92883_(poseStack, (String)metalName, (float)(this.f_97735_ + 10), (float)yPos, 0x404040);
                this.f_96547_.m_92883_(poseStack, content, (float)(this.f_97735_ + 10), (float)(yPos + 9), 0x404040);
                yPos += 18;
            }
        }
    }
}

